/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.patch.commands;

import io.fabric8.patch.Service;
import io.fabric8.patch.management.BundleUpdate;
import io.fabric8.patch.management.Patch;
import io.fabric8.patch.management.PatchException;
import io.fabric8.patch.management.PatchResult;
import io.fabric8.patch.management.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.karaf.shell.console.AbstractAction;

public abstract class PatchActionSupport
extends AbstractAction {
    protected Service service;

    protected PatchActionSupport(Service service) {
        this.service = service;
    }

    protected Object doExecute() throws Exception {
        this.doExecute(this.service);
        return null;
    }

    protected abstract void doExecute(Service var1) throws Exception;

    protected void display(PatchResult result) {
        int l1 = "[name]".length();
        int l2 = "[old]".length();
        int l3 = "[new]".length();
        for (BundleUpdate update : result.getBundleUpdates()) {
            if (update.getSymbolicName() != null && Utils.stripSymbolicName((String)update.getSymbolicName()).length() > l1) {
                l1 = Utils.stripSymbolicName((String)update.getSymbolicName()).length();
            }
            if (update.getPreviousVersion().length() > l2) {
                l2 = update.getPreviousVersion().length();
            }
            if (update.getNewVersion().length() <= l3) continue;
            l3 = update.getNewVersion().length();
        }
        System.out.println(String.format("%-" + l1 + "s   %-" + l2 + "s   %-" + l3 + "s", "[name]", "[old]", "[new]"));
        ArrayList updates = new ArrayList(result.getBundleUpdates());
        Collections.sort(updates, new Comparator<BundleUpdate>(){

            @Override
            public int compare(BundleUpdate o1, BundleUpdate o2) {
                return o1.getSymbolicName().compareTo(o2.getSymbolicName());
            }
        });
        for (BundleUpdate update : updates) {
            System.out.println(String.format("%-" + l1 + "s | %-" + l2 + "s | %-" + l3 + "s", update.getSymbolicName() == null ? "" : Utils.stripSymbolicName((String)update.getSymbolicName()), update.getPreviousVersion(), update.getNewVersion()));
        }
    }

    protected void display(Iterable<Patch> patches, boolean listBundles) {
        String desc;
        String[] kb;
        int l1 = "[name]".length();
        int l2 = "[installed]".length();
        int l3 = "[description]".length();
        for (Patch patch : patches) {
            if (patch.getPatchData().getId().length() > l1) {
                l1 = patch.getPatchData().getId().length();
            }
            if (patch.getResult() != null) {
                List karafBases;
                List versions = patch.getResult().getVersions();
                if (versions.size() > 0) {
                    for (String v : versions) {
                        if (("Version " + v).length() <= l2) continue;
                        l2 = ("Version " + v).length();
                    }
                }
                if ((karafBases = patch.getResult().getKarafBases()).size() > 0) {
                    for (String kbt : karafBases) {
                        kb = kbt.split("\\s*\\|\\s*");
                        if (kb[0].length() <= l2) continue;
                        l2 = kb[0].length();
                    }
                }
            }
            if ((desc = patch.getPatchData().getDescription() != null ? patch.getPatchData().getDescription() : "").length() <= l3) continue;
            l3 = desc.length();
        }
        System.out.println(String.format("%-" + l1 + "s %-" + l2 + "s %-" + l3 + "s", "[name]", "[installed]", "[description]"));
        for (Patch patch : patches) {
            desc = patch.getPatchData().getDescription() != null ? patch.getPatchData().getDescription() : "";
            String installed = Boolean.toString(patch.isInstalled());
            boolean fabric = false;
            if (patch.getResult() != null) {
                if (patch.getResult().getVersions().size() > 0) {
                    installed = "Version " + (String)patch.getResult().getVersions().get(0);
                    fabric = true;
                } else if (patch.getResult().getKarafBases().size() > 0) {
                    String kbt;
                    kbt = (String)patch.getResult().getKarafBases().get(0);
                    kb = kbt.split("\\s*\\|\\s*");
                    installed = kb[0];
                }
            }
            System.out.println(String.format("%-" + l1 + "s %-" + l2 + "s %-" + l3 + "s", patch.getPatchData().getId(), installed, desc));
            if (fabric && patch.getResult() != null && patch.getResult().getVersions().size() > 1) {
                for (String v : patch.getResult().getVersions().subList(1, patch.getResult().getVersions().size())) {
                    System.out.println(String.format("%-" + l1 + "s %-" + l2 + "s %-" + l3 + "s", " ", "Version " + v, " "));
                }
            }
            if (!fabric && patch.getResult() != null && patch.getResult().getKarafBases().size() > 1) {
                for (String kbt : patch.getResult().getKarafBases().subList(1, patch.getResult().getKarafBases().size())) {
                    String[] kb2 = kbt.split("\\s*\\|\\s*");
                    System.out.println(String.format("%-" + l1 + "s %-" + l2 + "s %-" + l3 + "s", " ", kb2[0], " "));
                }
            }
            if (!listBundles) continue;
            for (String b : patch.getPatchData().getBundles()) {
                System.out.println(String.format(" - %s", b));
            }
        }
    }

    protected Patch getPatch(String patchId) {
        Patch patch = this.service.getPatch(patchId);
        if (patch == null) {
            throw new PatchException("Patch '" + patchId + "' not found");
        }
        if (patch.isInstalled()) {
            throw new PatchException("Patch '" + patchId + "' is already installed");
        }
        return patch;
    }
}

