/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.api;

import io.fabric8.api.DynamicReference;
import io.fabric8.api.jcip.ThreadSafe;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.TimeUnit;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

@ThreadSafe
public final class ServiceProxy<T> {
    public static long DEFAULT_TIMEOUT = 30000L;
    private final Class<T> serviceClazz;
    private final DelegatingInvocationHandler<T> invocationHandler;

    public static <T> ServiceProxy<T> createServiceProxy(BundleContext bundleContext, Class<T> serviceClazz) {
        return new ServiceProxy<T>(bundleContext, serviceClazz, DEFAULT_TIMEOUT, TimeUnit.MILLISECONDS);
    }

    public static <T> ServiceProxy<T> createServiceProxy(BundleContext bundleContext, Class<T> serviceClazz, long timeout, TimeUnit timeUnit) {
        return new ServiceProxy<T>(bundleContext, serviceClazz, timeout, timeUnit);
    }

    private ServiceProxy(BundleContext bundleContext, Class<T> serviceClazz, long timeout, TimeUnit timeUnit) {
        this.invocationHandler = new DelegatingInvocationHandler<T>(bundleContext, serviceClazz, timeout, timeUnit);
        this.serviceClazz = serviceClazz;
    }

    public T getService() {
        return (T)Proxy.newProxyInstance(this.serviceClazz.getClassLoader(), new Class[]{this.serviceClazz}, this.invocationHandler);
    }

    public void close() {
        this.invocationHandler.close();
    }

    static class DelegatingInvocationHandler<T>
    implements InvocationHandler {
        private final DynamicReference<T> dynamicReference;
        private final ServiceTracker<T, T> tracker;

        DelegatingInvocationHandler(BundleContext context, Class<T> type, long timeout, TimeUnit unit) {
            this.dynamicReference = new DynamicReference(type.getSimpleName(), timeout, unit);
            this.tracker = new ServiceTracker<T, T>(context, type, null){

                public T addingService(ServiceReference<T> reference) {
                    Object service = super.addingService(reference);
                    DelegatingInvocationHandler.this.dynamicReference.bind(service);
                    return service;
                }

                public void modifiedService(ServiceReference<T> reference, T service) {
                    super.modifiedService(reference, service);
                    DelegatingInvocationHandler.this.dynamicReference.bind(service);
                }

                public void removedService(ServiceReference<T> reference, T service) {
                    super.removedService(reference, service);
                    DelegatingInvocationHandler.this.dynamicReference.unbind(service);
                }
            };
            this.tracker.open();
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                T service = this.dynamicReference.get();
                return method.invoke(service, args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }

        void close() {
            this.tracker.close();
        }
    }
}

