/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jpm.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.util.HashMap;
import org.apache.karaf.jpm.Process;
import org.apache.karaf.jpm.impl.ScriptUtils;

public class ProcessImpl
implements Process {
    private int pid;

    public ProcessImpl(int pid) {
        this.pid = pid;
    }

    @Override
    public int getPid() {
        return this.pid;
    }

    @Override
    public boolean isRunning() throws IOException {
        if (ScriptUtils.isWindows()) {
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("${pid}", Integer.toString(this.pid));
            int ret = ScriptUtils.execute("running", props);
            return ret == 0;
        }
        try {
            java.lang.Process process = new ProcessBuilder("ps", "-p", Integer.toString(this.pid)).start();
            BufferedReader r = new BufferedReader(new InputStreamReader(process.getInputStream()));
            r.readLine();
            String s = r.readLine();
            boolean running = s != null && s.length() > 0;
            int ret = process.waitFor();
            return running;
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
    }

    @Override
    public void destroy() throws IOException {
        int ret;
        if (ScriptUtils.isWindows()) {
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("${pid}", Integer.toString(this.pid));
            ret = ScriptUtils.execute("destroy", props);
        } else {
            ret = ScriptUtils.executeProcess(new ProcessBuilder("kill", "-9", Integer.toString(this.pid)));
        }
        if (ret != 0) {
            throw new IOException("Unable to destroy process, it may be already terminated");
        }
    }

    public int waitFor() throws InterruptedException {
        return 0;
    }

    public int exitValue() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Process create(File dir, String command) throws IOException {
        File pidFile = File.createTempFile("jpm.", ".pid");
        try {
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("${pid.file}", pidFile.getCanonicalPath());
            props.put("${dir}", dir != null ? dir.getCanonicalPath() : "");
            if (ScriptUtils.isWindows()) {
                command = command.replaceAll("\"", "\"\"");
            }
            props.put("${command}", command);
            int ret = ScriptUtils.execute("start", props);
            if (ret != 0) {
                throw new IOException("Unable to create process (error code: " + ret + ")");
            }
            int pid = ProcessImpl.readPid(pidFile);
            ProcessImpl processImpl = new ProcessImpl(pid);
            return processImpl;
        }
        finally {
            pidFile.delete();
        }
    }

    public static Process attach(int pid) throws IOException {
        return new ProcessImpl(pid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int readPid(File pidFile) throws IOException {
        FileInputStream is = new FileInputStream(pidFile);
        try {
            BufferedReader r = new BufferedReader(new InputStreamReader(is));
            String pidString = r.readLine();
            int n = Integer.valueOf(pidString);
            return n;
        }
        finally {
            try {
                ((InputStream)is).close();
            }
            catch (IOException iOException) {}
        }
    }
}

