/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.management.mbeans.log.internal;

import java.io.IOException;
import java.util.Dictionary;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.apache.karaf.management.mbeans.log.LogMBean;
import org.ops4j.pax.logging.spi.PaxLoggingEvent;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public class LogMBeanImpl
extends StandardMBean
implements LogMBean {
    static final String CONFIGURATION_PID = "org.ops4j.pax.logging";
    static final String ROOT_LOGGER_PREFIX = "log4j.rootLogger";
    static final String LOGGER_PREFIX = "log4j.logger.";
    static final String ROOT_LOGGER = "ROOT";
    private BundleContext bundleContext;

    public LogMBeanImpl() throws NotCompliantMBeanException {
        super(LogMBean.class);
    }

    @Override
    public void setLevel(String level) throws Exception {
        this.setLevel(level, null);
    }

    @Override
    public void setLevel(String level, String logger) throws Exception {
        if (ROOT_LOGGER.equalsIgnoreCase(logger)) {
            logger = null;
        }
        if (!((level = level.toUpperCase()).equals("TRACE") || level.equals("DEBUG") || level.equals("INFO") || level.equals("WARN") || level.equals("ERROR") || level.equals("DEFAULT"))) {
            throw new IllegalArgumentException("level must be set to TRACE, DEBUG, INFO, WARN or ERROR (or DEFAULT to unset it)");
        }
        Configuration cfg = this.getConfiguration();
        Dictionary props = cfg.getProperties();
        String prop = logger == null ? ROOT_LOGGER_PREFIX : LOGGER_PREFIX + logger;
        String val = (String)props.get(prop);
        if (level.equals("DEFAULT")) {
            if (val != null) {
                int idx = (val = val.trim()).indexOf(",");
                val = idx < 0 ? null : val.substring(idx);
            }
        } else {
            int idx;
            val = val == null ? level : ((idx = (val = val.trim()).indexOf(",")) < 0 ? level : level + val.substring(idx));
        }
        if (val == null) {
            props.remove(prop);
        } else {
            props.put(prop, val);
        }
        cfg.update(props);
    }

    @Override
    public String getLevel() throws Exception {
        return this.getLevel(null);
    }

    @Override
    public String getLevel(String logger) throws Exception {
        String val;
        ConfigurationAdmin cfgAdmin = this.getConfigAdmin();
        Configuration cfg = cfgAdmin.getConfiguration(CONFIGURATION_PID, null);
        Dictionary props = cfg.getProperties();
        if (ROOT_LOGGER.equalsIgnoreCase(logger)) {
            logger = null;
        }
        while (true) {
            String prop = logger == null ? ROOT_LOGGER_PREFIX : LOGGER_PREFIX + logger;
            val = (String)props.get(prop);
            if ((val = this.getLevelValue(val)) != null || logger == null) break;
            int idx = logger.lastIndexOf(46);
            if (idx < 0) {
                logger = null;
                continue;
            }
            logger = logger.substring(0, idx);
        }
        String st = "Level: " + val;
        return st;
    }

    @Override
    public void set(String level) throws Exception {
        this.setLevel(level);
    }

    @Override
    public void set(String logger, String level) throws Exception {
        this.setLevel(logger, level);
    }

    @Override
    public String get() throws Exception {
        return this.getLevel();
    }

    @Override
    public String get(String logger) throws Exception {
        return this.getLevel(logger);
    }

    private boolean checkIfFromRequestedLog(PaxLoggingEvent event, String logger) {
        return event.getLoggerName().lastIndexOf(logger) >= 0;
    }

    private String render(PaxLoggingEvent event) {
        StringBuffer sb = new StringBuffer();
        sb.setLength(0);
        if (event.getThrowableStrRep() != null) {
            for (String r : event.getThrowableStrRep()) {
                sb.append(r).append('\n');
            }
        }
        return sb.toString();
    }

    private String getLevelValue(String prop) {
        if (prop == null) {
            return null;
        }
        String val = prop.trim();
        int idx = val.indexOf(",");
        if (idx == 0) {
            val = null;
        } else if (idx > 0) {
            val = val.substring(0, idx);
        }
        return val;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    protected Configuration getConfiguration() throws IOException {
        Configuration cfg = this.getConfigAdmin().getConfiguration(CONFIGURATION_PID, null);
        return cfg;
    }

    protected ConfigurationAdmin getConfigAdmin() {
        ServiceReference ref = this.bundleContext.getServiceReference(ConfigurationAdmin.class.getName());
        if (ref != null) {
            return (ConfigurationAdmin)this.bundleContext.getService(ref);
        }
        return null;
    }
}

