/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.management.mbeans.services.internal;

import java.util.ArrayList;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.karaf.management.mbeans.services.ServicesMBean;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class ServicesMBeanImpl
extends StandardMBean
implements ServicesMBean {
    private BundleContext bundleContext;

    public ServicesMBeanImpl() throws NotCompliantMBeanException {
        super(ServicesMBean.class);
    }

    @Override
    public TabularData getServices() throws Exception {
        return this.getServices(-1L, false);
    }

    @Override
    public TabularData getServices(boolean inUse) throws Exception {
        return this.getServices(-1L, inUse);
    }

    @Override
    public TabularData getServices(long bundleId) throws Exception {
        return this.getServices(bundleId, false);
    }

    @Override
    public TabularData getServices(long bundleId, boolean inUse) throws Exception {
        CompositeType serviceType = new CompositeType("Service", "OSGi Service", new String[]{"Interfaces", "Properties"}, new String[]{"Interfaces class name of the service", "Properties of the service"}, new OpenType[]{new ArrayType(1, SimpleType.STRING), new ArrayType(1, SimpleType.STRING)});
        TabularType tableType = new TabularType("Services", "Table of OSGi Services", serviceType, new String[]{"Interfaces"});
        TabularDataSupport table = new TabularDataSupport(tableType);
        Bundle[] bundles = bundleId >= 0L ? new Bundle[]{this.bundleContext.getBundle(bundleId)} : this.bundleContext.getBundles();
        for (Bundle bundle : bundles) {
            try {
                ServiceReference[] serviceReferences = inUse ? bundle.getServicesInUse() : bundle.getRegisteredServices();
                if (serviceReferences == null) continue;
                for (ServiceReference reference : serviceReferences) {
                    String[] interfaces = (String[])reference.getProperty("objectClass");
                    ArrayList<String> properties = new ArrayList<String>();
                    for (String key : reference.getPropertyKeys()) {
                        properties.add(key + " = " + reference.getProperty(key));
                    }
                    CompositeDataSupport data = new CompositeDataSupport(serviceType, new String[]{"Interfaces", "Properties"}, new Object[]{interfaces, properties.toArray(new String[0])});
                    table.put(data);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return table;
    }

    @Override
    public TabularData list() throws Exception {
        return this.getServices();
    }

    @Override
    public TabularData list(boolean inUse) throws Exception {
        return this.getServices(inUse);
    }

    @Override
    public TabularData list(long bundleId) throws Exception {
        return this.getServices(bundleId);
    }

    @Override
    public TabularData list(long bundleId, boolean inUse) throws Exception {
        return this.getServices(bundleId, inUse);
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }
}

