/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.extender.listener;

import io.fabric8.api.ModuleStatus;
import io.fabric8.api.RuntimeProperties;
import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.scr.Configurer;
import io.fabric8.extender.listener.AbstractExtenderListener;
import java.util.Map;
import org.apache.curator.framework.CuratorFramework;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.References;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.springframework.osgi.context.event.OsgiBundleApplicationContextEvent;
import org.springframework.osgi.context.event.OsgiBundleApplicationContextListener;
import org.springframework.osgi.context.event.OsgiBundleContextClosedEvent;
import org.springframework.osgi.context.event.OsgiBundleContextFailedEvent;
import org.springframework.osgi.context.event.OsgiBundleContextRefreshedEvent;
import org.springframework.osgi.extender.event.BootstrappingDependencyEvent;
import org.springframework.osgi.service.importer.event.OsgiServiceDependencyEvent;
import org.springframework.osgi.service.importer.event.OsgiServiceDependencyWaitStartingEvent;

@ThreadSafe
@Component(name="io.fabric8.extender.listener.spring", label="Fabric8 Spring Application Listener", immediate=true, metatype=false)
@References(value={@Reference(referenceInterface=CuratorFramework.class, bind="bindCurator", unbind="unbindCurator"), @Reference(referenceInterface=RuntimeProperties.class, bind="bindRuntimeProperties", unbind="unbindRuntimeProperties")})
public final class FabricSpringApplicationListener
extends AbstractExtenderListener {
    @Reference
    private Configurer configurer;
    private static final String EXTENDER_TYPE = "spring";
    private ServiceRegistration<?> registration;

    @Activate
    void activate(BundleContext bundleContext, Map<String, ?> configuration) throws Exception {
        this.configurer.configure(configuration, (Object)this, new String[0]);
        this.runtimeIdentity = ((RuntimeProperties)this.runtimeProperties.get()).getRuntimeIdentity();
        Object listener = this.createListener(bundleContext);
        if (listener != null) {
            this.registration = bundleContext.registerService(OsgiBundleApplicationContextListener.class.getName(), listener, null);
        }
        super.activate(bundleContext);
    }

    @Override
    @Deactivate
    void deactivate(BundleContext bundleContext) {
        super.deactivate(bundleContext);
        if (this.registration != null) {
            this.registration.unregister();
        }
    }

    @Override
    protected String getExtenderType() {
        return EXTENDER_TYPE;
    }

    @Override
    protected String getThreadNamePrefix() {
        return "fabric-spring-listener";
    }

    private Object createListener(BundleContext bundleContext) {
        try {
            return new SpringApplicationListener();
        }
        catch (Throwable t) {
            return null;
        }
    }

    protected void bindConfigurer(Configurer configurer) {
        this.configurer = configurer;
    }

    protected void unbindConfigurer(Configurer configurer) {
        if (this.configurer == configurer) {
            this.configurer = null;
        }
    }

    class SpringApplicationListener
    implements OsgiBundleApplicationContextListener {
        SpringApplicationListener() {
        }

        public void onOsgiApplicationEvent(OsgiBundleApplicationContextEvent event) {
            long bundleId = event.getBundle().getBundleId();
            ModuleStatus moduleStatus = this.toModuleStatus(event);
            FabricSpringApplicationListener.this.updateBundle(bundleId, moduleStatus);
        }

        private ModuleStatus toModuleStatus(OsgiBundleApplicationContextEvent event) {
            if (event instanceof BootstrappingDependencyEvent) {
                OsgiServiceDependencyEvent de = ((BootstrappingDependencyEvent)event).getDependencyEvent();
                if (de instanceof OsgiServiceDependencyWaitStartingEvent) {
                    return ModuleStatus.WAITING;
                }
            } else {
                if (event instanceof OsgiBundleContextFailedEvent) {
                    return ModuleStatus.FAILED;
                }
                if (event instanceof OsgiBundleContextRefreshedEvent) {
                    return ModuleStatus.STARTED;
                }
                if (event instanceof OsgiBundleContextClosedEvent) {
                    return ModuleStatus.STOPPED;
                }
            }
            return ModuleStatus.UNKNOWN;
        }
    }
}

