/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.ssh;

import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.server.UserAuth;
import org.apache.sshd.server.auth.UserAuthKeyboardInteractive;
import org.apache.sshd.server.auth.UserAuthPassword;
import org.apache.sshd.server.auth.UserAuthPublicKey;
import org.osgi.service.blueprint.container.ComponentDefinitionException;
import org.osgi.service.blueprint.container.ReifiedType;

public class UserAuthFactoriesFactory {
    public static final String PASSWORD_METHOD = "password";
    public static final String PUBLICKEY_METHOD = "publickey";
    public static final String KEYBOARD_INTERACTIVE_METHOD = "keyboard-interactive";
    private Set<String> methodSet;
    private List<NamedFactory<UserAuth>> factories;

    public static Converter getConverter() {
        return new Converter();
    }

    public void setAuthMethods(String methods) {
        String[] ams;
        this.methodSet = new HashSet<String>();
        this.factories = new ArrayList<NamedFactory<UserAuth>>();
        for (String am : ams = methods.split(",")) {
            if (PASSWORD_METHOD.equals(am)) {
                this.factories.add((NamedFactory<UserAuth>)new UserAuthPassword.Factory());
            } else if (KEYBOARD_INTERACTIVE_METHOD.equals(am)) {
                this.factories.add((NamedFactory<UserAuth>)new UserAuthKeyboardInteractive.Factory());
            } else if (PUBLICKEY_METHOD.equals(am)) {
                this.factories.add((NamedFactory<UserAuth>)new UserAuthPublicKey.Factory());
            } else {
                throw new ComponentDefinitionException("Invalid authentication method " + am + " specified");
            }
            this.methodSet.add(am);
        }
    }

    public List<NamedFactory<UserAuth>> getFactories() {
        return this.factories;
    }

    public boolean isPublickeyEnabled() {
        return this.methodSet.contains(PUBLICKEY_METHOD);
    }

    public boolean isPasswordEnabled() {
        return this.methodSet.contains(PASSWORD_METHOD);
    }

    public boolean isKeyboardInteractiveEnabled() {
        return this.methodSet.contains(KEYBOARD_INTERACTIVE_METHOD);
    }

    public static class Converter
    implements org.osgi.service.blueprint.container.Converter {
        public boolean canConvert(Object sourceObject, ReifiedType targetType) {
            return NamedFactory.class.isAssignableFrom(sourceObject.getClass()) && UserAuth.class.equals((Object)((ParameterizedType)sourceObject.getClass().getGenericInterfaces()[0]).getActualTypeArguments()[0]) && NamedFactory.class.equals((Object)targetType.getRawClass()) && UserAuth.class.equals((Object)targetType.getActualTypeArgument(0).getRawClass());
        }

        public Object convert(Object sourceObject, ReifiedType targetType) throws Exception {
            return sourceObject;
        }
    }
}

