/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.scr;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.felix.gogo.commands.Action;
import org.apache.felix.gogo.commands.basic.AbstractCommand;
import org.apache.felix.scr.ScrService;
import org.apache.karaf.shell.console.CompletableFunction;
import org.apache.karaf.shell.console.Completer;
import org.apache.karaf.shell.scr.action.ScrActionSupport;
import org.apache.karaf.shell.scr.completer.ScrCompleterSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ScrCommandSupport
extends AbstractCommand
implements CompletableFunction {
    protected final Logger logger = LoggerFactory.getLogger((String)((Object)((Object)this)).getClass().getName());
    private ScrService scrService;
    private ReadWriteLock lock = new ReentrantReadWriteLock();

    public abstract Class<? extends Action> getActionClass();

    public abstract List<Class<? extends Completer>> getCompleterClasses();

    public Action createNewAction() {
        try {
            this.lock.readLock().lock();
            ScrActionSupport action = (ScrActionSupport)this.getActionClass().newInstance();
            action.setScrService(this.getScrService());
            ScrActionSupport scrActionSupport = action;
            return scrActionSupport;
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public List<Completer> getCompleters() {
        ArrayList<ScrCompleterSupport> completers = null;
        if (this.getCompleterClasses() != null) {
            try {
                this.lock.readLock().lock();
                completers = new ArrayList<ScrCompleterSupport>();
                for (Class<? extends Completer> completerClass : this.getCompleterClasses()) {
                    ScrCompleterSupport ccs = (ScrCompleterSupport)completerClass.newInstance();
                    ccs.setScrService(this.scrService);
                    completers.add(ccs);
                }
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
        return completers;
    }

    public Map<String, Completer> getOptionalCompleters() {
        return null;
    }

    public ScrService getScrService() {
        return this.scrService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScrService(ScrService scrService) {
        try {
            this.lock.writeLock().lock();
            this.scrService = scrService;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsetScrService(ScrService scrService) {
        try {
            this.lock.writeLock().lock();
            this.scrService = null;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

