/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.groovy;

import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import io.fabric8.api.FabricException;
import io.fabric8.api.FabricService;
import io.fabric8.api.PlaceholderResolver;
import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.zookeeper.utils.ZooKeeperFacade;
import java.util.Map;
import org.apache.curator.framework.CuratorFramework;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
@Component(name="io.fabric8.placholder.resolver.groovy", label="Fabric8 Groovy Placeholder Resolver", metatype=false)
@Service(value={PlaceholderResolver.class, GroovyPlaceholderResolver.class})
@Properties(value={@Property(name="scheme", value={"groovy"})})
public final class GroovyPlaceholderResolver
extends AbstractComponent
implements PlaceholderResolver {
    public static final String RESOLVER_SCHEME = "groovy";
    private static final Logger LOGGER = LoggerFactory.getLogger(GroovyPlaceholderResolver.class);

    @Activate
    void activate() {
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
    }

    public String getScheme() {
        return RESOLVER_SCHEME;
    }

    public String resolve(FabricService fabricService, Map<String, Map<String, String>> configs, String pid, String key, String value) {
        CuratorFramework curator = (CuratorFramework)fabricService.adapt(CuratorFramework.class);
        return GroovyPlaceholderResolver.resolveValue(curator, value);
    }

    public static String resolveValue(CuratorFramework curator, String value) {
        try {
            Binding binding = new Binding();
            ZooKeeperFacade zk = new ZooKeeperFacade(curator);
            binding.setVariable("zk", (Object)zk);
            binding.setVariable("env", System.getenv());
            binding.setVariable("sys", (Object)System.getProperties());
            GroovyShell shell = new GroovyShell(binding);
            String expression = value;
            if (expression.startsWith("groovy:")) {
                expression = expression.substring(RESOLVER_SCHEME.length() + 1);
            }
            Object result = shell.evaluate(expression);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("groovy expression: " + expression + " => " + result);
            }
            if (result != null) {
                return result.toString();
            }
            return "";
        }
        catch (Exception e) {
            throw FabricException.launderThrowable((Throwable)e);
        }
    }
}

