/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.dev;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import jline.console.ConsoleReader;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.felix.service.command.CommandSession;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.apache.karaf.util.bundles.BundleUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.wiring.FrameworkWiring;

@Command(scope="dev", name="load-test", description="Load test bundle lifecycle")
public class LoadTest
extends OsgiCommandSupport {
    @Option(name="--threads", description="number of concurrent threads")
    int threads = 2;
    @Option(name="--delay", description="maximum delay between actions")
    int delay = 1;
    @Option(name="--iterations", description="number of iterations per thread")
    int iterations = 100;
    @Option(name="--refresh", description="percentage of bundle refresh vs restart")
    int refresh = 20;
    @Option(name="--excludes", description="List of bundles (ids or symbolic names) to exclude")
    List<String> excludes = Arrays.asList("0", "org.ops4j.pax.url.mvn", "org.ops4j.pax.logging.pax-logging-api", "org.ops4j.pax.logging.pax-logging-service");

    protected Object doExecute() throws Exception {
        if (!this.confirm(this.session)) {
            return null;
        }
        BundleContext bundleContext = this.getBundleContext().getBundle(0L).getBundleContext();
        final FrameworkWiring wiring = (FrameworkWiring)bundleContext.getBundle().adapt(FrameworkWiring.class);
        final CountDownLatch latch = new CountDownLatch(this.threads);
        final Bundle[] bundles = bundleContext.getBundles();
        final AtomicBoolean[] locks = new AtomicBoolean[bundles.length];
        for (int b = 0; b < locks.length; ++b) {
            locks[b] = new AtomicBoolean(true);
            if (this.excludes.contains(Long.toString(bundles[b].getBundleId())) || this.excludes.contains(bundles[b].getSymbolicName()) || bundles[b].getState() != 32) continue;
            locks[b].set(false);
        }
        for (int i = 0; i < this.threads; ++i) {
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Random rand = new Random();
                        block25: for (int j = 0; j < LoadTest.this.iterations; ++j) {
                            int b;
                            while (locks[b = rand.nextInt(bundles.length)].compareAndSet(false, true)) {
                                try {
                                    if (bundles[b].getState() != 32) continue;
                                    if (rand.nextInt(100) < LoadTest.this.refresh) {
                                        try {
                                            BundleUtils.update(bundles[b]);
                                            final CountDownLatch latch2 = new CountDownLatch(1);
                                            wiring.refreshBundles(Collections.singletonList(bundles[b]), new FrameworkListener[]{new FrameworkListener(){

                                                public void frameworkEvent(FrameworkEvent event) {
                                                    latch2.countDown();
                                                }
                                            }});
                                            latch2.await();
                                        }
                                        finally {
                                            while (true) {
                                                try {
                                                    bundles[b].start(1);
                                                }
                                                catch (Exception e) {
                                                    Thread.sleep(1L);
                                                    continue;
                                                }
                                                break;
                                            }
                                        }
                                    }
                                    try {
                                        bundles[b].stop(1);
                                    }
                                    finally {
                                        while (true) {
                                            try {
                                                bundles[b].start(1);
                                            }
                                            catch (Exception e) {
                                                Thread.sleep(1L);
                                                continue;
                                            }
                                            break;
                                        }
                                    }
                                    Thread.sleep(rand.nextInt(LoadTest.this.delay));
                                    continue block25;
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                    continue block25;
                                }
                                finally {
                                    locks[b].set(false);
                                }
                            }
                        }
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                    finally {
                        latch.countDown();
                    }
                }
            }.start();
        }
        new Thread(){

            @Override
            public void run() {
                try {
                    latch.await();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                System.err.println("Load test finished");
            }
        }.start();
        return null;
    }

    private boolean confirm(CommandSession session) throws IOException {
        String str;
        do {
            String msg;
            ConsoleReader reader;
            if (!"yes".equalsIgnoreCase(str = (reader = (ConsoleReader)session.get(".jline.reader")).readLine(msg = "You are about to perform a start/stop/refresh load test on bundles.\nDo you wish to continue (yes/no): "))) continue;
            return true;
        } while (!"no".equalsIgnoreCase(str));
        return false;
    }
}

