/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jaas;

import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.jaas.BasicEncryptionSupport;
import io.fabric8.jaas.ZookeeperBackingEngine;
import io.fabric8.jaas.ZookeeperLoginModule;
import io.fabric8.jaas.ZookeeperProperties;
import java.util.Map;
import org.apache.curator.framework.CuratorFramework;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.karaf.jaas.modules.BackingEngine;
import org.apache.karaf.jaas.modules.BackingEngineFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
@Component(name="io.fabric8.jaas.zookeeper.backingengine", label="Fabric8 Jaas Backing Engine Factory", metatype=false)
@Service(value={BackingEngineFactory.class})
public final class ZookeeperBackingEngineFactory
extends AbstractComponent
implements BackingEngineFactory {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(ZookeeperBackingEngineFactory.class);
    @Reference(referenceInterface=CuratorFramework.class)
    private final ValidatingReference<CuratorFramework> curator = new ValidatingReference();

    @Activate
    void activate() {
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
    }

    public String getModuleClass() {
        return ZookeeperLoginModule.class.getName();
    }

    public BackingEngine build(Map options) {
        this.assertValid();
        ZookeeperBackingEngine engine = null;
        BasicEncryptionSupport encryptionSupport = new BasicEncryptionSupport(options);
        String path = (String)options.get("path");
        if (path == null) {
            path = "/fabric/authentication/users";
        }
        try {
            CuratorFramework framework;
            if (this.curator != null && (framework = (CuratorFramework)this.curator.get()).checkExists().forPath(path) == null) {
                framework.create().creatingParentsIfNeeded().forPath(path);
            }
            ZookeeperProperties users = new ZookeeperProperties((CuratorFramework)this.curator.get(), path);
            users.load();
            engine = new ZookeeperBackingEngine(users, encryptionSupport);
        }
        catch (Exception e) {
            LOGGER.warn("Cannot initialize engine", (Throwable)e);
        }
        return engine;
    }

    void bindCurator(CuratorFramework curator) {
        this.curator.bind((Object)curator);
    }

    void unbindCurator(CuratorFramework curator) {
        this.curator.unbind((Object)curator);
    }
}

