/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven;

import io.fabric8.common.util.Files;
import io.fabric8.common.util.Strings;
import io.fabric8.git.internal.GitHelpers;
import io.fabric8.maven.AbstractProfileMojo;
import io.fabric8.maven.Zips;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.InitCommand;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.gitective.core.RepositoryUtils;

@Mojo(name="branch", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
@Execute(phase=LifecyclePhase.PACKAGE)
public class CreateBranchMojo
extends AbstractProfileMojo {
    private static final String CREDS_IN_GITURL_REGEX = ".*//([^:]+):([^@]+)@.+";
    @Parameter(property="fabric8.branch.buildDir", defaultValue="${project.build.directory}/git")
    private File buildDir;
    @Parameter(property="fabric8.branch.branchName", required=true)
    private String branchName;
    @Parameter(property="fabric8.branch.oldBranchName")
    private String oldBranchName;
    @Parameter(property="fabric8.branch.gitUrl")
    private String gitUrl;
    @Parameter(property="fabric8.branch.cloneAllBranches", defaultValue="true")
    private boolean cloneAll;
    @Parameter(property="fabric8.branch.pullOnStartup", defaultValue="true")
    private boolean pullOnStartup;
    @Parameter(property="fabric8.branch.pushOnSuccess", defaultValue="false")
    private boolean pushOnSuccess;
    @Parameter(property="fabric8.branch.remoteName", defaultValue="origin")
    private String remoteName = "origin";
    private Git git;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.initGitRepo();
            this.createAndCheckoutBranch();
            this.addProfileZips();
            this.removeSelectedFiles();
            this.commit("Branch created by fabric8 maven plugin");
            if (this.pushOnSuccess) {
                this.pushOnSuccess();
            }
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error executing", e);
        }
    }

    private void pushOnSuccess() throws GitAPIException {
        ((PushCommand)this.git.push().setRemote(this.remoteName).setCredentialsProvider(this.getCredentials())).call();
    }

    protected void addProfileZips() throws MojoExecutionException, IOException, GitAPIException {
        Set dependencyArtifacts = this.project.getDependencyArtifacts();
        for (Artifact artifact : dependencyArtifacts) {
            if (!"zip".equals(artifact.getType())) continue;
            File file = artifact.getFile();
            if (file != null) {
                this.getLog().info((CharSequence)("Unzipping file: " + file));
                this.addZipFile(file);
                continue;
            }
            this.getLog().warn((CharSequence)("Could not resolve file for " + artifact));
        }
        this.git.add().addFilepattern("fabric").call();
    }

    protected void addZipFile(File file) throws MojoExecutionException, IOException, GitAPIException {
        if (file == null || !file.exists() || !file.isFile()) {
            throw new MojoExecutionException("Zip file does not exist: " + file);
        }
        File unzipDir = new File(this.buildDir, "fabric/profiles");
        unzipDir.mkdirs();
        try {
            Zips.unzip(new FileInputStream(file), unzipDir);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to unzip file " + file.getCanonicalPath() + " to " + this.getGitBuildPathDescription() + ". " + e, (Exception)e);
        }
    }

    protected void removeSelectedFiles() throws MojoExecutionException, IOException, GitAPIException {
    }

    protected void initGitRepo() throws MojoExecutionException, IOException, GitAPIException {
        this.buildDir.mkdirs();
        File gitDir = new File(this.buildDir, ".git");
        if (!gitDir.exists()) {
            String repo = this.gitUrl;
            if (Strings.isNotBlank((String)repo)) {
                this.getLog().info((CharSequence)("Cloning git repo " + repo + " into directory " + this.getGitBuildPathDescription() + " cloneAllBranches: " + this.cloneAll));
                CloneCommand command = (CloneCommand)Git.cloneRepository().setCloneAllBranches(this.cloneAll).setURI(repo).setDirectory(this.buildDir).setRemote(this.remoteName).setBranch(this.oldBranchName).setCredentialsProvider(this.getCredentials());
                try {
                    this.git = command.call();
                    return;
                }
                catch (Throwable e) {
                    this.getLog().error((CharSequence)("Failed to command remote repo " + repo + " due: " + e.getMessage()), e);
                }
            } else {
                InitCommand initCommand = Git.init();
                initCommand.setDirectory(this.buildDir);
                this.git = initCommand.call();
                this.getLog().info((CharSequence)("Initialised an empty git configuration repo at " + this.getGitBuildPathDescription()));
                File readMe = new File(this.buildDir, "ReadMe.md");
                this.getLog().info((CharSequence)("Generating " + readMe));
                Files.writeToFile((File)readMe, (String)("fabric8 git repository created by fabric8-maven-plugin at " + new Date()), (Charset)Charset.forName("UTF-8"));
                this.git.add().addFilepattern("ReadMe.md").call();
                this.commit("Initial commit");
            }
            String branch = this.git.getRepository().getBranch();
            this.configureBranch(branch);
        } else {
            this.getLog().info((CharSequence)("Reusing existing git repository at " + this.getGitBuildPathDescription()));
            FileRepositoryBuilder builder = new FileRepositoryBuilder();
            Repository repository = ((FileRepositoryBuilder)((FileRepositoryBuilder)((FileRepositoryBuilder)builder.setGitDir(gitDir)).readEnvironment()).findGitDir()).build();
            this.git = new Git(repository);
            if (this.pullOnStartup) {
                this.doPull();
            } else {
                this.getLog().info((CharSequence)"git pull from remote config repo on startup is disabled");
            }
        }
    }

    private CredentialsProvider getCredentials() {
        String[] credentials;
        UsernamePasswordCredentialsProvider rc = null;
        if (this.gitUrlContainsCredentials() && (credentials = this.parseCredentials()).length == 2) {
            rc = new UsernamePasswordCredentialsProvider(credentials[0], credentials[1]);
        }
        if (rc == null) {
            this.getLog().info((CharSequence)"NO matching credentials");
        }
        return rc;
    }

    private String[] parseCredentials() {
        Pattern p = Pattern.compile(CREDS_IN_GITURL_REGEX);
        Matcher m = p.matcher(this.gitUrl);
        if (m.matches()) {
            return new String[]{m.group(1), m.group(2)};
        }
        return new String[0];
    }

    private boolean gitUrlContainsCredentials() {
        return this.gitUrl.matches(CREDS_IN_GITURL_REGEX);
    }

    protected void configureBranch(String branch) {
        StoredConfig config;
        if (Strings.isNotBlank((String)branch) && this.hasRemoteRepo() && (Strings.isNullOrBlank((String)(config = this.git.getRepository().getConfig()).getString("branch", branch, "remote")) || Strings.isNullOrBlank((String)config.getString("branch", branch, "merge")))) {
            config.setString("branch", branch, "remote", this.remoteName);
            config.setString("branch", branch, "merge", "refs/heads/" + branch);
            try {
                config.save();
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)("Failed to save the git configuration into " + new File(this.buildDir, ".git") + " with branch " + branch + " on remote repo: " + this.gitUrl + " due: " + e.getMessage() + ". This exception is ignored."), (Throwable)e);
            }
        }
    }

    protected boolean hasRemoteRepo() {
        if (Strings.isNotBlank((String)this.gitUrl)) {
            return true;
        }
        Repository repository = this.git.getRepository();
        StoredConfig config = repository.getConfig();
        String url = config.getString("remote", this.remoteName, "url");
        return Strings.isNotBlank((String)url);
    }

    protected void doPull() throws MojoExecutionException {
        CredentialsProvider cp = this.getCredentials();
        try {
            Repository repository = this.git.getRepository();
            StoredConfig config = repository.getConfig();
            String url = config.getString("remote", "origin", "url");
            if (Strings.isNullOrBlank((String)url)) {
                this.getLog().info((CharSequence)("No remote repository defined for the git repository at " + this.getGitBuildPathDescription() + " so not doing a pull"));
                return;
            }
            String branch = repository.getBranch();
            String mergeUrl = config.getString("branch", branch, "merge");
            if (Strings.isNullOrBlank((String)mergeUrl)) {
                this.getLog().info((CharSequence)("No merge spec for branch." + branch + ".merge in the git repository at " + this.getGitBuildPathDescription() + " so not doing a pull"));
                return;
            }
            this.getLog().info((CharSequence)("Performing a pull in git repository " + this.getGitBuildPathDescription() + " on remote URL: " + url));
            ((PullCommand)this.git.pull().setCredentialsProvider(cp)).setRebase(true).call();
        }
        catch (Throwable e) {
            String message = "Failed to pull from the remote git repo with credentials " + cp + " due: " + e.getMessage() + ". This exception is ignored.";
            this.getLog().error((CharSequence)message, e);
            throw new MojoExecutionException(message, e);
        }
    }

    protected void createAndCheckoutBranch() throws MojoExecutionException, IOException, GitAPIException {
        String last;
        int idx;
        ArrayList branches;
        int size;
        if (Strings.isNullOrBlank((String)this.oldBranchName) && (size = (branches = new ArrayList(RepositoryUtils.getBranches((Repository)this.git.getRepository()))).size()) > 0 && (idx = (last = (String)branches.get(size - 1)).lastIndexOf(47)) > 0) {
            this.oldBranchName = last.substring(idx + 1);
            this.getLog().info((CharSequence)("Using previous branch: " + this.oldBranchName));
        }
        if (Strings.isNullOrBlank((String)this.oldBranchName)) {
            this.oldBranchName = "master";
            this.getLog().warn((CharSequence)("Could not deduce the old branch so setting it to: " + this.oldBranchName));
        }
        GitHelpers.checkoutBranch((Git)this.git, (String)this.oldBranchName);
        this.getLog().info((CharSequence)("Creating branch " + this.branchName + " in " + this.getGitBuildPathDescription()));
        GitHelpers.createOrCheckoutBranch((Git)this.git, (String)this.branchName, (String)this.remoteName);
        GitHelpers.checkoutBranch((Git)this.git, (String)this.branchName);
    }

    protected void commit(String message) throws GitAPIException {
        this.git.commit().setMessage(message).call();
    }

    protected String getGitBuildPathDescription() throws IOException {
        return this.buildDir.getCanonicalPath();
    }
}

