/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven;

import io.fabric8.agent.DeploymentAgent;
import io.fabric8.agent.download.DownloadManager;
import io.fabric8.agent.download.DownloadManagers;
import io.fabric8.agent.model.BundleInfo;
import io.fabric8.agent.model.ConfigFile;
import io.fabric8.agent.model.Feature;
import io.fabric8.agent.model.Repository;
import io.fabric8.agent.service.Agent;
import io.fabric8.agent.service.Constants;
import io.fabric8.agent.service.MetadataBuilder;
import io.fabric8.agent.utils.AgentUtils;
import io.fabric8.common.util.MultiException;
import io.fabric8.maven.FakeServiceReference;
import io.fabric8.maven.FakeSystemBundle;
import io.fabric8.maven.MavenResolver;
import io.fabric8.maven.MavenResolvers;
import io.fabric8.maven.PropertiesLoader;
import io.fabric8.maven.WrapUrlParser;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.regex.Pattern;
import org.apache.felix.utils.version.VersionRange;
import org.apache.karaf.deployer.blueprint.BlueprintTransformer;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.aether.RepositorySystem;
import org.ops4j.pax.swissbox.bnd.BndUtils;
import org.ops4j.pax.swissbox.bnd.OverwriteMode;
import org.ops4j.pax.url.war.Handler;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.url.URLStreamHandlerService;

@Mojo(name="verify-features")
public class VerifyFeatureResolutionMojo
extends AbstractMojo {
    @Parameter(property="descriptors")
    private Set<String> descriptors;
    @Parameter(property="features")
    private Set<String> features;
    @Parameter(property="framework")
    private Set<String> framework;
    @Parameter(property="distribution", defaultValue="org.apache.karaf:apache-karaf")
    private String distribution;
    @Parameter(property="javase")
    private String javase;
    @Parameter(property="dist-dir")
    private String distDir;
    @Parameter(property="additional-metadata")
    private File additionalMetadata;
    @Parameter(property="fail")
    private String fail = "end";
    @Parameter(property="verify-transitive")
    private boolean verifyTransitive = false;
    @Component
    protected PluginDescriptor pluginDescriptor;
    @Component
    protected RepositorySystem repositorySystem;

    public void execute() throws MojoExecutionException, MojoFailureException {
        DownloadManager manager;
        MavenResolver resolver;
        try {
            Field field = URL.class.getDeclaredField("factory");
            field.setAccessible(true);
            field.set(null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        URL.setURLStreamHandlerFactory(new CustomBundleURLStreamHandlerFactory());
        System.setProperty("karaf.home", "target/karaf");
        System.setProperty("karaf.data", "target/karaf/data");
        ScheduledExecutorService executor = Executors.newScheduledThreadPool(8);
        Hashtable<String, String> properties = new Hashtable<String, String>();
        if (this.additionalMetadata != null) {
            try (FileReader reader = new FileReader(this.additionalMetadata);){
                Properties metadata = new Properties();
                metadata.load(reader);
                Enumeration<?> e = metadata.propertyNames();
                while (e.hasMoreElements()) {
                    Object key = e.nextElement();
                    Object val = metadata.get(key);
                    properties.put(key.toString(), val.toString());
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to load additional metadata from " + this.additionalMetadata, (Exception)e);
            }
        }
        HashMap<String, Feature[]> repos = new HashMap<String, Feature[]>();
        HashMap<String, Feature> allFeatures = new HashMap<String, Feature>();
        try {
            resolver = MavenResolvers.createMavenResolver(null, properties, (String)"org.ops4j.pax.url.mvn", (RepositorySystem)this.repositorySystem);
            manager = DownloadManagers.createDownloadManager((MavenResolver)resolver, (ScheduledExecutorService)executor);
            Map repositories = (Map)AgentUtils.downloadRepositories((DownloadManager)manager, this.descriptors).call();
            for (String repoUri : repositories.keySet()) {
                Feature[] features;
                for (Feature feature : features = ((Repository)repositories.get(repoUri)).getFeatures()) {
                    for (BundleInfo bi : feature.getBundles()) {
                        String loc = bi.getLocation();
                        String nloc = null;
                        if (loc.contains("file:")) {
                            for (ConfigFile cfi : feature.getConfigurationFiles()) {
                                if (!cfi.getFinalname().substring(1).equals(loc.substring(loc.indexOf("file:") + "file:".length()))) continue;
                                nloc = cfi.getLocation();
                            }
                        }
                        if (nloc == null) continue;
                        bi.setLocation(loc.substring(0, loc.indexOf("file:")) + nloc);
                    }
                    allFeatures.put(feature.getId(), feature);
                }
                repos.put(repoUri, features);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to load features descriptors", e);
        }
        ArrayList<Object> featuresToTest = new ArrayList<Object>();
        if (this.verifyTransitive) {
            for (Feature[] features : repos.values()) {
                featuresToTest.addAll(Arrays.asList(features));
            }
        } else {
            for (String uri : this.descriptors) {
                featuresToTest.addAll(Arrays.asList((Object[])repos.get(uri)));
            }
        }
        if (this.features != null && !this.features.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String string : this.features) {
                if (sb.length() > 0) {
                    sb.append("|");
                }
                String p = string.replaceAll("\\.", "\\\\.").replaceAll("\\*", ".*");
                sb.append(p);
                if (string.contains("/")) continue;
                sb.append("/.*");
            }
            Pattern pattern = Pattern.compile(sb.toString());
            Iterator iterator = featuresToTest.iterator();
            while (iterator.hasNext()) {
                Feature feature = (Feature)iterator.next();
                String id = feature.getName() + "/" + feature.getVersion();
                if (pattern.matcher(id).matches()) continue;
                iterator.remove();
            }
        }
        for (String fmk : this.framework) {
            properties.put("feature.framework." + fmk, fmk);
        }
        ArrayList<Exception> failures = new ArrayList<Exception>();
        for (Feature feature : featuresToTest) {
            try {
                String id = feature.getName() + "/" + feature.getVersion();
                manager = DownloadManagers.createDownloadManager((MavenResolver)resolver, (ScheduledExecutorService)executor);
                this.verifyResolution(manager, allFeatures, id, properties);
                this.getLog().info((CharSequence)("Verification of feature " + id + " succeeded"));
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)e.getMessage());
                failures.add(e);
                if (!"first".equals(this.fail)) continue;
                throw e;
            }
        }
        if ("end".equals(this.fail) && !failures.isEmpty()) {
            throw new MojoExecutionException("Verification failures", (Exception)new MultiException("Verification failures", failures));
        }
    }

    private void verifyResolution(DownloadManager manager, Map<String, Feature> allFeatures, String feature, Hashtable<String, String> properties) throws MojoExecutionException {
        try {
            properties.put("feature.totest", feature);
            FakeSystemBundle systemBundle = this.getSystemBundleResource(DeploymentAgent.getMetadata(properties, (String)"metadata#"));
            FakeServiceReference profileHandlerSR = new FakeServiceReference(URLStreamHandlerService.class.getName(), "(url.handler.protocol=profile)");
            systemBundle.setServiceReferences(URLStreamHandlerService.class.getName(), null, new ServiceReference[]{profileHandlerSR});
            systemBundle.setService(profileHandlerSR, new Object());
            Agent agent = new Agent(null, (BundleContext)systemBundle, manager);
            agent.setOptions(EnumSet.of(Constants.Option.Simulate, Constants.Option.Silent));
            try {
                agent.provision(allFeatures, DeploymentAgent.getPrefixedProperties(properties, (String)"feature."), DeploymentAgent.getPrefixedProperties(properties, (String)"bundle."), DeploymentAgent.getPrefixedProperties(properties, (String)"req."), DeploymentAgent.getPrefixedProperties(properties, (String)"override."), DeploymentAgent.getPrefixedProperties(properties, (String)"optional."), DeploymentAgent.getMetadata(properties, (String)"metadata#"));
            }
            catch (Exception e) {
                TreeSet<String> resources = new TreeSet<String>(manager.getProviders().keySet());
                throw new MojoExecutionException("Feature resolution failed for " + feature + "\nMessage: " + e.toString() + "\nResources: " + this.toString(resources), e);
            }
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error verifying feature " + feature + "\nMessage: " + e.getMessage(), e);
        }
    }

    private String toString(Collection<String> collection) {
        StringBuilder sb = new StringBuilder();
        sb.append("{\n");
        for (String s : collection) {
            sb.append("\t").append(s).append("\n");
        }
        sb.append("}");
        return sb.toString();
    }

    private FakeSystemBundle getSystemBundleResource(Map<String, Map<VersionRange, Map<String, String>>> metadata) throws Exception {
        Artifact karafDistro = (Artifact)this.pluginDescriptor.getArtifactMap().get(this.distribution);
        String dir = this.distDir;
        if (dir == null) {
            dir = karafDistro.getArtifactId() + "-" + karafDistro.getBaseVersion();
        }
        URL configPropURL = new URL("jar:file:" + karafDistro.getFile() + "!/" + dir + "/etc/config.properties");
        org.apache.felix.utils.properties.Properties configProps = PropertiesLoader.loadPropertiesFile(configPropURL, true);
        if (this.javase == null) {
            configProps.put("java.specification.version", System.getProperty("java.specification.version"));
        } else {
            configProps.put("java.specification.version", this.javase);
        }
        configProps.substitute();
        Hashtable<String, String> headers = new Hashtable<String, String>();
        headers.put("Bundle-ManifestVersion", "2");
        headers.put("Bundle-SymbolicName", "system-bundle");
        headers.put("Bundle-Version", "0.0.0");
        String exportPackages = configProps.getProperty("org.osgi.framework.system.packages");
        if (configProps.containsKey((Object)"org.osgi.framework.system.packages.extra")) {
            exportPackages = exportPackages + "," + configProps.getProperty("org.osgi.framework.system.packages.extra");
        }
        headers.put("Export-Package", exportPackages);
        String systemCaps = configProps.getProperty("org.osgi.framework.system.capabilities");
        headers.put("Provide-Capability", systemCaps);
        new MetadataBuilder(metadata).overrideHeaders(headers);
        return new FakeSystemBundle(headers);
    }

    public static class CustomBundleURLStreamHandlerFactory
    implements URLStreamHandlerFactory {
        @Override
        public URLStreamHandler createURLStreamHandler(String protocol) {
            if (protocol.equals("wrap")) {
                return new URLStreamHandler(){

                    @Override
                    protected URLConnection openConnection(URL url) throws IOException {
                        return new URLConnection(url){

                            @Override
                            public void connect() throws IOException {
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public InputStream getInputStream() throws IOException {
                                WrapUrlParser parser = new WrapUrlParser(this.url.getPath());
                                Class<CustomBundleURLStreamHandlerFactory> clazz = CustomBundleURLStreamHandlerFactory.class;
                                synchronized (CustomBundleURLStreamHandlerFactory.class) {
                                    // ** MonitorExit[var2_2] (shouldn't be in output)
                                    return BndUtils.createBundle((InputStream)parser.getWrappedJarURL().openStream(), (Properties)parser.getWrappingProperties(), (String)this.url.toExternalForm(), (OverwriteMode)parser.getOverwriteMode());
                                }
                            }
                        };
                    }
                };
            }
            if (protocol.equals("blueprint")) {
                return new URLStreamHandler(){

                    @Override
                    protected URLConnection openConnection(URL url) throws IOException {
                        return new URLConnection(url){

                            @Override
                            public void connect() throws IOException {
                            }

                            @Override
                            public InputStream getInputStream() throws IOException {
                                try {
                                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                                    BlueprintTransformer.transform((URL)new URL(this.url.getPath()), (OutputStream)os);
                                    os.close();
                                    return new ByteArrayInputStream(os.toByteArray());
                                }
                                catch (Exception e) {
                                    throw (IOException)new IOException("Error opening blueprint xml url").initCause(e);
                                }
                            }
                        };
                    }
                };
            }
            if (protocol.equals("war")) {
                return new Handler();
            }
            return null;
        }
    }
}

