/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven;

import io.fabric8.common.util.Files;
import io.fabric8.common.util.Strings;
import io.fabric8.deployer.dto.DependencyDTO;
import io.fabric8.deployer.dto.ProjectRequirements;
import io.fabric8.maven.Zips;
import java.io.Console;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilder;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilderException;
import org.codehaus.plexus.util.IOUtil;

public abstract class AbstractProfileMojo
extends AbstractMojo {
    private static final String[] OMITTED_BUNDLE_TYPES = new String[]{"jar", "bundle"};
    @Parameter(property="profileConfigDir", defaultValue="${basedir}/src/main/fabric8")
    protected File profileConfigDir;
    @Component
    protected MavenProject project;
    @Component
    protected ArtifactCollector artifactCollector;
    @Component
    protected ArtifactFactory artifactFactory;
    @Component
    protected DependencyTreeBuilder dependencyTreeBuilder;
    @Component
    protected ArtifactMetadataSource metadataSource;
    @Component
    protected ArtifactResolver resolver;
    @Parameter(property="localRepository", readonly=true, required=true)
    protected ArtifactRepository localRepository;
    @Parameter(property="project.remoteArtifactRepositories")
    protected List remoteRepositories;
    @Parameter(property="fabric8.scope", defaultValue="compile")
    private String scope;
    @Parameter(property="fabric8.profile")
    private String profile;
    @Parameter(property="fabric8.abstractProfile", defaultValue="false")
    private boolean abstractProfile;
    @Parameter(property="fabric8.profileVersion")
    private String version;
    @Parameter(property="fabric8.baseVersion")
    private String baseVersion;
    @Parameter(property="fabric8.parentProfiles")
    private String parentProfiles;
    @Parameter(property="fabric8.bundles")
    private String bundles;
    @Parameter(property="fabric8.features")
    private String features;
    @Parameter(property="fabric8.featureRepos")
    private String featureRepos;
    @Parameter(property="fabric8.useResolver", defaultValue="true")
    private boolean useResolver;
    @Parameter(property="fabric8.locked")
    private Boolean locked;
    @Parameter(property="fabric8.minInstanceCount", defaultValue="1")
    private Integer minInstanceCount;
    @Parameter(property="fabric8.includeArtifact", defaultValue="true")
    private boolean includeArtifact;
    @Parameter(property="fabric8.artifactBundleType")
    private String artifactBundleType;
    @Parameter(property="fabric8.artifactBundleClassifier")
    private String artifactBundleClassifier;
    @Parameter(property="fabric8.ignoreProject", defaultValue="false")
    private boolean ignoreProject;
    @Parameter(property="fabric8.includeReadMe", defaultValue="true")
    protected boolean includeReadMe;
    @Parameter(property="fabric8.generateSummaryFile", defaultValue="true")
    protected boolean generateSummaryFile;
    @Parameter(property="fabric8.webContextPath", defaultValue="${project.artifactId}")
    private String webContextPath;
    @Parameter(property="fabric8.replaceReadmeLinksPrefix")
    protected String replaceReadmeLinksPrefix;
    @Parameter(property="fabric8.uniqueVersion", defaultValue="true")
    private boolean uniqueVersion;
    private Map<String, String> servicemixBundles;

    protected static boolean isFile(File file) {
        return file != null && file.exists() && file.isFile();
    }

    public static void combineProfileFilesToFolder(MavenProject reactorProject, File buildDir, Log log, String reactorProjectOutputPath) throws IOException {
        File basedir = reactorProject.getBasedir();
        if (!basedir.exists()) {
            log.warn((CharSequence)("No basedir " + basedir.getAbsolutePath() + " for project + " + reactorProject));
            return;
        }
        File outDir = new File(basedir, reactorProjectOutputPath);
        if (!outDir.exists()) {
            log.warn((CharSequence)("No profile output dir at: " + outDir.getAbsolutePath() + " for project + " + reactorProject + " so ignoring this project."));
            return;
        }
        log.info((CharSequence)("Copying profiles from " + outDir.getAbsolutePath() + " into the output directory: " + buildDir));
        AbstractProfileMojo.appendProfileConfigFiles(outDir, buildDir);
    }

    public static void appendProfileConfigFiles(File profileSourceDir, File outputDir) throws IOException {
        File[] files;
        if (profileSourceDir.exists() && profileSourceDir.isDirectory() && (files = profileSourceDir.listFiles()) != null) {
            outputDir.mkdirs();
            for (File file : files) {
                File outFile = new File(outputDir, file.getName());
                if (file.isDirectory()) {
                    AbstractProfileMojo.appendProfileConfigFiles(file, outFile);
                    continue;
                }
                if (outFile.exists() && file.getName().endsWith(".properties")) {
                    System.out.println("Combining properties: file " + file.getAbsolutePath());
                    AbstractProfileMojo.combinePropertiesFiles(file, outFile);
                    continue;
                }
                System.out.println("Copying file " + file.getAbsolutePath());
                Files.copy((File)file, (File)outFile);
            }
        }
    }

    public static void combinePropertiesFiles(File sourceFile, File destFile) throws IOException {
        Properties source = AbstractProfileMojo.loadProperties(sourceFile);
        Properties dest = AbstractProfileMojo.loadProperties(destFile);
        Set<Map.Entry<Object, Object>> entries = source.entrySet();
        for (Map.Entry<Object, Object> entry : entries) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (key == null || value == null) continue;
            String keyText = key.toString();
            String valueText = value.toString();
            String oldValue = dest.getProperty(keyText);
            if (oldValue == null || oldValue.trim().length() == 0) {
                dest.setProperty(keyText, valueText);
                continue;
            }
            if (oldValue.contains(valueText)) continue;
            String newValue = oldValue + " " + valueText;
            dest.setProperty(keyText, newValue);
        }
        dest.store(new FileWriter(destFile), "Generated by fabric8:full-zip plugin at " + new Date());
    }

    private static Properties loadProperties(File file) throws IOException {
        Properties answer = new Properties();
        answer.load(new FileReader(file));
        return answer;
    }

    public boolean isIncludeArtifact() {
        return this.includeArtifact && !"pom".equals(this.project.getPackaging());
    }

    public boolean isIgnoreProject() {
        return this.ignoreProject;
    }

    public String getWebContextPath() {
        return this.webContextPath;
    }

    public void setWebContextPath(String webContextPath) {
        this.webContextPath = webContextPath;
    }

    protected static List<String> parameterToStringList(String parameterValue) {
        ArrayList<String> answer = new ArrayList<String>();
        if (Strings.isNotBlank((String)parameterValue)) {
            String[] split;
            for (String text : split = parameterValue.split("\\s")) {
                if (!Strings.isNotBlank((String)text)) continue;
                answer.add(text);
            }
        }
        return answer;
    }

    protected String readInput(String prompt) {
        Console console = System.console();
        System.out.print(prompt);
        return console.readLine();
    }

    protected String readPassword(String prompt) {
        Console console = System.console();
        System.out.print(prompt);
        char[] pw = console.readPassword();
        return new String(pw);
    }

    protected void configureRequirements(ProjectRequirements requirements) throws MojoExecutionException {
        if (Strings.isNotBlank((String)this.profile)) {
            requirements.setProfileId(this.profile);
        } else {
            requirements.setProfileId(this.project.getGroupId() + "-" + this.project.getArtifactId());
        }
        requirements.setAbstractProfile(this.abstractProfile);
        String description = this.project.getDescription();
        if (Strings.isNotBlank((String)description)) {
            requirements.setDescription(description);
        }
        if (Strings.isNotBlank((String)this.version)) {
            requirements.setVersion(this.version);
        }
        if (Strings.isNotBlank((String)this.baseVersion)) {
            requirements.setBaseVersion(this.baseVersion);
        }
        if (Strings.isNotBlank((String)this.webContextPath)) {
            requirements.setWebContextPath(this.webContextPath);
        }
        if (this.locked != null) {
            requirements.setLocked(this.locked);
        }
        List<String> bundleList = AbstractProfileMojo.parameterToStringList(this.bundles);
        if (this.parentProfiles == null || this.parentProfiles.length() <= 0) {
            this.parentProfiles = this.defaultParentProfiles(requirements);
        }
        List<String> profileParentList = AbstractProfileMojo.parameterToStringList(this.parentProfiles);
        List<String> featureList = AbstractProfileMojo.parameterToStringList(this.features);
        List<String> featureReposList = AbstractProfileMojo.parameterToStringList(this.featureRepos);
        requirements.setParentProfiles(profileParentList);
        requirements.setBundles(bundleList);
        requirements.setFeatures(featureList);
        requirements.setFeatureRepositories(featureReposList);
        if (this.minInstanceCount != null) {
            requirements.setMinimumInstances(this.minInstanceCount);
        }
        if (this.useResolver) {
            requirements.setUseResolver(Boolean.TRUE);
        }
    }

    protected String defaultParentProfiles(ProjectRequirements requirements) throws MojoExecutionException {
        String packaging = this.project.getPackaging();
        if (packaging != null) {
            if ("jar".equals(packaging)) {
                ArrayList<File> files = new ArrayList<File>();
                Set<String> classNames = this.findMainClasses(files);
                int classNameSize = classNames.size();
                if (classNameSize > 0 && classNameSize > 1) {
                    this.getLog().warn((CharSequence)("We found more than one executable main: " + classNames));
                }
                ArrayList<URL> urls = new ArrayList<URL>();
                try {
                    for (File file : files) {
                        URL url = file.toURI().toURL();
                        urls.add(url);
                    }
                    return this.resolveProfileFromJars(urls);
                }
                catch (MalformedURLException e) {
                    this.getLog().warn((CharSequence)("Failed to create URLClassLoader from files: " + files));
                    return "containers-java";
                }
            }
            if ("war".equals(packaging)) {
                return "containers-tomcat";
            }
            if ("ear".equals(packaging)) {
                return "containers-wildfly";
            }
        }
        return this.findOSGiDefaultParentProfiles(requirements);
    }

    protected String resolveProfileFromJars(List<URL> urls) {
        URLClassLoader classLoader = AbstractProfileMojo.createURLClassLoader(urls);
        Map<String, String> mainToProfileMap = this.getDefaultJavaClassToParentProfileMap();
        String defaultProfile = "containers-java";
        return this.resolveProfileFromClassMap(classLoader, mainToProfileMap, defaultProfile);
    }

    protected String findOSGiDefaultParentProfiles(ProjectRequirements requirements) throws MojoExecutionException {
        URLClassLoader classLoader = this.getCompileClassLoader();
        Map<String, String> classToProfileMap = this.getDefaultOSGiClassToParentProfileMap();
        Set<Map.Entry<String, String>> entries = classToProfileMap.entrySet();
        ArrayList<String> parentProfileNames = new ArrayList<String>();
        for (Map.Entry<String, String> entry : entries) {
            String className = entry.getKey();
            String profileName = entry.getValue();
            if (!this.hasClass(classLoader, className)) continue;
            this.getLog().info((CharSequence)("Found class: " + className + " so adding the parent profile: " + profileName));
            parentProfileNames.add(profileName);
        }
        if (parentProfileNames.isEmpty()) {
            return "karaf";
        }
        return Strings.join(parentProfileNames, (String)" ");
    }

    protected Map<String, String> getDefaultOSGiClassToParentProfileMap() {
        LinkedHashMap<String, String> classToProfileMap = new LinkedHashMap<String, String>();
        classToProfileMap.put("org.apache.camel.CamelContext", "feature-camel");
        classToProfileMap.put("org.apache.cxf.Bus", "feature-cxf");
        return classToProfileMap;
    }

    protected String resolveProfileFromClassMap(URLClassLoader classLoader, Map<String, String> mainToProfileMap, String defaultProfile) {
        Set<Map.Entry<String, String>> entries = mainToProfileMap.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            String mainClass = entry.getKey();
            String profileName = entry.getValue();
            if (!this.hasClass(classLoader, mainClass)) continue;
            this.getLog().info((CharSequence)("Found class: " + mainClass + " so defaulting the parent profile: " + profileName));
            return profileName;
        }
        return defaultProfile;
    }

    protected URLClassLoader getCompileClassLoader() throws MojoExecutionException {
        ArrayList<URL> urls = new ArrayList<URL>();
        try {
            for (Object object : this.project.getCompileClasspathElements()) {
                if (object == null) continue;
                String path = object.toString();
                File file = new File(path);
                URL url = file.toURI().toURL();
                urls.add(url);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to resolve classpath: " + e, e);
        }
        return AbstractProfileMojo.createURLClassLoader(urls);
    }

    protected static URLClassLoader createURLClassLoader(Collection<URL> jars) {
        return new URLClassLoader(jars.toArray(new URL[jars.size()]));
    }

    protected Map<String, String> getDefaultJavaClassToParentProfileMap() {
        LinkedHashMap<String, String> classToProfileMap = new LinkedHashMap<String, String>();
        classToProfileMap.put("org.springframework.boot.SpringApplication", "containers-java.spring.boot");
        classToProfileMap.put("io.fabric8.process.spring.boot.container.FabricSpringApplication", "containers-java.spring.boot");
        classToProfileMap.put("org.apache.camel.spring.Main", "containers-java.camel.spring");
        classToProfileMap.put("org.osgi.framework.BundleContext", "containers-java.pojosr");
        classToProfileMap.put("org.apache.camel.blueprint.ErrorHandlerType", "containers-java.pojosr");
        classToProfileMap.put("javax.enterprise.context.ApplicationScoped", "containers-java.weld");
        return classToProfileMap;
    }

    protected boolean hasClass(URLClassLoader classLoader, String className) {
        try {
            classLoader.loadClass(className);
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    protected Set<String> findMainClasses(List<File> files) throws MojoExecutionException {
        HashSet<String> classNames = new HashSet<String>();
        Artifact artifact = this.project.getArtifact();
        if (artifact != null) {
            File artifactFile = artifact.getFile();
            this.addMainClass(classNames, files, artifactFile);
        }
        try {
            for (Object object : this.project.getCompileClasspathElements()) {
                if (object == null) continue;
                String path = object.toString();
                File file = new File(path);
                this.addMainClass(classNames, files, file);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to resolve classpath: " + e, e);
        }
        return classNames;
    }

    protected void addMainClass(Set<String> classNames, List<File> files, File file) {
        if (file != null && file.exists() && file.isFile()) {
            files.add(file);
            try {
                String className;
                Attributes attributes;
                JarFile jarFile = new JarFile(file);
                Manifest manifest = jarFile.getManifest();
                if (manifest != null && (attributes = manifest.getMainAttributes()) != null && (className = attributes.getValue(Attributes.Name.MAIN_CLASS)) != null && className.length() > 0) {
                    this.getLog().debug((CharSequence)("found main class " + className + " in " + file));
                    className = className.trim();
                    if (className.length() > 0) {
                        classNames.add(className);
                    }
                }
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)("Failed to parse manifest for " + file + ". " + e), (Throwable)e);
            }
        }
    }

    protected void addProjectArtifactBundle(ProjectRequirements requirements) throws MojoFailureException {
        DependencyDTO rootDependency = requirements.getRootDependency();
        if (rootDependency != null) {
            StringBuilder urlBuffer = new StringBuilder(rootDependency.toBundleUrl());
            String apparentType = rootDependency.getType();
            String apparentClassifier = rootDependency.getClassifier();
            for (String omit : OMITTED_BUNDLE_TYPES) {
                if (!omit.equals(apparentType)) continue;
                apparentType = null;
                break;
            }
            this.handleArtifactBundleType(urlBuffer, apparentType);
            this.handleArtifactBundleClassifier(urlBuffer, apparentClassifier);
            String urlString = urlBuffer.toString();
            if (!requirements.getBundles().contains(urlString)) {
                requirements.getBundles().add(urlString);
            }
        }
    }

    private void handleArtifactBundleType(StringBuilder urlBuffer, String apparentType) {
        if (this.artifactBundleType != null) {
            urlBuffer.append("/" + this.artifactBundleType);
        } else if (apparentType != null) {
            urlBuffer.append("/" + apparentType);
        }
    }

    private void handleArtifactBundleClassifier(StringBuilder urlBuffer, String apparentClassifier) throws MojoFailureException {
        String nextUrlComponent = "";
        if (apparentClassifier != null) {
            nextUrlComponent = "/" + apparentClassifier;
        }
        if (this.artifactBundleClassifier != null) {
            if (this.artifactBundleType != null) {
                nextUrlComponent = "/" + this.artifactBundleClassifier;
            } else {
                throw new MojoFailureException("The property artifactBundleClassifier was specified as '" + this.artifactBundleClassifier + "' without also specifying artifactBundleType");
            }
        }
        urlBuffer.append(nextUrlComponent);
    }

    protected DependencyDTO loadRootDependency() throws DependencyTreeBuilderException {
        ArtifactFilter artifactFilter = this.createResolvingArtifactFilter();
        DependencyNode dependencyNode = this.dependencyTreeBuilder.buildDependencyTree(this.project, this.localRepository, this.artifactFactory, this.metadataSource, artifactFilter, this.artifactCollector);
        return this.buildFrom(dependencyNode);
    }

    private DependencyDTO buildFrom(DependencyNode node) {
        Artifact artifact = node.getArtifact();
        if (artifact != null) {
            DependencyDTO answer = new DependencyDTO();
            answer.setGroupId(artifact.getGroupId());
            answer.setArtifactId(artifact.getArtifactId());
            if (artifact.isSnapshot() && !this.uniqueVersion) {
                answer.setVersion(artifact.getBaseVersion());
            } else {
                answer.setVersion(artifact.getVersion());
            }
            answer.setClassifier(artifact.getClassifier());
            String scope = artifact.getScope();
            answer.setScope(scope);
            answer.setType(artifact.getType());
            if (artifact.getClassifier() == null && "jar".equals(artifact.getType())) {
                if (this.project.getArtifact().equals(artifact)) {
                    this.getLog().debug((CharSequence)("Ignoring bundle check on the maven project artifact: " + artifact + " as this causes issues with the maven-install-plugin and we can assume the project packaging is accurate"));
                } else {
                    try {
                        ArtifactResolutionRequest request = new ArtifactResolutionRequest();
                        request.setArtifact(artifact);
                        request.setRemoteRepositories(this.remoteRepositories);
                        request.setLocalRepository(this.localRepository);
                        this.resolver.resolve(request);
                        JarInputStream jis = new JarInputStream(new FileInputStream(artifact.getFile()));
                        Manifest man = jis.getManifest();
                        String bsn = man.getMainAttributes().getValue("Bundle-SymbolicName");
                        if (bsn != null) {
                            answer.setType("bundle");
                        }
                    }
                    catch (Exception e) {
                        this.getLog().debug((CharSequence)("Error checking artifact type for " + artifact), (Throwable)e);
                    }
                }
            }
            answer.setOptional(artifact.isOptional());
            String type = answer.getType();
            if (type != null && type.equals("pom")) {
                this.getLog().debug((CharSequence)("Ignoring pom.xml for " + answer));
                return null;
            }
            int state = node.getState();
            if (state != 0) {
                this.getLog().debug((CharSequence)("Ignoring " + node));
                return null;
            }
            if (this.isWarProject() && scope != null && !scope.equals("provided")) {
                this.getLog().debug((CharSequence)("WAR packaging so ignoring non-provided scope " + scope + " for " + node));
                return null;
            }
            List children = node.getChildren();
            for (Object child : children) {
                DependencyNode childNode;
                if (!(child instanceof DependencyNode) || (childNode = (DependencyNode)child).getState() != 0) continue;
                String childScope = childNode.getArtifact().getScope();
                if (!"test".equals(childScope) && !"provided".equals(childScope)) {
                    DependencyDTO childDTO = this.buildFrom(childNode);
                    if (childDTO == null) continue;
                    answer.addChild(childDTO);
                    continue;
                }
                this.getLog().debug((CharSequence)("Ignoring artifact " + childNode.getArtifact() + " with scope " + childScope));
            }
            return answer;
        }
        return null;
    }

    private synchronized Map<String, String> getAllServiceMixBundles() throws InterruptedException {
        if (this.servicemixBundles == null) {
            this.servicemixBundles = this.doGetAllServiceMixBundles();
        }
        return this.servicemixBundles;
    }

    private Map<String, String> doGetAllServiceMixBundles() throws InterruptedException {
        this.getLog().info((CharSequence)"Retrieving ServiceMix bundles on maven central");
        final HashMap<String, String> bundles = new HashMap<String, String>();
        final ExecutorService executor = Executors.newCachedThreadPool();
        try {
            String md = IOUtil.toString((InputStream)new URL("http://central.maven.org/maven2/org/apache/servicemix/bundles/").openStream());
            Matcher matcher = Pattern.compile("<a href=\"(org\\.apache\\.servicemix\\.bundles\\.[^\"]*)/\">").matcher(md);
            while (matcher.find()) {
                final String artifactId = matcher.group(1);
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            String mda = IOUtil.toString((InputStream)new URL("http://central.maven.org/maven2/org/apache/servicemix/bundles/" + artifactId).openStream());
                            Matcher matcher = Pattern.compile("<a href=\"([^\\.][^\"]*)/\">").matcher(mda);
                            while (matcher.find()) {
                                final String version = matcher.group(1);
                                executor.execute(new Runnable(){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    @Override
                                    public void run() {
                                        block8: {
                                            try {
                                                String pom = IOUtil.toString((InputStream)new URL("http://central.maven.org/maven2/org/apache/servicemix/bundles/" + artifactId + "/" + version + "/" + artifactId + "-" + version + ".pom").openStream());
                                                String pkgGroupId = AbstractProfileMojo.this.extract(pom, "<pkgGroupId>(.*)</pkgGroupId>");
                                                String pkgArtifactId = AbstractProfileMojo.this.extract(pom, "<pkgArtifactId>(.*)</pkgArtifactId>");
                                                String pkgVersion = AbstractProfileMojo.this.extract(pom, "<pkgVersion>(.*)</pkgVersion>");
                                                if (pkgGroupId == null || pkgArtifactId == null || pkgVersion == null) break block8;
                                                String key = pkgGroupId + ":" + pkgArtifactId + ":" + pkgVersion;
                                                AbstractProfileMojo.this.getLog().info((CharSequence)("Found ServiceMix bundle for " + key + " in version " + version));
                                                Map map = bundles;
                                                synchronized (map) {
                                                    String cur = (String)bundles.get(key);
                                                    if (cur == null) {
                                                        bundles.put(key, "org.apache.servicemix.bundles:" + artifactId + ":" + version);
                                                    } else {
                                                        int v1 = AbstractProfileMojo.this.extractBundleRelease(cur);
                                                        int v2 = AbstractProfileMojo.this.extractBundleRelease(version);
                                                        if (v2 > v1) {
                                                            bundles.put(key, "org.apache.servicemix.bundles:" + artifactId + ":" + version);
                                                        }
                                                    }
                                                }
                                            }
                                            catch (IOException e) {
                                                AbstractProfileMojo.this.getLog().warn((CharSequence)"Error retrieving ServiceMix bundles list", (Throwable)e);
                                            }
                                        }
                                    }
                                });
                            }
                        }
                        catch (IOException e) {
                            AbstractProfileMojo.this.getLog().warn((CharSequence)"Error retrieving ServiceMix bundles list", (Throwable)e);
                        }
                    }
                });
            }
            executor.awaitTermination(5L, TimeUnit.MINUTES);
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)"Error retrieving ServiceMix bundles list", (Throwable)e);
        }
        return bundles;
    }

    private int extractBundleRelease(String version) {
        int i1;
        int i0 = version.lastIndexOf(95);
        int i = Math.max(i0, i1 = version.lastIndexOf(45));
        if (i > 0) {
            return Integer.parseInt(version.substring(i + 1));
        }
        return -1;
    }

    private String extract(String string, String regexp) {
        Matcher matcher = Pattern.compile(regexp).matcher(string);
        return matcher.find() ? matcher.group(1) : null;
    }

    protected boolean isWarProject() {
        if (this.project != null) {
            String packaging = this.project.getPackaging();
            return packaging != null && packaging.equals("war");
        }
        return false;
    }

    protected void walkTree(DependencyNode node, int level) {
        if (node == null) {
            this.getLog().warn((CharSequence)"Null node!");
            return;
        }
        this.getLog().info((CharSequence)(this.indent(level) + node.getArtifact()));
        List children = node.getChildren();
        for (Object child : children) {
            if (child instanceof DependencyNode) {
                this.walkTree((DependencyNode)child, level + 1);
                continue;
            }
            this.getLog().warn((CharSequence)("Unknown class " + child.getClass()));
        }
    }

    protected String indent(int level) {
        StringBuilder builder = new StringBuilder();
        while (level-- > 0) {
            builder.append("    ");
        }
        return builder.toString();
    }

    private ArtifactFilter createResolvingArtifactFilter() {
        ScopeArtifactFilter filter;
        if (this.scope != null) {
            this.getLog().debug((CharSequence)("+ Resolving dependency tree for scope '" + this.scope + "'"));
            filter = new ScopeArtifactFilter(this.scope);
        } else {
            filter = null;
        }
        return filter;
    }

    protected void createAggregatedZip(List<MavenProject> reactorProjectList, File projectBaseDir, File projectBuildDir, String reactorProjectOutputPath, File projectOutputFile, boolean includeReadMe, List<MavenProject> pomZipProjects) throws IOException {
        projectBuildDir.mkdirs();
        for (MavenProject reactorProject : reactorProjectList) {
            if (reactorProject.isExecutionRoot()) continue;
            Log log = this.getLog();
            AbstractProfileMojo.combineProfileFilesToFolder(reactorProject, projectBuildDir, log, reactorProjectOutputPath);
        }
        if (includeReadMe) {
            HashMap<String, File> pomNames = new HashMap<String, File>();
            for (MavenProject mavenProject : pomZipProjects) {
                File src = mavenProject.getFile().getParentFile();
                String root = projectBaseDir.getName();
                String relativePath = Files.getRelativePath((File)projectBaseDir, (File)mavenProject.getBasedir());
                relativePath = root + File.separator + relativePath;
                File outDir = new File(projectBuildDir, relativePath = AbstractProfileMojo.pathToProfilePath(relativePath));
                File copiedFile = AbstractProfileMojo.copyReadMe(src, outDir);
                if (copiedFile == null) continue;
                String key = this.getReadMeFileKey(relativePath);
                pomNames.put(key, copiedFile);
            }
            if (this.replaceReadmeLinksPrefix != null) {
                for (Map.Entry entry : pomNames.entrySet()) {
                    File file = (File)entry.getValue();
                    String key = (String)entry.getKey();
                    boolean changed = false;
                    List lines = Files.readLines((File)file);
                    for (int i = 0; i < lines.size(); ++i) {
                        String line = (String)lines.get(i);
                        String newLine = this.replaceGithubLinks(pomNames.keySet(), key, line);
                        if (newLine == null) continue;
                        lines.set(i, newLine);
                        changed = true;
                    }
                    if (!changed) continue;
                    Files.writeLines((File)file, (List)lines);
                    this.getLog().info((CharSequence)("Replaced github links to fabric profiles in reaadme file: " + file));
                }
            }
        }
        Zips.createZipFile(this.getLog(), projectBuildDir, projectOutputFile);
        String relativePath = Files.getRelativePath((File)projectBaseDir, (File)projectOutputFile);
        while (relativePath.startsWith("/")) {
            relativePath = relativePath.substring(1);
        }
        this.getLog().info((CharSequence)("Created profile zip file: " + relativePath));
    }

    private static String pathToProfilePath(String path) {
        return path.replace('-', '.');
    }

    protected static File copyReadMe(File src, File profileBuildDir) throws IOException {
        File[] files = src.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase(Locale.ENGLISH).startsWith("readme.");
            }
        });
        if (files != null && files.length == 1) {
            File readme = files[0];
            File outFile = new File(profileBuildDir, readme.getName());
            Files.copy((File)readme, (File)outFile);
            return outFile;
        }
        return null;
    }

    private String getReadMeFileKey(String relativePath) {
        String answer = relativePath;
        if (Strings.isNullOrBlank((String)answer)) {
            return "<root>";
        }
        int pos = relativePath.indexOf(47);
        int pos2 = relativePath.indexOf(92);
        if (pos > 0 && pos2 > 0) {
            pos = Math.max(pos, pos2);
        } else if (pos2 > 0) {
            pos = pos2;
        }
        if (pos > -1) {
            answer = relativePath.substring(pos);
        }
        if (Strings.isNullOrBlank((String)(answer = Files.stripLeadingSeparator((String)answer)))) {
            answer = "<root>";
        }
        return answer;
    }

    protected String replaceGithubLinks(Set<String> names, String relativePath, String line) {
        boolean changed = false;
        Pattern pattern = Pattern.compile("\\[(.*?)\\]\\((.*?)\\)");
        Matcher matcher = pattern.matcher(line);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String s2 = matcher.group(2);
            if (s2.startsWith("http:") || s2.startsWith("https:")) {
                matcher.appendReplacement(sb, "[$1]($2)");
                continue;
            }
            if (names.contains(s2) || names.contains(relativePath + s2) || names.contains(relativePath + "/" + s2)) {
                s2 = AbstractProfileMojo.pathToProfilePath(s2);
                if (relativePath != null && !"<root>".equals(relativePath)) {
                    s2 = AbstractProfileMojo.addToPath(relativePath, s2);
                }
                matcher.appendReplacement(sb, "[$1](" + this.replaceReadmeLinksPrefix + s2 + ")");
            } else {
                s2 = AbstractProfileMojo.pathToProfilePath(s2);
                if (relativePath != null && !"<root>".equals(relativePath)) {
                    s2 = AbstractProfileMojo.addToPath(relativePath, s2);
                }
                matcher.appendReplacement(sb, "[$1](" + this.replaceReadmeLinksPrefix + s2 + ".profile)");
            }
            changed = true;
        }
        matcher.appendTail(sb);
        if (changed) {
            return sb.toString();
        }
        return null;
    }

    private static String addToPath(String path, String add) {
        if (add.startsWith("/") || path.endsWith("/")) {
            return path + add;
        }
        return path + "/" + add;
    }
}

