/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven;

import io.fabric8.common.util.Files;
import io.fabric8.common.util.IOHelpers;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.felix.metatype.MetaData;
import org.apache.felix.metatype.MetaDataReader;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="copy-metatype")
public class CopyMetaTypeFilesMojo
extends AbstractMojo {
    protected static String PROPERTIES_SUFFIX = ".properties";
    protected static String XML_SUFFIX = ".xml";
    @Parameter(property="inputDir", defaultValue="${project.build.directory}/features-repo")
    private File inputDir = new File("target/system");
    @Parameter(property="outputDir", defaultValue="${project.build.directory}/metatype")
    private File outputDir = new File("target/metatype");
    @Component
    protected MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.outputDir.mkdirs();
        if (this.inputDir.exists() && this.inputDir.isDirectory()) {
            this.processFolder(this.inputDir);
        } else {
            this.getLog().warn((CharSequence)("inputDir " + this.inputDir + " is not an existing directory"));
        }
        this.processClassPath();
    }

    protected void processClassPath() throws MojoExecutionException {
        try {
            HashSet elements = new HashSet();
            elements.addAll(this.project.getCompileClasspathElements());
            elements.addAll(this.project.getRuntimeClasspathElements());
            elements.addAll(this.project.getSystemClasspathElements());
            for (Object object : elements) {
                String path;
                File file;
                if (object == null || !(file = new File(path = object.toString())).isFile() || !CopyMetaTypeFilesMojo.isJar(file)) continue;
                this.processJar(file);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to resolve classpath: " + e, e);
        }
    }

    protected static boolean isJar(File file) {
        return file.getName().endsWith(".jar");
    }

    protected void processFolder(File input) throws MojoExecutionException {
        File[] files;
        if (input.isDirectory() && (files = input.listFiles()) != null) {
            for (File file : files) {
                if (file.isFile() && CopyMetaTypeFilesMojo.isJar(file)) {
                    this.processJar(file);
                    continue;
                }
                if (!file.isDirectory()) continue;
                this.processFolder(file);
            }
        }
    }

    protected void processJar(File file) throws MojoExecutionException {
        try {
            JarFile jarFile = new JarFile(file);
            Enumeration<JarEntry> entries = jarFile.entries();
            HashMap<String, String> xmlMap = new HashMap<String, String>();
            HashMap<String, MetaData> metadataMap = new HashMap<String, MetaData>();
            HashMap<String, Properties> propertiesMap = new HashMap<String, Properties>();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.startsWith("OSGI-INF/metatype/")) continue;
                if (name.endsWith(XML_SUFFIX)) {
                    String text;
                    MetaData metadata;
                    MetaDataReader reader = new MetaDataReader();
                    InputStream in = jarFile.getInputStream(entry);
                    if (in == null || (metadata = reader.parse((InputStream)new ByteArrayInputStream((text = IOHelpers.readFully((InputStream)in)).getBytes()))) == null) continue;
                    String pid = name.substring(0, name.length() - XML_SUFFIX.length());
                    xmlMap.put(pid, text);
                    metadataMap.put(pid, metadata);
                    continue;
                }
                if (!name.endsWith(PROPERTIES_SUFFIX)) continue;
                String pid = name.substring(0, name.length() - PROPERTIES_SUFFIX.length());
                Properties properties = new Properties();
                InputStream in = jarFile.getInputStream(entry);
                if (in == null) continue;
                properties.load(in);
                propertiesMap.put(pid, properties);
            }
            Set metadataEntries = metadataMap.entrySet();
            for (Map.Entry metadataEntry : metadataEntries) {
                String xml;
                String pid = (String)metadataEntry.getKey();
                MetaData metadata = (MetaData)metadataEntry.getValue();
                Properties properties = (Properties)propertiesMap.get(pid);
                if (properties == null) {
                    properties = new Properties();
                }
                if ((xml = (String)xmlMap.get(pid)) == null) {
                    this.getLog().warn((CharSequence)("Missing XML file for " + pid));
                    continue;
                }
                this.writeMetaTypeObjects(metadata, properties, xml);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to process jar " + file + ". " + e, (Exception)e);
        }
    }

    protected void writeMetaTypeObjects(MetaData metadata, Properties properties, String xml) throws IOException {
        Map map = metadata.getDesignates();
        Set entries = map.entrySet();
        for (Map.Entry entry : entries) {
            String pid = (String)entry.getKey();
            File pidOutDir = new File(this.outputDir, pid);
            if (pidOutDir.exists()) {
                System.out.println("PID " + pid + " already exists at " + pidOutDir);
                return;
            }
            pidOutDir.mkdirs();
            File xmlFile = new File(pidOutDir, "metatype.xml");
            Files.writeToFile((File)xmlFile, (byte[])xml.getBytes());
            if (properties.size() <= 0) continue;
            File propertiesFile = new File(pidOutDir, "metatype.properties");
            properties.store(new FileOutputStream(propertiesFile), "Generated from jar by fabric8-maven-plugin");
        }
    }
}

