/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven;

import io.fabric8.common.util.Strings;
import io.fabric8.deployer.dto.DependencyDTO;
import io.fabric8.deployer.dto.ProjectRequirements;
import io.fabric8.maven.AbstractProfileMojo;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProjectHelper;

@Mojo(name="script", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
@Execute(phase=LifecyclePhase.PACKAGE)
public class CreateScriptMojo
extends AbstractProfileMojo {
    @Parameter(property="fabric8.script.outFile", defaultValue="${project.build.directory}/profile.karaf")
    private File outputFile;
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter(property="fabric8.script.artifactType", defaultValue="karaf")
    private String artifactType = "karaf";
    @Parameter(property="fabric8.script.artifactClassifier", defaultValue="profile")
    private String artifactClassifier = "profile";

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            DependencyDTO rootDependency = this.loadRootDependency();
            ProjectRequirements requirements = new ProjectRequirements();
            requirements.setRootDependency(rootDependency);
            this.configureRequirements(requirements);
            this.addProjectArtifactBundle(requirements);
            this.generateScript(requirements, this.outputFile);
            this.projectHelper.attachArtifact(this.project, this.artifactType, this.artifactClassifier, this.outputFile);
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error executing", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateScript(ProjectRequirements requirements, File file) throws MojoExecutionException, IOException {
        file.getParentFile().mkdirs();
        PrintWriter writer = new PrintWriter(new FileWriter(file));
        try {
            String profileId = requirements.getProfileId();
            writer.write("profile-create");
            List<String> parentProfiles = CreateScriptMojo.notNullList(requirements.getParentProfiles());
            for (String parentProfile : parentProfiles) {
                writer.write(" --parent ");
                writer.write(parentProfile);
            }
            writer.write(" ");
            writer.println(profileId);
            List<String> bundles = CreateScriptMojo.notNullList(requirements.getBundles());
            List<String> features = CreateScriptMojo.notNullList(requirements.getFeatures());
            List<String> repos = CreateScriptMojo.notNullList(requirements.getFeatureRepositories());
            for (String bundle : bundles) {
                if (!Strings.isNotBlank((String)bundle)) continue;
                writer.println("profile-edit --bundle " + bundle + " " + profileId);
            }
            for (String feature : features) {
                if (!Strings.isNotBlank((String)feature)) continue;
                writer.println("profile-edit --feature " + feature + " " + profileId);
            }
            for (String repo : repos) {
                if (!Strings.isNotBlank((String)repo)) continue;
                writer.println("profile-edit --repository " + repo + " " + profileId);
            }
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception exception) {}
        }
    }

    protected static List<String> notNullList(List<String> list) {
        if (list == null) {
            return Collections.EMPTY_LIST;
        }
        return list;
    }
}

