/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ops4j.net.URLUtils;
import org.ops4j.pax.swissbox.bnd.BndUtils;
import org.ops4j.pax.swissbox.bnd.OverwriteMode;

public class WrapUrlParser {
    private static final String SYNTAX = "wrap:wrapped-jar-uri[,wrapping-instr-uri][$wrapping-instructions]";
    private static final String INSTRUCTIONS_SEPARATOR = "$";
    private static final String INSTRUCTIONS_FILE_SEPARATOR = ",";
    private static final Pattern SYNTAX_JAR_BND_INSTR = Pattern.compile("(.+?),(.+?)\\$(.+?)");
    private static final Pattern SYNTAX_JAR_INSTR = Pattern.compile("(.+?)\\$(.+?)");
    private static final Pattern SYNTAX_JAR_BND = Pattern.compile("(.+?),(.+?)");
    private final URL m_wrappedJarURL;
    private final Properties m_wrappingProperties;
    private final OverwriteMode m_overwriteMode;

    public WrapUrlParser(String path) throws MalformedURLException {
        OverwriteMode overwriteMode;
        if (path == null || path.trim().length() == 0) {
            throw new MalformedURLException("Path cannot be null or empty. Syntax wrap:wrapped-jar-uri[,wrapping-instr-uri][$wrapping-instructions]");
        }
        if (path.startsWith(INSTRUCTIONS_SEPARATOR) || path.endsWith(INSTRUCTIONS_SEPARATOR)) {
            throw new MalformedURLException("Path cannot start or end with $. Syntax wrap:wrapped-jar-uri[,wrapping-instr-uri][$wrapping-instructions]");
        }
        this.m_wrappingProperties = new Properties();
        Matcher matcher = SYNTAX_JAR_BND_INSTR.matcher(path);
        if (matcher.matches()) {
            this.m_wrappedJarURL = new URL(matcher.group(1));
            this.parseInstructionsFile(new URL(matcher.group(2)));
            this.m_wrappingProperties.putAll((Map<?, ?>)BndUtils.parseInstructions((String)matcher.group(3)));
        } else {
            matcher = SYNTAX_JAR_INSTR.matcher(path);
            if (matcher.matches()) {
                this.m_wrappedJarURL = new URL(matcher.group(1));
                this.m_wrappingProperties.putAll((Map<?, ?>)BndUtils.parseInstructions((String)matcher.group(2)));
            } else {
                matcher = SYNTAX_JAR_BND.matcher(path);
                if (matcher.matches()) {
                    this.m_wrappedJarURL = new URL(matcher.group(1));
                    this.parseInstructionsFile(new URL(matcher.group(2)));
                } else {
                    this.m_wrappedJarURL = new URL(path);
                }
            }
        }
        try {
            overwriteMode = OverwriteMode.valueOf((String)this.m_wrappingProperties.getProperty("overwrite", OverwriteMode.KEEP.name()).toUpperCase());
        }
        catch (Exception e) {
            overwriteMode = OverwriteMode.KEEP;
        }
        this.m_overwriteMode = overwriteMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseInstructionsFile(URL bndFileURL) throws MalformedURLException {
        try (InputStream is = null;){
            is = URLUtils.prepareInputStream((URL)bndFileURL, (boolean)true);
            this.m_wrappingProperties.load(is);
        }
        catch (IOException e) {
            WrapUrlParser.throwAsMalformedURLException("Could not retrieve the instructions from [" + bndFileURL + "]", e);
        }
    }

    public URL getWrappedJarURL() {
        return this.m_wrappedJarURL;
    }

    public Properties getWrappingProperties() {
        return this.m_wrappingProperties;
    }

    public OverwriteMode getOverwriteMode() {
        return this.m_overwriteMode;
    }

    private static void throwAsMalformedURLException(String message, Exception cause) throws MalformedURLException {
        MalformedURLException exception = new MalformedURLException(message);
        exception.initCause(cause);
        throw exception;
    }
}

