/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven;

import com.google.common.io.Closeables;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.maven.plugin.logging.Log;

public class Zips {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createZipFile(Log log, File sourceDir, File outputZipFile) throws IOException {
        outputZipFile.getParentFile().mkdirs();
        FileOutputStream os = new FileOutputStream(outputZipFile);
        ZipOutputStream zos = new ZipOutputStream(os);
        try {
            String path = "";
            FileFilter filter = null;
            Zips.zipDirectory(log, sourceDir, zos, path, filter);
        }
        finally {
            try {
                zos.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipDirectory(Log log, File directory, ZipOutputStream zos, String path, FileFilter filter) throws IOException {
        File[] dirList = directory.listFiles();
        byte[] readBuffer = new byte[8192];
        int bytesIn = 0;
        if (dirList != null) {
            for (File f : dirList) {
                if (f.isDirectory()) {
                    String prefix = path + f.getName() + "/";
                    zos.putNextEntry(new ZipEntry(prefix));
                    Zips.zipDirectory(log, f, zos, prefix, filter);
                } else {
                    String entry = path + f.getName();
                    if (filter == null || filter.accept(f)) {
                        try (FileInputStream fis = new FileInputStream(f);){
                            ZipEntry anEntry = new ZipEntry(entry);
                            zos.putNextEntry(anEntry);
                            bytesIn = fis.read(readBuffer);
                            while (bytesIn != -1) {
                                zos.write(readBuffer, 0, bytesIn);
                                bytesIn = fis.read(readBuffer);
                            }
                        }
                        log.info((CharSequence)("zipping file " + entry));
                    }
                }
                zos.closeEntry();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(InputStream in, File toDir) throws IOException {
        ZipInputStream zis = new ZipInputStream(new BufferedInputStream(in));
        try {
            ZipEntry entry = zis.getNextEntry();
            while (entry != null) {
                if (!entry.isDirectory()) {
                    String entryName = entry.getName();
                    File toFile = new File(toDir, entryName);
                    toFile.getParentFile().mkdirs();
                    FileOutputStream os = new FileOutputStream(toFile);
                    try {
                        try {
                            Zips.copy(zis, os);
                        }
                        finally {
                            zis.closeEntry();
                        }
                    }
                    finally {
                        Closeables.close((Closeable)os, (boolean)true);
                    }
                }
                entry = zis.getNextEntry();
            }
        }
        finally {
            Closeables.close((Closeable)zis, (boolean)true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void copy(InputStream is, OutputStream os) throws IOException {
        try {
            byte[] b = new byte[4096];
            int l = is.read(b);
            while (l >= 0) {
                os.write(b, 0, l);
                l = is.read(b);
            }
        }
        finally {
            Closeables.close((Closeable)os, (boolean)true);
        }
    }

    public static List<String> notNullList(List<String> list) {
        if (list == null) {
            return Collections.EMPTY_LIST;
        }
        return list;
    }
}

