/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.gateway.fabric.http;

import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.api.scr.Configurer;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.gateway.fabric.http.FabricHTTPGateway;
import io.fabric8.gateway.fabric.support.http.HttpMappingRuleBase;
import io.fabric8.gateway.fabric.support.http.HttpMappingZooKeeperTreeCache;
import io.fabric8.gateway.handlers.http.HttpMappingRule;
import io.fabric8.gateway.loadbalancer.LoadBalancer;
import io.fabric8.gateway.loadbalancer.LoadBalancers;
import io.fabric8.internal.Objects;
import io.fabric8.zookeeper.internal.SimplePathTemplate;
import java.util.Map;
import org.apache.curator.framework.CuratorFramework;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyOption;
import org.apache.felix.scr.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(name="io.fabric8.gateway.http.mapping", immediate=true, metatype=true, policy=ConfigurationPolicy.REQUIRE, label="Fabric8 HTTP Gateway Mapping Rule", description="Provides a mapping between part of the fabric cluster and a HTTP URI template")
public final class HttpMappingRuleConfiguration
extends AbstractComponent {
    private static final transient Logger LOG = LoggerFactory.getLogger(HttpMappingRuleConfiguration.class);
    @Reference
    private Configurer configurer;
    @Reference(referenceInterface=CuratorFramework.class)
    private final ValidatingReference<CuratorFramework> curator = new ValidatingReference();
    @Reference(referenceInterface=FabricHTTPGateway.class)
    private final ValidatingReference<FabricHTTPGateway> gateway = new ValidatingReference();
    @Property(name="zooKeeperPath", value={"/fabric/registry/clusters/webapps"}, label="ZooKeeper path", description="The path in ZooKeeper which is monitored to discover the available web services or web applications")
    private String zooKeeperPath;
    @Property(name="uriTemplate", value={"{contextPath}/"}, label="URI template", description="The URI template mapping the URI to the underlying service implementation.\nThis can use a number of URI template values such as 'contextPath', 'version', 'serviceName'")
    private String uriTemplate;
    @Property(name="enabledVersion", label="Enable version", description="Specify the exact profile version to expose; if none is specified then the gateways current profile version is used.\nIf a {version} URI template is used then all versions are exposed.")
    private String enabledVersion;
    @Property(name="reverseHeaders", boolValue={true}, label="Reverse headers", description="If enabled then the URL in the Location, Content-Location and URI headers from the proxied HTTP responses are rewritten from the back end service URL to match the front end URL on the gateway.\nThis is equivalent to the ProxyPassReverse directive in mod_proxy.")
    private boolean reverseHeaders = true;
    @Property(name="loadBalancerType", value={"roundrobin"}, options={@PropertyOption(name="random", value="Random"), @PropertyOption(name="roundrobin", value="Round Robin"), @PropertyOption(name="sticky", value="Sticky")}, label="Load Balancer", description="The kind of load balancing strategy used")
    private String loadBalancerType;
    @Property(name="stickyLoadBalancerCacheSize", intValue={10000}, label="Sticky Load Balancer Cache Size", description="The number of unique client keys to cache for the sticky load balancer (using an LRU caching algorithm)")
    private int stickyLoadBalancerCacheSize = 10000;
    private HttpMappingRuleBase httpMappingRuleBase;
    private HttpMappingZooKeeperTreeCache mappingTree;

    @Activate
    void activate(Map<String, ?> configuration) throws Exception {
        this.activateComponent();
        this.updateConfiguration(configuration);
    }

    @Modified
    void modified(Map<String, ?> configuration) throws Exception {
        this.deactivateInternal();
        this.updateConfiguration(configuration);
    }

    @Deactivate
    void deactivate() {
        ((FabricHTTPGateway)((Object)this.gateway.get())).removeMappingRuleConfiguration((HttpMappingRule)this.httpMappingRuleBase);
        this.httpMappingRuleBase = null;
        this.deactivateInternal();
        this.deactivateComponent();
    }

    String getZooKeeperPath() {
        return this.zooKeeperPath;
    }

    void setZooKeeperPath(String zooKeeperPath) {
        this.zooKeeperPath = zooKeeperPath;
    }

    String getEnabledVersion() {
        return this.enabledVersion;
    }

    void setEnabledVersion(String enabledVersion) {
        this.enabledVersion = enabledVersion;
    }

    String getUriTemplate() {
        return this.uriTemplate;
    }

    void setUriTemplate(String uriTemplate) {
        this.uriTemplate = uriTemplate;
    }

    String getLoadBalancerType() {
        return this.loadBalancerType;
    }

    void setLoadBalancerType(String loadBalancerType) {
        this.loadBalancerType = loadBalancerType;
    }

    private void updateConfiguration(Map<String, ?> configuration) throws Exception {
        LOG.info("activating http mapping rule " + configuration);
        this.configurer.configure(configuration, (Object)this, new String[0]);
        LOG.info("activating http mapping rule " + this.zooKeeperPath + " on " + ((FabricHTTPGateway)((Object)this.gateway.get())).getPort());
        String zkPath = this.getZooKeeperPath();
        Objects.notNull((Object)zkPath, (String)"zooKeeperPath");
        Objects.notNull((Object)this.getUriTemplate(), (String)"uriTemplate");
        LoadBalancer loadBalancer = LoadBalancers.createLoadBalancer((String)this.loadBalancerType, (int)this.stickyLoadBalancerCacheSize);
        LOG.info("activating http mapping ZooKeeper path: " + zkPath + " with URI template: " + this.uriTemplate + " enabledVersion: " + this.enabledVersion + " with load balancer: " + loadBalancer);
        if (this.httpMappingRuleBase != null) {
            ((FabricHTTPGateway)((Object)this.gateway.get())).removeMappingRuleConfiguration((HttpMappingRule)this.httpMappingRuleBase);
        }
        this.httpMappingRuleBase = new HttpMappingRuleBase(new SimplePathTemplate(this.uriTemplate), ((FabricHTTPGateway)((Object)this.gateway.get())).getGatewayVersion(), this.enabledVersion, loadBalancer, this.reverseHeaders);
        this.mappingTree = new HttpMappingZooKeeperTreeCache((CuratorFramework)this.curator.get(), (HttpMappingRule)this.httpMappingRuleBase, this.zooKeeperPath);
        this.mappingTree.init();
        ((FabricHTTPGateway)((Object)this.gateway.get())).addMappingRuleConfiguration((HttpMappingRule)this.httpMappingRuleBase);
    }

    private void deactivateInternal() {
        if (this.mappingTree != null) {
            this.mappingTree.destroy();
            this.mappingTree = null;
        }
    }

    void bindCurator(CuratorFramework curator) {
        this.curator.bind((Object)curator);
    }

    void unbindCurator(CuratorFramework curator) {
        this.curator.unbind((Object)curator);
    }

    void bindGateway(FabricHTTPGateway gateway) {
        this.gateway.bind((Object)gateway);
    }

    void unbindGateway(FabricHTTPGateway gateway) {
        this.gateway.unbind((Object)gateway);
    }

    public String toString() {
        return "HttpMappingRuleConfiguration{zooKeeperPath='" + this.zooKeeperPath + '\'' + ", uriTemplate='" + this.uriTemplate + '\'' + ", enabledVersion='" + this.enabledVersion + '\'' + '}';
    }

    protected void bindConfigurer(Configurer configurer) {
        this.configurer = configurer;
    }

    protected void unbindConfigurer(Configurer configurer) {
        if (this.configurer == configurer) {
            this.configurer = null;
        }
    }
}

