/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.gateway.fabric.mq;

import io.fabric8.api.FabricService;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.api.scr.Configurer;
import io.fabric8.common.util.Strings;
import io.fabric8.gateway.ServiceMap;
import io.fabric8.gateway.fabric.mq.GatewayServiceTreeCache;
import io.fabric8.gateway.fabric.support.vertx.VertxService;
import io.fabric8.gateway.handlers.tcp.TcpGateway;
import io.fabric8.gateway.handlers.tcp.TcpGatewayHandler;
import io.fabric8.gateway.loadbalancer.LoadBalancer;
import io.fabric8.gateway.loadbalancer.LoadBalancers;
import io.fabric8.internal.Objects;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.curator.framework.CuratorFramework;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyOption;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;

@Component(name="io.fabric8.gateway.mq", immediate=true, metatype=true, policy=ConfigurationPolicy.REQUIRE, label="Fabric8 MQ Gateway", description="Provides a discovery and load balancing gateway between clients using various messaging protocols and the available message brokers in the fabric")
public class FabricMQGateway
extends AbstractComponent {
    private static final transient Logger LOG = LoggerFactory.getLogger(FabricMQGateway.class);
    @Reference
    private Configurer configurer;
    @Reference(referenceInterface=VertxService.class, cardinality=ReferenceCardinality.MANDATORY_UNARY, bind="setVertxService", unbind="unsetVertxService")
    private VertxService vertxService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY, bind="setFabricService", unbind="unsetFabricService")
    private FabricService fabricService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY, bind="setCurator", unbind="unsetCurator")
    private CuratorFramework curator;
    @Property(name="zooKeeperPath", value={"/fabric/registry/clusters/amq"}, label="ZooKeeper path", description="The path in ZooKeeper which is monitored to discover the available message brokers")
    private String zooKeeperPath;
    @Property(name="host", label="Host name", description="The host name used when listening on the various messaging ports")
    private String host;
    @Property(name="openWireEnabled", boolValue={true}, label="OpenWire enabled", description="Enable or disable the OpenWire transport protocol")
    private boolean openWireEnabled = true;
    @Property(name="openWirePort", intValue={61616}, label="OpenWire port", description="Port number to listen on for OpenWire")
    private int openWirePort = 61616;
    @Property(name="stompEnabled", boolValue={true}, label="STOMP enabled", description="Enable or disable the STOMP transport protocol")
    private boolean stompEnabled = true;
    @Property(name="stompPort", intValue={61613}, label="STOMP port", description="Port number to listen on for STOMP")
    private int stompPort = 61613;
    @Property(name="amqpEnabled", boolValue={true}, label="AMQP enabled", description="Enable or disable the AMQP transport protocol")
    private boolean amqpEnabled = true;
    @Property(name="amqpPort", intValue={5672}, label="AMQP port", description="Port number to listen on for AMQP")
    private int amqpPort = 5672;
    @Property(name="mqttEnabled", boolValue={true}, label="MQTT enabled", description="Enable or disable the MQTT transport protocol")
    private boolean mqttEnabled = true;
    @Property(name="mqttPort", intValue={1883}, label="MQTT port", description="Port number to listen on for MQTT")
    private int mqttPort = 1883;
    @Property(name="websocketEnabled", boolValue={true}, label="WebSocket enabled", description="Enable or disable the WebSocket transport protocol")
    private boolean websocketEnabled = true;
    @Property(name="websocketPort", intValue={61614}, label="WebSocket port", description="Port number to listen on for WebSocket")
    private int websocketPort = 61614;
    @Property(name="loadBalancerType", value={"roundrobin"}, options={@PropertyOption(name="random", value="Random"), @PropertyOption(name="roundrobin", value="Round Robin"), @PropertyOption(name="sticky", value="Sticky")}, label="Load Balancer", description="The kind of load balancing strategy used")
    private String loadBalancerType;
    @Property(name="stickyLoadBalancerCacheSize", intValue={10000}, label="Sticky Load Balancer Cache Size", description="The number of unique client keys to cache for the sticky load balancer (using an LRU caching algorithm)")
    private int stickyLoadBalancerCacheSize = 10000;
    private GatewayServiceTreeCache gatewayServiceTreeCache;

    @Activate
    void activate(Map<String, ?> configuration) throws Exception {
        this.configurer.configure(configuration, (Object)this, new String[0]);
        Objects.notNull((Object)this.getVertxService(), (String)"vertxService");
        Objects.notNull((Object)this.getZooKeeperPath(), (String)"zooKeeperPath");
        this.activateComponent();
        this.gatewayServiceTreeCache = this.createListener();
        if (this.gatewayServiceTreeCache != null) {
            this.gatewayServiceTreeCache.init();
        }
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
        if (this.gatewayServiceTreeCache != null) {
            this.gatewayServiceTreeCache.destroy();
        }
    }

    protected GatewayServiceTreeCache createListener() {
        String zkPath = this.getZooKeeperPath();
        ServiceMap serviceMap = new ServiceMap();
        VertxService vertxService = this.getVertxService();
        Vertx vertx = vertxService.getVertx();
        CuratorFramework curator = this.getCurator();
        LoadBalancer pathLoadBalancer = LoadBalancers.createLoadBalancer((String)this.loadBalancerType, (int)this.stickyLoadBalancerCacheSize);
        LoadBalancer serviceLoadBalancer = LoadBalancers.createLoadBalancer((String)this.loadBalancerType, (int)this.stickyLoadBalancerCacheSize);
        LOG.info("activating MQ mapping ZooKeeper path: " + zkPath + " host: " + this.host + " with load balancer: " + pathLoadBalancer);
        ArrayList<TcpGateway> gateways = new ArrayList<TcpGateway>();
        this.addGateway(gateways, vertx, serviceMap, "tcp", this.isOpenWireEnabled(), this.getOpenWirePort(), pathLoadBalancer, serviceLoadBalancer);
        this.addGateway(gateways, vertx, serviceMap, "stomp", this.isStompEnabled(), this.getStompPort(), pathLoadBalancer, serviceLoadBalancer);
        this.addGateway(gateways, vertx, serviceMap, "amqp", this.isAmqpEnabled(), this.getAmqpPort(), pathLoadBalancer, serviceLoadBalancer);
        this.addGateway(gateways, vertx, serviceMap, "mqtt", this.isMqttEnabled(), this.getMqttPort(), pathLoadBalancer, serviceLoadBalancer);
        this.addGateway(gateways, vertx, serviceMap, "ws", this.isWebsocketEnabled(), this.getWebsocketPort(), pathLoadBalancer, serviceLoadBalancer);
        if (gateways.isEmpty()) {
            return null;
        }
        return new GatewayServiceTreeCache(curator, zkPath, serviceMap, gateways);
    }

    protected TcpGateway addGateway(List<TcpGateway> gateways, Vertx vertx, ServiceMap serviceMap, String protocolName, boolean enabled, int listenPort, LoadBalancer pathLoadBalancer, LoadBalancer serviceLoadBalancer) {
        if (enabled) {
            TcpGatewayHandler handler = new TcpGatewayHandler(vertx, serviceMap, protocolName, pathLoadBalancer, serviceLoadBalancer);
            TcpGateway gateway = new TcpGateway(vertx, serviceMap, listenPort, protocolName, (Handler)handler);
            if (Strings.isNotBlank((String)this.host)) {
                gateway.setHost(this.host);
            }
            gateways.add(gateway);
            return gateway;
        }
        return null;
    }

    public VertxService getVertxService() {
        return this.vertxService;
    }

    public void setVertxService(VertxService vertxService) {
        this.vertxService = vertxService;
    }

    public void unsetVertxService(VertxService vertxService) {
        this.vertxService = null;
    }

    public CuratorFramework getCurator() {
        return this.curator;
    }

    public void setCurator(CuratorFramework curator) {
        this.curator = curator;
    }

    public void unsetCurator(CuratorFramework curator) {
        this.curator = null;
    }

    public FabricService getFabricService() {
        return this.fabricService;
    }

    public void setFabricService(FabricService fabricService) {
        this.fabricService = fabricService;
    }

    public void unsetFabricService(FabricService fabricService) {
        this.fabricService = null;
    }

    public String getZooKeeperPath() {
        return this.zooKeeperPath;
    }

    public void setZooKeeperPath(String zooKeeperPath) {
        this.zooKeeperPath = zooKeeperPath;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public boolean isOpenWireEnabled() {
        return this.openWireEnabled;
    }

    public void setOpenWireEnabled(boolean openWireEnabled) {
        this.openWireEnabled = openWireEnabled;
    }

    public int getOpenWirePort() {
        return this.openWirePort;
    }

    public void setOpenWirePort(int openWirePort) {
        this.openWirePort = openWirePort;
    }

    public boolean isStompEnabled() {
        return this.stompEnabled;
    }

    public void setStompEnabled(boolean stompEnabled) {
        this.stompEnabled = stompEnabled;
    }

    public int getStompPort() {
        return this.stompPort;
    }

    public void setStompPort(int stompPort) {
        this.stompPort = stompPort;
    }

    public boolean isAmqpEnabled() {
        return this.amqpEnabled;
    }

    public void setAmqpEnabled(boolean amqpEnabled) {
        this.amqpEnabled = amqpEnabled;
    }

    public int getAmqpPort() {
        return this.amqpPort;
    }

    public void setAmqpPort(int amqpPort) {
        this.amqpPort = amqpPort;
    }

    public boolean isMqttEnabled() {
        return this.mqttEnabled;
    }

    public void setMqttEnabled(boolean mqttEnabled) {
        this.mqttEnabled = mqttEnabled;
    }

    public int getMqttPort() {
        return this.mqttPort;
    }

    public void setMqttPort(int mqttPort) {
        this.mqttPort = mqttPort;
    }

    public boolean isWebsocketEnabled() {
        return this.websocketEnabled;
    }

    public void setWebsocketEnabled(boolean websocketEnabled) {
        this.websocketEnabled = websocketEnabled;
    }

    public int getWebsocketPort() {
        return this.websocketPort;
    }

    public void setWebsocketPort(int websocketPort) {
        this.websocketPort = websocketPort;
    }

    protected void bindConfigurer(Configurer configurer) {
        this.configurer = configurer;
    }

    protected void unbindConfigurer(Configurer configurer) {
        if (this.configurer == configurer) {
            this.configurer = null;
        }
    }
}

