/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.itests.basic;

import io.fabric8.api.Container;
import io.fabric8.api.FabricService;
import io.fabric8.api.ServiceProxy;
import io.fabric8.itests.paxexam.support.ContainerBuilder;
import io.fabric8.itests.paxexam.support.FabricTestSupport;
import io.fabric8.itests.paxexam.support.Provision;
import java.util.Set;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.junit.Configuration;
import org.ops4j.pax.exam.junit.ExamReactorStrategy;
import org.ops4j.pax.exam.junit.JUnit4TestRunner;
import org.ops4j.pax.exam.options.DefaultCompositeOption;
import org.ops4j.pax.exam.spi.reactors.AllConfinedStagedReactorFactory;
import org.osgi.framework.BundleContext;

@RunWith(value=JUnit4TestRunner.class)
@ExamReactorStrategy(value={AllConfinedStagedReactorFactory.class})
public class ContainerRegistrationTest
extends FabricTestSupport {
    @Inject
    BundleContext bundleContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testContainerRegistration() throws Exception {
        System.err.println(ContainerRegistrationTest.executeCommand((String)"fabric:create -n"));
        ServiceProxy fabricProxy = ServiceProxy.createServiceProxy((BundleContext)this.bundleContext, FabricService.class);
        try {
            this.waitForFabricCommands();
            System.err.println(ContainerRegistrationTest.executeCommand((String)"fabric:profile-create --parents default child-profile"));
            Assert.assertTrue((boolean)Provision.profileAvailable((BundleContext)this.bundleContext, (String)"child-profile", (String)"1.0", (Long)DEFAULT_TIMEOUT));
            Set containers = ContainerBuilder.create((ServiceProxy)fabricProxy, (int)1, (int)1).withName("cnt").withProfiles("child-profile").assertProvisioningResult().build();
            try {
                Container child1 = (Container)containers.iterator().next();
                System.err.println(ContainerRegistrationTest.executeCommand((String)"fabric:profile-edit --import-pid --pid org.apache.karaf.shell child-profile"));
                System.err.println(ContainerRegistrationTest.executeCommand((String)"fabric:profile-edit --pid org.apache.karaf.shell/sshPort=8105 child-profile"));
                System.err.println(ContainerRegistrationTest.executeCommand((String)"fabric:profile-edit --import-pid --pid org.apache.karaf.management child-profile"));
                System.err.println(ContainerRegistrationTest.executeCommand((String)"fabric:profile-edit --pid org.apache.karaf.management/rmiServerPort=55555 child-profile"));
                System.err.println(ContainerRegistrationTest.executeCommand((String)"fabric:profile-edit --pid org.apache.karaf.management/rmiRegistryPort=1100 child-profile"));
                System.err.println(ContainerRegistrationTest.executeCommand((String)("fabric:profile-edit --pid org.apache.karaf.management/serviceUrl=service:jmx:rmi://localhost:55555/jndi/rmi://localhost:1099/karaf-" + child1.getId() + " child-profile")));
                Thread.sleep(DEFAULT_TIMEOUT);
                String sshUrl = child1.getSshUrl();
                String jmxUrl = child1.getJmxUrl();
                Assert.assertTrue((boolean)sshUrl.endsWith("8105"));
                Assert.assertTrue((boolean)jmxUrl.contains("55555"));
            }
            finally {
                ContainerBuilder.destroy((Set)containers);
            }
        }
        finally {
            fabricProxy.close();
        }
    }

    @Configuration
    public Option[] config() {
        return new Option[]{new DefaultCompositeOption(this.fabricDistributionConfiguration())};
    }
}

