/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.itests.basic;

import io.fabric8.api.Container;
import io.fabric8.api.CreateContainerMetadata;
import io.fabric8.api.CreateContainerOptions;
import io.fabric8.api.FabricService;
import io.fabric8.api.ServiceProxy;
import io.fabric8.itests.paxexam.support.FabricTestSupport;
import io.fabric8.itests.paxexam.support.Provision;
import io.fabric8.service.ssh.CreateSshContainerOptions;
import java.util.Arrays;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.junit.Configuration;
import org.ops4j.pax.exam.junit.ExamReactorStrategy;
import org.ops4j.pax.exam.junit.JUnit4TestRunner;
import org.ops4j.pax.exam.options.DefaultCompositeOption;
import org.ops4j.pax.exam.spi.reactors.AllConfinedStagedReactorFactory;
import org.osgi.framework.BundleContext;

@RunWith(value=JUnit4TestRunner.class)
@ExamReactorStrategy(value={AllConfinedStagedReactorFactory.class})
public class CreateSshContainerTest
extends FabricTestSupport {
    private String host;
    private String port;
    private String username;
    private String password;

    @Before
    public void setUp() {
        this.host = System.getProperty("fabricitest.ssh.host");
        this.port = System.getProperty("fabricitest.ssh.port");
        this.username = System.getProperty("fabricitest.ssh.username");
        this.password = System.getProperty("fabricitest.ssh.password");
    }

    @After
    public void tearDown() {
        if (this.isReady()) {
            CreateSshContainerTest.executeCommand((String)"fabric:container-stop ssh2");
            CreateSshContainerTest.executeCommand((String)"fabric:container-delete ssh2");
            CreateSshContainerTest.executeCommand((String)"fabric:container-stop ssh1");
            CreateSshContainerTest.executeCommand((String)"fabric:container-delete ssh1");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSshContainerProvider() throws Throwable {
        Assume.assumeTrue((boolean)this.isReady());
        System.err.println(CreateSshContainerTest.executeCommand((String)"fabric:create -n"));
        ServiceProxy fabricProxy = ServiceProxy.createServiceProxy((BundleContext)this.bundleContext, FabricService.class);
        try {
            FabricService fabricService = (FabricService)fabricProxy.getService();
            CreateSshContainerOptions options = ((CreateSshContainerOptions.Builder)CreateSshContainerOptions.builder().name("ssh1")).host(this.host).port(Integer.parseInt(this.port)).username(this.username).password(this.password).build();
            CreateContainerMetadata[] metadata = fabricService.createContainers((CreateContainerOptions)options);
            Assert.assertNotNull((Object)metadata);
            Assert.assertEquals((int)1, (int)metadata.length);
            if (metadata[0].getFailure() != null) {
                throw metadata[0].getFailure();
            }
            Assert.assertTrue((String)"Expected successful creation of remote ssh container", (boolean)metadata[0].isSuccess());
            Assert.assertNotNull((String)"Expected successful creation of remote ssh container", (Object)metadata[0].getContainer());
            Provision.containersStatus(Arrays.asList(metadata[0].getContainer()), (String)"success", (Long)PROVISION_TIMEOUT);
            System.out.println(CreateSshContainerTest.executeCommand((String)"fabric:container-list -v"));
            System.out.println(CreateSshContainerTest.executeCommand((String)"fabric:container-resolver-list"));
            Container ssh1 = fabricService.getContainer("ssh1");
            Assert.assertTrue((boolean)ssh1.isAlive());
            this.createAndAssertChildContainer(fabricService, "ssh2", "ssh1", "default");
            Container ssh2 = fabricService.getContainer("ssh2");
            ssh2.stop();
            Assert.assertFalse((boolean)ssh2.isAlive());
            ssh2.start();
            Provision.containersStatus(Arrays.asList(ssh2), (String)"success", (Long)PROVISION_TIMEOUT);
            Assert.assertTrue((boolean)ssh2.isAlive());
            ssh2.stop();
            ssh1.stop();
            Assert.assertFalse((boolean)ssh1.isAlive());
            System.out.println(CreateSshContainerTest.executeCommand((String)"fabric:container-list -v"));
            ssh1.start();
            Provision.containersStatus(Arrays.asList(ssh1), (String)"success", (Long)PROVISION_TIMEOUT);
            System.out.println(CreateSshContainerTest.executeCommand((String)"fabric:container-list -v"));
            Assert.assertTrue((boolean)ssh1.isAlive());
        }
        finally {
            fabricProxy.close();
        }
    }

    private boolean isReady() {
        return this.host != null && this.port != null && this.username != null & this.password != null && !this.host.isEmpty() && !this.port.isEmpty() && !this.username.isEmpty() && !this.password.isEmpty();
    }

    @Configuration
    public Option[] config() {
        return new Option[]{new DefaultCompositeOption(this.fabricDistributionConfiguration()), CreateSshContainerTest.copySystemProperty((String)"fabricitest.ssh.username"), CreateSshContainerTest.copySystemProperty((String)"fabricitest.ssh.password"), CreateSshContainerTest.copySystemProperty((String)"fabricitest.ssh.host"), CreateSshContainerTest.copySystemProperty((String)"fabricitest.ssh.port")};
    }
}

