/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.itests.basic;

import io.fabric8.api.Container;
import io.fabric8.api.FabricService;
import io.fabric8.api.ServiceLocator;
import io.fabric8.api.ServiceProxy;
import io.fabric8.itests.paxexam.support.ContainerBuilder;
import io.fabric8.itests.paxexam.support.FabricTestSupport;
import io.fabric8.itests.paxexam.support.Provision;
import io.fabric8.zookeeper.ZkPath;
import io.fabric8.zookeeper.utils.ZooKeeperUtils;
import java.util.Collection;
import java.util.Set;
import org.apache.curator.framework.CuratorFramework;
import org.apache.karaf.tooling.exam.options.KarafDistributionOption;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.junit.Configuration;
import org.ops4j.pax.exam.junit.ExamReactorStrategy;
import org.ops4j.pax.exam.junit.JUnit4TestRunner;
import org.ops4j.pax.exam.options.DefaultCompositeOption;
import org.ops4j.pax.exam.spi.reactors.AllConfinedStagedReactorFactory;
import org.osgi.framework.BundleContext;

@RunWith(value=JUnit4TestRunner.class)
@ExamReactorStrategy(value={AllConfinedStagedReactorFactory.class})
public class ExtendedCreateChildContainerTest
extends FabricTestSupport {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testContainerDelete() throws Exception {
        System.err.println(ExtendedCreateChildContainerTest.executeCommand((String)"fabric:create -n"));
        ServiceProxy fabricProxy = ServiceProxy.createServiceProxy((BundleContext)this.bundleContext, FabricService.class);
        try {
            System.err.println(ExtendedCreateChildContainerTest.executeCommand((String)"fabric:version-create"));
            Set containers = ContainerBuilder.child((ServiceProxy)fabricProxy, (int)1).withName("child").assertProvisioningResult().build();
            try {
                CuratorFramework curator = (CuratorFramework)ServiceLocator.awaitService((BundleContext)this.bundleContext, CuratorFramework.class);
                for (Container c : containers) {
                    try {
                        c.destroy();
                        Assert.assertNull((Object)ZooKeeperUtils.exists((CuratorFramework)curator, (String)ZkPath.CONFIG_VERSIONS_CONTAINER.getPath(new String[]{"1.1", c.getId()})));
                        Assert.assertNull((Object)ZooKeeperUtils.exists((CuratorFramework)curator, (String)ZkPath.CONFIG_VERSIONS_CONTAINER.getPath(new String[]{"1.0", c.getId()})));
                        Assert.assertNull((Object)ZooKeeperUtils.exists((CuratorFramework)curator, (String)ZkPath.CONTAINER.getPath(new String[]{c.getId()})));
                        Assert.assertNull((Object)ZooKeeperUtils.exists((CuratorFramework)curator, (String)ZkPath.CONTAINER_DOMAINS.getPath(new String[]{c.getId()})));
                        Assert.assertNull((Object)ZooKeeperUtils.exists((CuratorFramework)curator, (String)ZkPath.CONTAINER_PROVISION.getPath(new String[]{c.getId()})));
                    }
                    catch (Exception ex) {}
                }
            }
            finally {
                ContainerBuilder.destroy((Set)containers);
            }
        }
        finally {
            fabricProxy.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testContainerWithPasswordChange() throws Exception {
        System.err.println(ExtendedCreateChildContainerTest.executeCommand((String)"fabric:create -n"));
        ServiceProxy fabricProxy = ServiceProxy.createServiceProxy((BundleContext)this.bundleContext, FabricService.class);
        try {
            Set containers = ContainerBuilder.child((ServiceProxy)fabricProxy, (int)1).withName("child").assertProvisioningResult().build();
            try {
                Thread.sleep(5000L);
                Container container = (Container)containers.iterator().next();
                System.err.println(ExtendedCreateChildContainerTest.executeCommands((String[])new String[]{"jaas:manage --realm karaf --module io.fabric8.jaas.ZookeeperLoginModule", "jaas:userdel admin", "jaas:useradd admin newpassword", "jaas:roleadd admin admin", "jaas:update"}));
                System.err.println(ExtendedCreateChildContainerTest.executeCommand((String)("fabric:container-stop --user admin --password newpassword " + container.getId())));
                Provision.containersAlive((Collection)containers, (boolean)false, (Long)(6L * DEFAULT_TIMEOUT));
            }
            finally {
                ContainerBuilder.destroy((Set)containers);
            }
        }
        finally {
            fabricProxy.close();
        }
    }

    @Configuration
    public Option[] config() {
        return new Option[]{new DefaultCompositeOption(this.fabricDistributionConfiguration()), KarafDistributionOption.debugConfiguration((String)"5005", (boolean)false)};
    }
}

