/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.itests.basic;

import io.fabric8.api.Container;
import io.fabric8.api.FabricService;
import io.fabric8.api.ServiceLocator;
import io.fabric8.api.ServiceProxy;
import io.fabric8.api.ZooKeeperClusterService;
import io.fabric8.itests.paxexam.support.ContainerBuilder;
import io.fabric8.itests.paxexam.support.FabricEnsembleTest;
import io.fabric8.itests.paxexam.support.Provision;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.junit.Configuration;
import org.ops4j.pax.exam.junit.ExamReactorStrategy;
import org.ops4j.pax.exam.junit.JUnit4TestRunner;
import org.ops4j.pax.exam.options.DefaultCompositeOption;
import org.ops4j.pax.exam.spi.reactors.AllConfinedStagedReactorFactory;
import org.osgi.framework.BundleContext;

@RunWith(value=JUnit4TestRunner.class)
@ExamReactorStrategy(value={AllConfinedStagedReactorFactory.class})
public class ExtendedEnsembleTest
extends FabricEnsembleTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddAndRemoveWithVersions() throws Exception {
        System.err.println(ExtendedEnsembleTest.executeCommand((String)"fabric:create -n"));
        ServiceProxy fabricProxy = ServiceProxy.createServiceProxy((BundleContext)this.bundleContext, FabricService.class);
        try {
            FabricService fabricService = (FabricService)fabricProxy.getService();
            System.err.println(ExtendedEnsembleTest.executeCommand((String)"fabric:version-create --parent 1.0 1.1"));
            System.err.println(ExtendedEnsembleTest.executeCommand((String)"fabric:container-upgrade --all 1.1"));
            Set containers = ContainerBuilder.create((ServiceProxy)fabricProxy, (int)2).withName("ens").withProfiles("default").assertProvisioningResult().build();
            try {
                List ensembleContainersResult;
                ZooKeeperClusterService zooKeeperClusterService;
                Container cnt2;
                Container cnt1;
                int e;
                LinkedList<Container> containerQueue = new LinkedList<Container>(containers);
                LinkedList<Container> addedContainers = new LinkedList<Container>();
                System.err.println(ExtendedEnsembleTest.executeCommand((String)"fabric:version-create"));
                System.err.println(ExtendedEnsembleTest.executeCommand((String)"fabric:container-upgrade --all 1.2"));
                for (e = 0; e < 3 && containerQueue.size() >= 2 && containerQueue.size() % 2 == 0; ++e) {
                    cnt1 = (Container)containerQueue.removeFirst();
                    cnt2 = (Container)containerQueue.removeFirst();
                    addedContainers.add(cnt1);
                    addedContainers.add(cnt2);
                    this.addToEnsemble(fabricService, new Container[]{cnt1, cnt2});
                    System.err.println(ExtendedEnsembleTest.executeCommand((String)"config:proplist --pid io.fabric8.zookeeper"));
                    System.err.println(ExtendedEnsembleTest.executeCommand((String)"fabric:container-list"));
                    System.err.println(ExtendedEnsembleTest.executeCommand((String)"fabric:ensemble-list"));
                    zooKeeperClusterService = (ZooKeeperClusterService)ServiceLocator.awaitService((BundleContext)this.bundleContext, ZooKeeperClusterService.class);
                    Assert.assertNotNull((Object)zooKeeperClusterService);
                    ensembleContainersResult = zooKeeperClusterService.getEnsembleContainers();
                    Assert.assertTrue((boolean)ensembleContainersResult.contains(cnt1.getId()));
                    Assert.assertTrue((boolean)ensembleContainersResult.contains(cnt2.getId()));
                    Provision.provisioningSuccess(Arrays.asList(fabricService.getContainers()), (Long)PROVISION_TIMEOUT);
                }
                System.err.println(ExtendedEnsembleTest.executeCommand((String)"fabric:version-create"));
                System.err.println(ExtendedEnsembleTest.executeCommand((String)"fabric:container-upgrade --all 1.3"));
                for (e = 0; e < 3 && addedContainers.size() >= 2 && addedContainers.size() % 2 == 0; ++e) {
                    cnt1 = (Container)addedContainers.removeFirst();
                    cnt2 = (Container)addedContainers.removeFirst();
                    containerQueue.add(cnt1);
                    containerQueue.add(cnt2);
                    this.removeFromEnsemble(fabricService, new Container[]{cnt1, cnt2});
                    System.err.println(ExtendedEnsembleTest.executeCommand((String)"config:proplist --pid io.fabric8.zookeeper"));
                    System.err.println(ExtendedEnsembleTest.executeCommand((String)"fabric:container-list"));
                    System.err.println(ExtendedEnsembleTest.executeCommand((String)"fabric:ensemble-list"));
                    zooKeeperClusterService = (ZooKeeperClusterService)ServiceLocator.awaitService((BundleContext)this.bundleContext, ZooKeeperClusterService.class);
                    Assert.assertNotNull((Object)zooKeeperClusterService);
                    ensembleContainersResult = zooKeeperClusterService.getEnsembleContainers();
                    Assert.assertFalse((boolean)ensembleContainersResult.contains(cnt1.getId()));
                    Assert.assertFalse((boolean)ensembleContainersResult.contains(cnt2.getId()));
                    Provision.provisioningSuccess(Arrays.asList(fabricService.getContainers()), (Long)PROVISION_TIMEOUT);
                }
            }
            finally {
                ContainerBuilder.destroy((Set)containers);
            }
        }
        finally {
            fabricProxy.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddAndRemoveWithPartialVersionUpgrades() throws Exception {
        System.err.println(ExtendedEnsembleTest.executeCommand((String)"fabric:create -n"));
        ServiceProxy fabricProxy = ServiceProxy.createServiceProxy((BundleContext)this.bundleContext, FabricService.class);
        try {
            FabricService fabricService = (FabricService)fabricProxy.getService();
            System.err.println(ExtendedEnsembleTest.executeCommand((String)"fabric:version-create"));
            System.err.println(ExtendedEnsembleTest.executeCommand((String)"fabric:container-upgrade --all 1.1"));
            Set containers = ContainerBuilder.create((ServiceProxy)fabricProxy, (int)2).withName("ens").withProfiles("fabric").assertProvisioningResult().build();
            try {
                LinkedList<Container> containerQueue = new LinkedList<Container>(containers);
                LinkedList<Container> addedContainers = new LinkedList<Container>();
                System.err.println(ExtendedEnsembleTest.executeCommand((String)"fabric:version-create"));
                System.err.println(ExtendedEnsembleTest.executeCommand((String)"fabric:container-upgrade --all 1.2"));
                Random rand = new Random();
                for (int version = 3; version < 5; ++version) {
                    Provision.provisioningSuccess(Arrays.asList(fabricService.getContainers()), (Long)PROVISION_TIMEOUT);
                    for (int e = 0; e < 3 && containerQueue.size() >= 2 && containerQueue.size() % 2 == 0; ++e) {
                        Container cnt1 = (Container)containerQueue.removeFirst();
                        Container cnt2 = (Container)containerQueue.removeFirst();
                        addedContainers.add(cnt1);
                        addedContainers.add(cnt2);
                        this.addToEnsemble(fabricService, new Container[]{cnt1, cnt2});
                        System.err.println(ExtendedEnsembleTest.executeCommand((String)"config:proplist --pid io.fabric8.zookeeper"));
                        System.err.println(ExtendedEnsembleTest.executeCommand((String)"fabric:container-list"));
                        System.err.println(ExtendedEnsembleTest.executeCommand((String)"fabric:ensemble-list"));
                        ZooKeeperClusterService zooKeeperClusterService = (ZooKeeperClusterService)ServiceLocator.awaitService((BundleContext)this.bundleContext, ZooKeeperClusterService.class);
                        Assert.assertNotNull((Object)zooKeeperClusterService);
                        List ensembleContainersResult = zooKeeperClusterService.getEnsembleContainers();
                        Assert.assertTrue((boolean)ensembleContainersResult.contains(cnt1.getId()));
                        Assert.assertTrue((boolean)ensembleContainersResult.contains(cnt2.getId()));
                        Provision.provisioningSuccess(Arrays.asList(fabricService.getContainers()), (Long)PROVISION_TIMEOUT);
                    }
                    int index = rand.nextInt(addedContainers.size());
                    String randomContainer = ((Container)addedContainers.get(index)).getId();
                    System.err.println(ExtendedEnsembleTest.executeCommand((String)("fabric:version-create 1." + version)));
                    System.err.println(ExtendedEnsembleTest.executeCommand((String)("fabric:container-upgrade 1." + version + " " + randomContainer)));
                    Provision.provisioningSuccess(Arrays.asList(fabricService.getContainers()), (Long)PROVISION_TIMEOUT);
                    for (int e = 0; e < 3 && addedContainers.size() >= 2 && addedContainers.size() % 2 == 0; ++e) {
                        Container cnt1 = (Container)addedContainers.removeFirst();
                        Container cnt2 = (Container)addedContainers.removeFirst();
                        containerQueue.add(cnt1);
                        containerQueue.add(cnt2);
                        this.removeFromEnsemble(fabricService, new Container[]{cnt1, cnt2});
                        System.err.println(ExtendedEnsembleTest.executeCommand((String)"config:proplist --pid io.fabric8.zookeeper"));
                        System.err.println(ExtendedEnsembleTest.executeCommand((String)"fabric:container-list"));
                        System.err.println(ExtendedEnsembleTest.executeCommand((String)"fabric:ensemble-list"));
                        ZooKeeperClusterService zooKeeperClusterService = (ZooKeeperClusterService)ServiceLocator.awaitService((BundleContext)this.bundleContext, ZooKeeperClusterService.class);
                        Assert.assertNotNull((Object)zooKeeperClusterService);
                        List ensembleContainersResult = zooKeeperClusterService.getEnsembleContainers();
                        Assert.assertFalse((boolean)ensembleContainersResult.contains(cnt1.getId()));
                        Assert.assertFalse((boolean)ensembleContainersResult.contains(cnt2.getId()));
                        Provision.provisioningSuccess(Arrays.asList(fabricService.getContainers()), (Long)PROVISION_TIMEOUT);
                    }
                    System.err.println(ExtendedEnsembleTest.executeCommand((String)("fabric:container-rollback 1." + (version - 1) + " " + randomContainer)));
                }
            }
            finally {
                ContainerBuilder.destroy((Set)containers);
            }
        }
        finally {
            fabricProxy.close();
        }
    }

    @Configuration
    public Option[] config() {
        return new Option[]{new DefaultCompositeOption(this.fabricDistributionConfiguration())};
    }
}

