/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.itests.basic;

import io.fabric8.api.Container;
import io.fabric8.api.FabricService;
import io.fabric8.api.ServiceLocator;
import io.fabric8.api.ServiceProxy;
import io.fabric8.itests.paxexam.support.ContainerProxy;
import io.fabric8.itests.paxexam.support.FabricEnsembleTest;
import io.fabric8.itests.paxexam.support.Provision;
import java.util.Arrays;
import javax.inject.Inject;
import org.apache.karaf.admin.AdminService;
import org.apache.karaf.tooling.exam.options.KarafDistributionOption;
import org.junit.After;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.ops4j.pax.exam.MavenUtils;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.junit.Configuration;
import org.ops4j.pax.exam.junit.ExamReactorStrategy;
import org.ops4j.pax.exam.junit.JUnit4TestRunner;
import org.ops4j.pax.exam.options.DefaultCompositeOption;
import org.ops4j.pax.exam.spi.reactors.AllConfinedStagedReactorFactory;
import org.osgi.framework.BundleContext;

@RunWith(value=JUnit4TestRunner.class)
@ExamReactorStrategy(value={AllConfinedStagedReactorFactory.class})
public class ExtendedJoinTest
extends FabricEnsembleTest {
    private static final String WAIT_FOR_JOIN_SERVICE = "wait-for-service io.fabric8.boot.commands.service.JoinAvailable";
    @Inject
    BundleContext bundleContext;

    @After
    public void tearDown() throws InterruptedException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJoinAndAddToEnsemble() throws Exception {
        System.err.println(ExtendedJoinTest.executeCommand((String)"fabric:create -n"));
        ServiceProxy fabricProxy = ServiceProxy.createServiceProxy((BundleContext)this.bundleContext, FabricService.class);
        try {
            FabricService fabricService = (FabricService)fabricProxy.getService();
            AdminService adminService = (AdminService)ServiceLocator.awaitService((BundleContext)this.bundleContext, AdminService.class);
            String version = System.getProperty("fabric.version");
            System.err.println(ExtendedJoinTest.executeCommand((String)("admin:create --featureURL mvn:io.fabric8/fabric8-karaf/" + version + "/xml/features --feature fabric-git --feature fabric-agent --feature fabric-boot-commands child1")));
            System.err.println(ExtendedJoinTest.executeCommand((String)("admin:create --featureURL mvn:io.fabric8/fabric8-karaf/" + version + "/xml/features --feature fabric-git --feature fabric-agent --feature fabric-boot-commands child2")));
            try {
                int i;
                System.err.println(ExtendedJoinTest.executeCommand((String)"admin:start child1"));
                System.err.println(ExtendedJoinTest.executeCommand((String)"admin:start child2"));
                Provision.instanceStarted((BundleContext)this.bundleContext, Arrays.asList("child1", "child2"), (Long)PROVISION_TIMEOUT);
                System.err.println(ExtendedJoinTest.executeCommand((String)"admin:list"));
                String joinCommand = "fabric:join -f --zookeeper-password " + fabricService.getZookeeperPassword() + " " + fabricService.getZookeeperUrl();
                String response = "";
                for (i = 0; i < 10 && !response.contains("true"); ++i) {
                    response = ExtendedJoinTest.executeCommand((String)("ssh -l admin -P admin -p " + adminService.getInstance("child1").getSshPort() + " localhost " + WAIT_FOR_JOIN_SERVICE));
                    Thread.sleep(1000L);
                }
                response = "";
                for (i = 0; i < 10 && !response.contains("true"); ++i) {
                    response = ExtendedJoinTest.executeCommand((String)("ssh -l admin -P admin -p " + adminService.getInstance("child2").getSshPort() + " localhost " + WAIT_FOR_JOIN_SERVICE));
                    Thread.sleep(1000L);
                }
                System.err.println(ExtendedJoinTest.executeCommand((String)("ssh -l admin -P admin -p " + adminService.getInstance("child1").getSshPort() + " localhost " + joinCommand)));
                System.err.println(ExtendedJoinTest.executeCommand((String)("ssh -l admin -P admin -p " + adminService.getInstance("child2").getSshPort() + " localhost " + joinCommand)));
                Provision.containersExist((BundleContext)this.bundleContext, Arrays.asList("child1", "child2"), (Long)PROVISION_TIMEOUT);
                ContainerProxy child1 = ContainerProxy.wrap((Container)fabricService.getContainer("child1"), (ServiceProxy)fabricProxy);
                ContainerProxy child2 = ContainerProxy.wrap((Container)fabricService.getContainer("child2"), (ServiceProxy)fabricProxy);
                Provision.containersStatus(Arrays.asList(child1, child2), (String)"success", (Long)PROVISION_TIMEOUT);
                this.addToEnsemble(fabricService, new Container[]{child1, child2});
                System.err.println(ExtendedJoinTest.executeCommand((String)"fabric:container-list"));
                this.removeFromEnsemble(fabricService, new Container[]{child1, child2});
                System.err.println(ExtendedJoinTest.executeCommand((String)"fabric:container-list"));
            }
            finally {
                System.err.println(ExtendedJoinTest.executeCommand((String)"admin:stop child1"));
                System.err.println(ExtendedJoinTest.executeCommand((String)"admin:stop child2"));
            }
        }
        finally {
            fabricProxy.close();
        }
    }

    @Configuration
    public Option[] config() {
        return new Option[]{new DefaultCompositeOption(this.fabricDistributionConfiguration()), KarafDistributionOption.editConfigurationFilePut((String)"etc/system.properties", (String)"karaf.name", (String)"myroot"), KarafDistributionOption.editConfigurationFilePut((String)"etc/system.properties", (String)"fabric.version", (String)MavenUtils.getArtifactVersion((String)"io.fabric8", (String)"fabric8-karaf"))};
    }
}

