/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.itests.basic;

import io.fabric8.api.Container;
import io.fabric8.api.FabricService;
import io.fabric8.api.ServiceLocator;
import io.fabric8.api.ServiceProxy;
import io.fabric8.itests.paxexam.support.ContainerBuilder;
import io.fabric8.itests.paxexam.support.FabricTestSupport;
import io.fabric8.itests.paxexam.support.Provision;
import io.fabric8.itests.paxexam.support.WaitForConfigurationChange;
import io.fabric8.zookeeper.utils.ZooKeeperUtils;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.curator.framework.CuratorFramework;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.junit.Configuration;
import org.ops4j.pax.exam.junit.ExamReactorStrategy;
import org.ops4j.pax.exam.junit.JUnit4TestRunner;
import org.ops4j.pax.exam.options.DefaultCompositeOption;
import org.ops4j.pax.exam.spi.reactors.AllConfinedStagedReactorFactory;
import org.osgi.framework.BundleContext;

@RunWith(value=JUnit4TestRunner.class)
@ExamReactorStrategy(value={AllConfinedStagedReactorFactory.class})
public class ExtendedUpgradeAndRollbackTest
extends FabricTestSupport {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testContainerAfterVersionUpgradeAndDowngrade() throws Exception {
        System.out.println(ExtendedUpgradeAndRollbackTest.executeCommand((String)"fabric:create -n"));
        ServiceProxy fabricProxy = ServiceProxy.createServiceProxy((BundleContext)this.bundleContext, FabricService.class);
        try {
            FabricService fabricService = (FabricService)fabricProxy.getService();
            this.waitForFabricCommands();
            System.out.println(ExtendedUpgradeAndRollbackTest.executeCommand((String)"fabric:version-create --parent 1.0 1.1"));
            Set containers = ContainerBuilder.create((ServiceProxy)fabricProxy).withName("camel").withProfiles("feature-camel").assertProvisioningResult().build();
            try {
                String bundles;
                CountDownLatch latch = WaitForConfigurationChange.on((FabricService)fabricService);
                System.out.println(ExtendedUpgradeAndRollbackTest.executeCommand((String)"fabric:profile-edit --features camel-hazelcast feature-camel 1.1"));
                Assert.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
                System.out.println(ExtendedUpgradeAndRollbackTest.executeCommand((String)"fabric:container-upgrade --all 1.1"));
                Provision.provisioningSuccess((Collection)containers, (Long)PROVISION_TIMEOUT);
                System.out.println(ExtendedUpgradeAndRollbackTest.executeCommand((String)"fabric:container-list"));
                for (Container container : containers) {
                    Assert.assertEquals((String)"Container should have version 1.1", (Object)"1.1", (Object)container.getVersion().getId());
                    bundles = ExtendedUpgradeAndRollbackTest.executeCommand((String)("container-connect -u admin -p admin " + container.getId() + " osgi:list -s | grep camel-hazelcast"));
                    Assert.assertNotNull((Object)bundles);
                    System.out.println(bundles);
                    Assert.assertFalse((String)("Expected camel-hazelcast installed on container:" + container.getId() + "."), (boolean)bundles.isEmpty());
                }
                System.out.println(ExtendedUpgradeAndRollbackTest.executeCommand((String)"fabric:container-rollback --all 1.0"));
                Provision.provisioningSuccess((Collection)containers, (Long)PROVISION_TIMEOUT);
                System.out.println(ExtendedUpgradeAndRollbackTest.executeCommand((String)"fabric:container-list"));
                for (Container container : containers) {
                    Assert.assertEquals((String)"Container should have version 1.0", (Object)"1.0", (Object)container.getVersion().getId());
                    bundles = ExtendedUpgradeAndRollbackTest.executeCommand((String)("container-connect -u admin -p admin " + container.getId() + " osgi:list -s | grep camel-hazelcast"));
                    Assert.assertNotNull((Object)bundles);
                    System.out.println(bundles);
                    Assert.assertTrue((String)("Expected no camel-hazelcast installed on container:" + container.getId() + "."), (boolean)bundles.isEmpty());
                }
            }
            finally {
                ContainerBuilder.destroy((Set)containers);
            }
        }
        finally {
            fabricProxy.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testContainerAfterVersionDowngrade() throws Exception {
        System.out.println(ExtendedUpgradeAndRollbackTest.executeCommand((String)"fabric:create -n"));
        ServiceProxy fabricProxy = ServiceProxy.createServiceProxy((BundleContext)this.bundleContext, FabricService.class);
        try {
            this.waitForFabricCommands();
            System.out.println(ExtendedUpgradeAndRollbackTest.executeCommand((String)"fabric:version-create --parent 1.0 1.1"));
            System.out.println(ExtendedUpgradeAndRollbackTest.executeCommand((String)"fabric:container-upgrade --all 1.1"));
            Set containers = ContainerBuilder.create((ServiceProxy)fabricProxy).withName("camel").withProfiles("feature-camel").assertProvisioningResult().build();
            try {
                System.out.println(ExtendedUpgradeAndRollbackTest.executeCommand((String)"fabric:container-rollback --all 1.0"));
                Provision.provisioningSuccess((Collection)containers, (Long)PROVISION_TIMEOUT);
                for (Container container : containers) {
                    Assert.assertEquals((String)"Container should have version 1.0", (Object)"1.0", (Object)container.getVersion().getId());
                    Assert.assertNotNull((Object)ZooKeeperUtils.exists((CuratorFramework)((CuratorFramework)ServiceLocator.awaitService((BundleContext)this.bundleContext, CuratorFramework.class)), (String)("/fabric/configs/versions/1.0/containers/" + container.getId())));
                }
            }
            finally {
                ContainerBuilder.destroy((Set)containers);
            }
        }
        finally {
            fabricProxy.close();
        }
    }

    @Configuration
    public Option[] config() {
        return new Option[]{new DefaultCompositeOption(this.fabricDistributionConfiguration())};
    }
}

