/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.itests.basic;

import io.fabric8.api.Container;
import io.fabric8.api.FabricService;
import io.fabric8.api.Profile;
import io.fabric8.api.ServiceProxy;
import io.fabric8.itests.paxexam.support.ContainerBuilder;
import io.fabric8.itests.paxexam.support.ContainerCondition;
import io.fabric8.itests.paxexam.support.FabricTestSupport;
import io.fabric8.itests.paxexam.support.Provision;
import io.fabric8.zookeeper.ZkPath;
import io.fabric8.zookeeper.utils.ZooKeeperUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.curator.framework.CuratorFramework;
import org.apache.karaf.tooling.exam.options.KarafDistributionOption;
import org.fusesource.tooling.testing.pax.exam.karaf.FuseTestSupport;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.ops4j.pax.exam.MavenUtils;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.junit.Configuration;
import org.ops4j.pax.exam.junit.ExamReactorStrategy;
import org.ops4j.pax.exam.junit.JUnit4TestRunner;
import org.ops4j.pax.exam.options.DefaultCompositeOption;
import org.ops4j.pax.exam.spi.reactors.AllConfinedStagedReactorFactory;
import org.osgi.framework.BundleContext;

@RunWith(value=JUnit4TestRunner.class)
@ExamReactorStrategy(value={AllConfinedStagedReactorFactory.class})
public class FabricDosgiCamelTest
extends FabricTestSupport {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFeatureProvisioning() throws Exception {
        System.err.println(FabricDosgiCamelTest.executeCommand((String)"fabric:create -n root"));
        ServiceProxy fabricProxy = ServiceProxy.createServiceProxy((BundleContext)this.bundleContext, FabricService.class);
        try {
            FabricService fabricService = (FabricService)fabricProxy.getService();
            CuratorFramework curator = (CuratorFramework)fabricService.adapt(CuratorFramework.class);
            this.waitForFabricCommands();
            Set containers = ContainerBuilder.create((ServiceProxy)fabricProxy, (int)2).withName("dosgi").withProfiles("example-dosgi-camel").assertProvisioningResult().build();
            try {
                Profile p;
                ArrayList containerList = new ArrayList(containers);
                List dosgiProviderContainers = containerList.subList(0, containerList.size() / 2);
                List dosgiCamelContainers = containerList.subList(containerList.size() / 2, containerList.size());
                for (Container c : dosgiProviderContainers) {
                    ZooKeeperUtils.setData((CuratorFramework)curator, (String)ZkPath.CONTAINER_PROVISION_RESULT.getPath(new String[]{c.getId()}), (String)"changing profile");
                    p = c.getVersion().getProfile("example-dosgi-camel.provider");
                    c.setProfiles(new Profile[]{p});
                }
                for (Container c : dosgiCamelContainers) {
                    ZooKeeperUtils.setData((CuratorFramework)curator, (String)ZkPath.CONTAINER_PROVISION_RESULT.getPath(new String[]{c.getId()}), (String)"changing profile");
                    p = c.getVersion().getProfile("example-dosgi-camel.consumer");
                    c.setProfiles(new Profile[]{p});
                }
                Provision.provisioningSuccess(dosgiProviderContainers, (Long)PROVISION_TIMEOUT);
                Provision.provisioningSuccess(dosgiCamelContainers, (Long)PROVISION_TIMEOUT);
                Assert.assertTrue((boolean)Provision.waitForCondition(dosgiCamelContainers, (ContainerCondition)new ContainerCondition(){

                    public Boolean checkConditionOnContainer(Container c) {
                        String response = FuseTestSupport.executeCommand((String)("fabric:container-connect -u admin -p admin " + c.getId() + " log:display | grep \"Message from distributed service to\""));
                        System.err.println(FuseTestSupport.executeCommand((String)("fabric:container-connect -u admin -p admin " + c.getId() + " camel:route-info fabric-client")));
                        Assert.assertNotNull((Object)response);
                        System.err.println(response);
                        String[] lines = response.split("\n");
                        return lines.length >= 1;
                    }
                }, (Long)20000L));
            }
            finally {
                ContainerBuilder.destroy((Set)containers);
            }
        }
        finally {
            fabricProxy.close();
        }
    }

    @Configuration
    public Option[] config() {
        return new Option[]{new DefaultCompositeOption(this.fabricDistributionConfiguration()), KarafDistributionOption.editConfigurationFilePut((String)"etc/system.properties", (String)"fabric.version", (String)MavenUtils.asInProject().getVersion(GROUP_ID, ARTIFACT_ID))};
    }
}

