/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.itests.basic;

import io.fabric8.api.FabricService;
import io.fabric8.api.ServiceProxy;
import io.fabric8.itests.paxexam.support.ContainerBuilder;
import io.fabric8.itests.paxexam.support.FabricTestSupport;
import io.fabric8.itests.paxexam.support.Provision;
import io.fabric8.zookeeper.ZkPath;
import io.fabric8.zookeeper.utils.ZooKeeperUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.apache.curator.framework.CuratorFramework;
import org.apache.http.HttpEntity;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.FileEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.karaf.tooling.exam.options.KarafDistributionOption;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.junit.Configuration;
import org.ops4j.pax.exam.junit.ExamReactorStrategy;
import org.ops4j.pax.exam.junit.JUnit4TestRunner;
import org.ops4j.pax.exam.options.DefaultCompositeOption;
import org.ops4j.pax.exam.spi.reactors.AllConfinedStagedReactorFactory;
import org.osgi.framework.BundleContext;

@RunWith(value=JUnit4TestRunner.class)
@ExamReactorStrategy(value={AllConfinedStagedReactorFactory.class})
public class FabricMavenProxyTest
extends FabricTestSupport {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpload() throws Exception {
        String featureLocation = System.getProperty("feature.location");
        System.out.println("Testing with feature from:" + featureLocation);
        System.err.println(FabricMavenProxyTest.executeCommand((String)"fabric:create -n"));
        ServiceProxy fabricProxy = ServiceProxy.createServiceProxy((BundleContext)this.bundleContext, FabricService.class);
        try {
            Set containers = ContainerBuilder.create((ServiceProxy)fabricProxy, (int)2).withName("maven").withProfiles("fabric").assertProvisioningResult().build();
            try {
                ArrayList<String> uploadUrls = new ArrayList<String>();
                ServiceProxy curatorProxy = ServiceProxy.createServiceProxy((BundleContext)this.bundleContext, CuratorFramework.class);
                try {
                    CuratorFramework curator = (CuratorFramework)curatorProxy.getService();
                    List children = ZooKeeperUtils.getChildren((CuratorFramework)curator, (String)ZkPath.MAVEN_PROXY.getPath(new String[]{"upload"}));
                    for (String child : children) {
                        String uploadeUrl = ZooKeeperUtils.getSubstitutedPath((CuratorFramework)curator, (String)(ZkPath.MAVEN_PROXY.getPath(new String[]{"upload"}) + "/" + child));
                        uploadUrls.add(uploadeUrl);
                    }
                }
                finally {
                    curatorProxy.close();
                }
                Random random = new Random();
                int index = random.nextInt(uploadUrls.size());
                String targetUrl = (String)uploadUrls.get(index);
                String uploadUrl = targetUrl + "itest/itest/1.0/itest-1.0-features.xml";
                System.out.println("Using URI: " + uploadUrl);
                DefaultHttpClient client = new DefaultHttpClient();
                HttpPut put = new HttpPut(uploadUrl);
                client.getCredentialsProvider().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials("admin", "admin"));
                FileEntity entity = new FileEntity(new File(featureLocation), ContentType.TEXT_XML);
                put.setEntity((HttpEntity)entity);
                CloseableHttpResponse response = client.execute((HttpUriRequest)put);
                System.err.println("Response:" + response.getStatusLine());
                Assert.assertTrue((response.getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 202 ? 1 : 0) != 0);
                System.err.println(FabricMavenProxyTest.executeCommand((String)"fabric:profile-edit --repositories mvn:itest/itest/1.0/xml/features default"));
                System.err.println(FabricMavenProxyTest.executeCommand((String)"fabric:profile-edit --features example-cbr default"));
                Provision.containerStatus((Collection)containers, (Long)PROVISION_TIMEOUT);
            }
            finally {
                ContainerBuilder.destroy((Set)containers);
            }
        }
        finally {
            fabricProxy.close();
        }
    }

    @Configuration
    public Option[] config() {
        return new Option[]{new DefaultCompositeOption(this.fabricDistributionConfiguration()), FabricMavenProxyTest.mavenBundle((String)"org.apache.httpcomponents", (String)"httpcore-osgi").versionAsInProject(), FabricMavenProxyTest.mavenBundle((String)"org.apache.httpcomponents", (String)"httpclient-osgi").versionAsInProject(), FabricMavenProxyTest.mavenBundle((String)"io.fabric8", (String)"fabric-maven-proxy").versionAsInProject(), KarafDistributionOption.editConfigurationFilePut((String)"etc/system.properties", (String)"feature.location", (String)FabricMavenProxyTest.class.getResource("/test-features.xml").getFile()), KarafDistributionOption.debugConfiguration((String)"5005", (boolean)false)};
    }
}

