/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.itests.basic;

import io.fabric8.api.FabricRequirements;
import io.fabric8.api.FabricService;
import io.fabric8.api.ProfileRequirements;
import io.fabric8.api.ServiceProxy;
import io.fabric8.itests.paxexam.support.FabricTestSupport;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.junit.Configuration;
import org.ops4j.pax.exam.junit.ExamReactorStrategy;
import org.ops4j.pax.exam.junit.JUnit4TestRunner;
import org.ops4j.pax.exam.options.DefaultCompositeOption;
import org.ops4j.pax.exam.spi.reactors.AllConfinedStagedReactorFactory;
import org.osgi.framework.BundleContext;

@RunWith(value=JUnit4TestRunner.class)
@ExamReactorStrategy(value={AllConfinedStagedReactorFactory.class})
public class ProfileScalingTest
extends FabricTestSupport {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProfileScaling() throws Exception {
        System.err.println(ProfileScalingTest.executeCommand((String)"fabric:create -n"));
        ServiceProxy fabricProxy = ServiceProxy.createServiceProxy((BundleContext)this.bundleContext, FabricService.class);
        try {
            FabricService fabricService = (FabricService)fabricProxy.getService();
            this.waitForFabricCommands();
            String profile = "mq-amq";
            Integer expected = 1;
            boolean changed = fabricService.scaleProfile(profile, expected.intValue());
            this.assertProfileMinimumSize(fabricService, profile, expected);
            changed = fabricService.scaleProfile(profile, expected.intValue());
            this.assertProfileMinimumSize(fabricService, profile, expected);
            Assert.assertEquals((String)"should not have changed!", (Object)false, (Object)changed);
            changed = fabricService.scaleProfile(profile, 2);
            this.assertProfileMinimumSize(fabricService, profile, 2);
            changed = fabricService.scaleProfile(profile, -1);
            this.assertProfileMinimumSize(fabricService, profile, null);
        }
        finally {
            fabricProxy.close();
        }
    }

    protected void assertProfileMinimumSize(FabricService fabricService, String profile, Integer expected) throws IOException {
        try {
            Thread.sleep(2000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        FabricRequirements requirements = fabricService.getRequirements();
        ProfileRequirements profileRequirements = requirements.getOrCreateProfileRequirement(profile);
        Assert.assertNotNull((String)("Should have profile requirements for profile " + profile), (Object)profileRequirements);
        Assert.assertEquals((String)("profile " + profile + " minimum instances"), (Object)expected, (Object)profileRequirements.getMinimumInstances());
        System.out.println("Profile " + profile + " now has requirements " + profileRequirements);
    }

    @Configuration
    public Option[] config() {
        return new Option[]{new DefaultCompositeOption(this.fabricDistributionConfiguration())};
    }
}

