/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.itests.basic;

import io.fabric8.api.Container;
import io.fabric8.api.ContainerRegistration;
import io.fabric8.api.FabricService;
import io.fabric8.api.ServiceLocator;
import io.fabric8.api.ServiceProxy;
import io.fabric8.itests.paxexam.support.ContainerBuilder;
import io.fabric8.itests.paxexam.support.FabricTestSupport;
import io.fabric8.utils.BundleUtils;
import io.fabric8.zookeeper.ZkPath;
import io.fabric8.zookeeper.utils.ZooKeeperUtils;
import java.util.Set;
import org.apache.curator.framework.CuratorFramework;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.ops4j.pax.exam.CoreOptions;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.junit.Configuration;
import org.ops4j.pax.exam.junit.ExamReactorStrategy;
import org.ops4j.pax.exam.junit.JUnit4TestRunner;
import org.ops4j.pax.exam.options.DefaultCompositeOption;
import org.ops4j.pax.exam.options.UrlReference;
import org.ops4j.pax.exam.spi.reactors.AllConfinedStagedReactorFactory;
import org.osgi.framework.BundleContext;

@RunWith(value=JUnit4TestRunner.class)
@ExamReactorStrategy(value={AllConfinedStagedReactorFactory.class})
public class ResolverTest
extends FabricTestSupport {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRootContainerResolver() throws Exception {
        System.err.println(ResolverTest.executeCommand((String)"fabric:create -n"));
        ServiceProxy fabricProxy = ServiceProxy.createServiceProxy((BundleContext)this.bundleContext, FabricService.class);
        try {
            FabricService fabricService = (FabricService)fabricProxy.getService();
            Container current = fabricService.getCurrentContainer();
            ServiceLocator.awaitService((BundleContext)this.bundleContext, ContainerRegistration.class);
            Assert.assertEquals((Object)"localhostname", (Object)current.getResolver());
            String sshUrlWithLocalhostResolver = current.getSshUrl();
            this.waitForFabricCommands();
            System.err.println(ResolverTest.executeCommand((String)"fabric:container-resolver-set --container root localip"));
            Assert.assertEquals((Object)"localip", (Object)current.getResolver());
            String sshUrlWithLocalIpResolver = current.getSshUrl();
            System.out.println("SSH URL with " + sshUrlWithLocalhostResolver + " resolver: localhostname");
            System.out.println("SSH URL with " + sshUrlWithLocalIpResolver + " resolver: localip");
            Assert.assertNotSame((Object)sshUrlWithLocalhostResolver, (Object)sshUrlWithLocalIpResolver);
        }
        finally {
            fabricProxy.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateWithGlobalResolver() throws Exception {
        System.err.println(ResolverTest.executeCommand((String)"fabric:create -n -g manualip --manual-ip localhost -b localhost --clean"));
        ServiceLocator.awaitService((BundleContext)this.bundleContext, ContainerRegistration.class);
        ServiceProxy fabricProxy = ServiceProxy.createServiceProxy((BundleContext)this.bundleContext, FabricService.class);
        try {
            FabricService fabricService = (FabricService)fabricProxy.getService();
            Container current = fabricService.getCurrentContainer();
            Assert.assertEquals((Object)"manualip", (Object)current.getResolver());
        }
        finally {
            fabricProxy.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateWithGlobalAndLocalResolver() throws Exception {
        System.err.println(ResolverTest.executeCommand((String)"fabric:create -n -g manualip -r localhostname --manual-ip localhost --clean"));
        ServiceLocator.awaitService((BundleContext)this.bundleContext, ContainerRegistration.class);
        ServiceProxy fabricProxy = ServiceProxy.createServiceProxy((BundleContext)this.bundleContext, FabricService.class);
        try {
            FabricService fabricService = (FabricService)fabricProxy.getService();
            Container current = fabricService.getCurrentContainer();
            Assert.assertEquals((Object)"localhostname", (Object)current.getResolver());
        }
        finally {
            fabricProxy.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testChildContainerResolver() throws Exception {
        System.err.println(ResolverTest.executeCommand((String)"fabric:create -n"));
        ServiceLocator.awaitService((BundleContext)this.bundleContext, ContainerRegistration.class);
        ServiceProxy fabricProxy = ServiceProxy.createServiceProxy((BundleContext)this.bundleContext, FabricService.class);
        try {
            FabricService fabricService = (FabricService)fabricProxy.getService();
            CuratorFramework curator = (CuratorFramework)fabricService.adapt(CuratorFramework.class);
            Set containers = ContainerBuilder.create((ServiceProxy)fabricProxy, (int)1, (int)1).withName("child").withProfiles("default").assertProvisioningResult().build();
            try {
                Container child = (Container)containers.iterator().next();
                Assert.assertEquals((Object)"localhostname", (Object)ZooKeeperUtils.getSubstitutedPath((CuratorFramework)curator, (String)ZkPath.CONTAINER_RESOLVER.getPath(new String[]{child.getId()})));
                String sshUrlWithLocalhostResolver = child.getSshUrl();
                ResolverTest.executeCommand((String)("fabric:container-resolver-set --container " + child.getId() + " localip"));
                Assert.assertEquals((Object)"localip", (Object)ZooKeeperUtils.getSubstitutedPath((CuratorFramework)curator, (String)ZkPath.CONTAINER_RESOLVER.getPath(new String[]{child.getId()})));
                String sshUrlWithLocalIpResolver = child.getSshUrl();
                System.out.println("SSH URL with " + sshUrlWithLocalhostResolver + " resolver: localhostname");
                System.out.println("SSH URL with " + sshUrlWithLocalIpResolver + " resolver: localip");
                Assert.assertNotSame((Object)sshUrlWithLocalhostResolver, (Object)sshUrlWithLocalIpResolver);
                ZooKeeperUtils.setData((CuratorFramework)curator, (String)ZkPath.CONTAINER_PUBLIC_IP.getPath(new String[]{child.getId()}), (String)"my.public.ip.address");
                ResolverTest.executeCommand((String)("fabric:container-resolver-set --container " + child.getId() + " publicip"));
                Assert.assertEquals((Object)"publicip", (Object)ZooKeeperUtils.getSubstitutedPath((CuratorFramework)curator, (String)ZkPath.CONTAINER_RESOLVER.getPath(new String[]{child.getId()})));
                String sshUrlWithPublicIpResolver = child.getSshUrl();
                System.out.println("SSH URL with " + sshUrlWithPublicIpResolver + " resolver: publicip");
                Assert.assertNotNull((Object)sshUrlWithPublicIpResolver);
                Assert.assertTrue((boolean)sshUrlWithPublicIpResolver.startsWith("my.public.ip.address"));
                ZooKeeperUtils.setData((CuratorFramework)curator, (String)ZkPath.CONTAINER_MANUAL_IP.getPath(new String[]{child.getId()}), (String)"my.manual.ip.address");
                ResolverTest.executeCommand((String)("fabric:container-resolver-set --container " + child.getId() + " manualip"));
                Assert.assertEquals((Object)"manualip", (Object)ZooKeeperUtils.getSubstitutedPath((CuratorFramework)curator, (String)ZkPath.CONTAINER_RESOLVER.getPath(new String[]{child.getId()})));
                String sshUrlWithManualIpResolver = child.getSshUrl();
                System.out.println("SSH URL with " + sshUrlWithManualIpResolver + " resolver: manualip");
                Assert.assertNotNull((Object)sshUrlWithManualIpResolver);
                Assert.assertTrue((boolean)sshUrlWithManualIpResolver.startsWith("my.manual.ip.address"));
            }
            finally {
                ContainerBuilder.destroy((Set)containers);
            }
        }
        finally {
            fabricProxy.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testResolverInheritanceOnChild() throws Exception {
        System.err.println(ResolverTest.executeCommand((String)"fabric:create -n -g localip -r manualip --manual-ip localhost -b localhost"));
        ServiceProxy fabricProxy = ServiceProxy.createServiceProxy((BundleContext)this.bundleContext, FabricService.class);
        try {
            FabricService fabricService = (FabricService)fabricProxy.getService();
            CuratorFramework curator = (CuratorFramework)fabricService.adapt(CuratorFramework.class);
            Set containers = ContainerBuilder.create((ServiceProxy)fabricProxy, (int)1, (int)1).withName("child").withProfiles("default").assertProvisioningResult().build();
            try {
                Container child = (Container)containers.iterator().next();
                Assert.assertEquals((Object)"manualip", (Object)ZooKeeperUtils.getSubstitutedPath((CuratorFramework)curator, (String)ZkPath.CONTAINER_RESOLVER.getPath(new String[]{child.getId()})));
                Assert.assertEquals((Object)"manualip", (Object)fabricService.getCurrentContainer().getResolver());
                this.waitForFabricCommands();
                new BundleUtils(this.bundleContext).findAndStopBundle("io.fabric8.fabric-configadmin");
                System.err.println(ResolverTest.executeCommand((String)"fabric:container-resolver-set --container root localip"));
                Assert.assertEquals((Object)"localip", (Object)ZooKeeperUtils.getSubstitutedPath((CuratorFramework)curator, (String)ZkPath.CONTAINER_RESOLVER.getPath(new String[]{child.getId()})));
            }
            finally {
                ContainerBuilder.destroy((Set)containers);
            }
        }
        finally {
            fabricProxy.close();
        }
    }

    @Configuration
    public Option[] config() {
        return new Option[]{new DefaultCompositeOption(this.fabricDistributionConfiguration()), CoreOptions.wrappedBundle((UrlReference)ResolverTest.mavenBundle((String)"io.fabric8", (String)"fabric-utils"))};
    }
}

