/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.itests.basic.camel;

import io.fabric8.api.FabricService;
import io.fabric8.api.ServiceProxy;
import io.fabric8.itests.paxexam.support.ContainerBuilder;
import io.fabric8.itests.paxexam.support.FabricFeaturesTest;
import java.util.Set;
import org.apache.curator.framework.CuratorFramework;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.junit.Configuration;
import org.ops4j.pax.exam.junit.ExamReactorStrategy;
import org.ops4j.pax.exam.junit.JUnit4TestRunner;
import org.ops4j.pax.exam.spi.reactors.AllConfinedStagedReactorFactory;
import org.osgi.framework.BundleContext;

@RunWith(value=JUnit4TestRunner.class)
@ExamReactorStrategy(value={AllConfinedStagedReactorFactory.class})
public class CamelProfileTest
extends FabricFeaturesTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFeatures() throws Exception {
        System.err.println(CamelProfileTest.executeCommand((String)"fabric:create -n"));
        ServiceProxy fabricProxy = ServiceProxy.createServiceProxy((BundleContext)this.bundleContext, FabricService.class);
        try {
            FabricService fabricService = (FabricService)fabricProxy.getService();
            Set containers = ContainerBuilder.create((ServiceProxy)fabricProxy).withName("feature-camel").withProfiles("feature-camel").assertProvisioningResult().build();
            try {
                CuratorFramework curator = (CuratorFramework)fabricService.adapt(CuratorFramework.class);
                this.assertProvisionedFeature(fabricService, curator, containers, "camel-http", "feature-camel", "camel-http");
                this.assertProvisionedFeature(fabricService, curator, containers, "camel-jetty", "feature-camel", "camel-jetty");
                this.assertProvisionedFeature(fabricService, curator, containers, "camel-jms", "feature-camel", "camel-jms");
                this.assertProvisionedFeature(fabricService, curator, containers, "camel-ftp", "feature-camel", "camel-ftp");
                this.assertProvisionedFeature(fabricService, curator, containers, "camel-quartz", "feature-camel", "camel-quartz");
            }
            finally {
                ContainerBuilder.destroy((Set)containers);
            }
        }
        finally {
            fabricProxy.close();
        }
    }

    @Configuration
    public Option[] config() {
        return this.fabricDistributionConfiguration();
    }
}

