/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.itests.basic.cloud;

import com.google.common.base.Predicate;
import io.fabric8.api.ServiceLocator;
import io.fabric8.itests.paxexam.support.FabricTestSupport;
import java.io.IOException;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import junit.framework.Assert;
import org.apache.karaf.tooling.exam.options.KarafDistributionOption;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.domain.ComputeMetadata;
import org.jclouds.compute.domain.NodeMetadata;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.ops4j.pax.exam.CoreOptions;
import org.ops4j.pax.exam.MavenUtils;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.junit.Configuration;
import org.ops4j.pax.exam.junit.ExamReactorStrategy;
import org.ops4j.pax.exam.junit.JUnit4TestRunner;
import org.ops4j.pax.exam.options.DefaultCompositeOption;
import org.ops4j.pax.exam.spi.reactors.AllConfinedStagedReactorFactory;
import org.osgi.framework.BundleContext;

@RunWith(value=JUnit4TestRunner.class)
@ExamReactorStrategy(value={AllConfinedStagedReactorFactory.class})
public class FabricAwsContainerTest
extends FabricTestSupport {
    private String identity;
    private String credential;
    private String image;
    private String location;
    private String user;
    private String group = "fabricitests";

    public boolean isReady() {
        return this.identity != null && this.credential != null && this.image != null & this.user != null && !this.identity.isEmpty() && !this.credential.isEmpty() && !this.image.isEmpty() && !this.user.isEmpty();
    }

    @Before
    public void setUp() {
        this.identity = System.getProperty("fabricitest.aws.identity");
        this.credential = System.getProperty("fabricitest.aws.credential");
        this.image = System.getProperty("fabricitest.aws.image");
        this.location = System.getProperty("fabricitest.aws.location");
        this.user = System.getProperty("fabricitest.aws.user");
    }

    @After
    public void tearDown() {
        if (this.isReady()) {
            System.err.println(FabricAwsContainerTest.executeCommand((String)("group-destroy " + this.group), (long)30000L, (boolean)false));
        }
    }

    @Test
    public void testAwsAgentCreation() throws InterruptedException, IOException {
        if (!this.isReady()) {
            System.err.println("Amazon is not setup correctly. This test will not run.");
            System.err.println("To properly run this test, you need to setup with maven the following properties:");
            System.err.println("fabricitest.aws.identity \t The aws access id");
            System.err.println("fabricitest.aws.credential \t The aws access key");
            System.err.println("fabricitest.aws.image  \t The aws (java ready) image");
            System.err.println("fabricitest.aws.user  \t The user under which the agent will run");
            return;
        }
        System.err.println(FabricAwsContainerTest.executeCommand((String)"features:install jclouds-aws-ec2 fabric-jclouds jclouds-commands"));
        FabricAwsContainerTest.executeCommand((String)("fabric:cloud-service-add --provider aws-ec2 --identity " + this.identity + " --credential " + this.credential));
        ComputeService computeService = (ComputeService)ServiceLocator.awaitService((BundleContext)this.bundleContext, ComputeService.class, (long)3L, (TimeUnit)TimeUnit.MINUTES);
        System.err.println(FabricAwsContainerTest.executeCommand((String)"fabric:cloud-service-list"));
        System.err.println(FabricAwsContainerTest.executeCommand((String)String.format("fabric:container-create-cloud --name aws-ec2 --locationId %s --imageId %s --group %s --ensemble-server ensemble1", this.location, this.image, this.group), (long)600000L, (boolean)false));
        String publicIp = this.getNodePublicIp(computeService);
        Assert.assertNotNull((Object)publicIp);
        Thread.sleep(DEFAULT_TIMEOUT);
        System.err.println(FabricAwsContainerTest.executeCommand((String)("fabric:join -n " + publicIp + ":2181"), (long)600000L, (boolean)false));
        String agentList = FabricAwsContainerTest.executeCommand((String)"fabric:container-list");
        System.err.println(agentList);
        Assert.assertTrue((agentList.contains("root") && agentList.contains("ensemble1") ? 1 : 0) != 0);
    }

    private String getNodePublicIp(ComputeService computeService) {
        Iterator i$ = computeService.listNodesDetailsMatching((Predicate)new Predicate<ComputeMetadata>(){

            public boolean apply(ComputeMetadata metadata) {
                NodeMetadata nodeMetadata = (NodeMetadata)metadata;
                return nodeMetadata.getGroup().equals(FabricAwsContainerTest.this.group) && ((NodeMetadata.Status)nodeMetadata.getStatus()).equals((Object)NodeMetadata.Status.RUNNING);
            }
        }).iterator();
        if (i$.hasNext()) {
            ComputeMetadata computeMetadata = (ComputeMetadata)i$.next();
            NodeMetadata nodeMetadata = (NodeMetadata)computeMetadata;
            return nodeMetadata.getPublicAddresses().toArray(new String[0])[0];
        }
        return null;
    }

    @Configuration
    public Option[] config() {
        return new Option[]{new DefaultCompositeOption(this.fabricDistributionConfiguration()), FabricAwsContainerTest.copySystemProperty((String)"fabricitest.aws.identity"), FabricAwsContainerTest.copySystemProperty((String)"fabricitest.aws.credential"), FabricAwsContainerTest.copySystemProperty((String)"fabricitest.aws.image"), FabricAwsContainerTest.copySystemProperty((String)"fabricitest.aws.location"), FabricAwsContainerTest.copySystemProperty((String)"fabricitest.aws.user"), KarafDistributionOption.editConfigurationFilePut((String)"etc/system.properties", (String)"fabric.version", (String)MavenUtils.getArtifactVersion((String)"io.fabric8", (String)"fabric8-karaf")), KarafDistributionOption.editConfigurationFileExtend((String)"etc/config.properties", (String)"org.osgi.framework.executionenvironment", (String)"JavaSE-1.7,JavaSE-1.6,JavaSE-1.5"), (Option)CoreOptions.scanFeatures((String)"jclouds", (String[])new String[]{"jclouds-compute"}).start()};
    }
}

