/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.itests.basic.examples;

import io.fabric8.api.Container;
import io.fabric8.api.FabricService;
import io.fabric8.api.Profile;
import io.fabric8.api.ServiceProxy;
import io.fabric8.itests.paxexam.support.ContainerBuilder;
import io.fabric8.itests.paxexam.support.ContainerCondition;
import io.fabric8.itests.paxexam.support.FabricTestSupport;
import io.fabric8.itests.paxexam.support.Provision;
import io.fabric8.zookeeper.utils.ZooKeeperUtils;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Set;
import org.apache.curator.framework.CuratorFramework;
import org.apache.karaf.tooling.exam.options.KarafDistributionOption;
import org.fusesource.jansi.AnsiString;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.ops4j.pax.exam.MavenUtils;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.junit.Configuration;
import org.ops4j.pax.exam.junit.ExamReactorStrategy;
import org.ops4j.pax.exam.junit.JUnit4TestRunner;
import org.ops4j.pax.exam.options.DefaultCompositeOption;
import org.ops4j.pax.exam.spi.reactors.AllConfinedStagedReactorFactory;
import org.osgi.framework.BundleContext;

@RunWith(value=JUnit4TestRunner.class)
@ExamReactorStrategy(value={AllConfinedStagedReactorFactory.class})
public class ExampleCamelClusterTest
extends FabricTestSupport {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRegistryEntries() throws Exception {
        System.err.println(ExampleCamelClusterTest.executeCommand((String)"fabric:create -n root"));
        ServiceProxy fabricProxy = ServiceProxy.createServiceProxy((BundleContext)this.bundleContext, FabricService.class);
        try {
            FabricService fabricService = (FabricService)fabricProxy.getService();
            CuratorFramework curator = (CuratorFramework)fabricService.adapt(CuratorFramework.class);
            Set containers = ContainerBuilder.create((ServiceProxy)fabricProxy, (int)3).withName("fabric-camel").withProfiles("feature-camel").assertProvisioningResult().build();
            try {
                LinkedList containerList = new LinkedList(containers);
                Container client = (Container)containerList.removeLast();
                LinkedList servers = new LinkedList(containerList);
                for (Container c : servers) {
                    Profile p = c.getVersion().getProfile("example-camel-cluster.server");
                    c.setProfiles(new Profile[]{p});
                }
                Provision.provisioningSuccess(servers, (Long)PROVISION_TIMEOUT);
                Profile p = client.getVersion().getProfile("example-camel-cluster.client");
                client.setProfiles(new Profile[]{p});
                Provision.provisioningSuccess(Arrays.asList(client), (Long)PROVISION_TIMEOUT);
                System.err.println(ExampleCamelClusterTest.executeCommand((String)"fabric:container-list"));
                System.err.println(ExampleCamelClusterTest.executeCommand((String)"fabric:profile-display --overlay fabric-camel-server"));
                Assert.assertNotNull((Object)ZooKeeperUtils.exists((CuratorFramework)curator, (String)"/fabric/registry/camel/endpoints"));
                Assert.assertEquals((long)1L, (long)ZooKeeperUtils.getChildren((CuratorFramework)curator, (String)"/fabric/registry/camel/endpoints").size());
                Assert.assertTrue((boolean)Provision.waitForCondition(Arrays.asList(client), (ContainerCondition)new ContainerCondition(){

                    public Boolean checkConditionOnContainer(Container c) {
                        return ExampleCamelClusterTest.this.getCompletedExchangesCount(c) > 0;
                    }
                }, (Long)60000L));
                Container lastActiveServerContainer = (Container)servers.removeLast();
                for (Container c : servers) {
                    try {
                        c.destroy(true);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    final int completed = this.getCompletedExchangesCount(client);
                    Assert.assertTrue((boolean)Provision.waitForCondition(Arrays.asList(client), (ContainerCondition)new ContainerCondition(){

                        public Boolean checkConditionOnContainer(Container c) {
                            return ExampleCamelClusterTest.this.getCompletedExchangesCount(c) > completed + 3;
                        }
                    }, (Long)60000L));
                }
                System.err.println(new AnsiString((CharSequence)ExampleCamelClusterTest.executeCommand((String)("fabric:container-connect -u admin -p admin " + client.getId() + " camel:route-info fabric-client"))).getPlain().toString());
            }
            finally {
                ContainerBuilder.destroy((Set)containers);
            }
        }
        finally {
            fabricProxy.close();
        }
    }

    private int getCompletedExchangesCount(Container c) {
        String response = new AnsiString((CharSequence)ExampleCamelClusterTest.executeCommand((String)("fabric:container-connect -u admin -p admin " + c.getId() + " camel:route-info fabric-client | grep \"Exchanges Completed\""))).getPlain().toString();
        System.err.println(response);
        return Integer.parseInt(response.replaceAll("[^0-9]", ""));
    }

    @Configuration
    public Option[] config() {
        return new Option[]{new DefaultCompositeOption(this.fabricDistributionConfiguration()), KarafDistributionOption.editConfigurationFilePut((String)"etc/system.properties", (String)"fabric.version", (String)MavenUtils.asInProject().getVersion(GROUP_ID, ARTIFACT_ID))};
    }
}

