/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.itests.basic.examples;

import io.fabric8.api.Container;
import io.fabric8.api.FabricService;
import io.fabric8.api.ServiceProxy;
import io.fabric8.itests.paxexam.support.ContainerBuilder;
import io.fabric8.itests.paxexam.support.ContainerCondition;
import io.fabric8.itests.paxexam.support.FabricTestSupport;
import io.fabric8.itests.paxexam.support.Provision;
import io.fabric8.zookeeper.ZkPath;
import io.fabric8.zookeeper.utils.ZooKeeperUtils;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Set;
import org.apache.curator.framework.CuratorFramework;
import org.fusesource.tooling.testing.pax.exam.karaf.FuseTestSupport;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.junit.Configuration;
import org.ops4j.pax.exam.junit.ExamReactorStrategy;
import org.ops4j.pax.exam.junit.JUnit4TestRunner;
import org.ops4j.pax.exam.spi.reactors.AllConfinedStagedReactorFactory;
import org.osgi.framework.BundleContext;

@RunWith(value=JUnit4TestRunner.class)
@ExamReactorStrategy(value={AllConfinedStagedReactorFactory.class})
public class ExampleMQProfileTest
extends FabricTestSupport {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExample() throws Exception {
        System.err.println(ExampleMQProfileTest.executeCommand((String)"fabric:create -n"));
        ServiceProxy fabricProxy = ServiceProxy.createServiceProxy((BundleContext)this.bundleContext, FabricService.class);
        try {
            FabricService fabricService = (FabricService)fabricProxy.getService();
            CuratorFramework curator = (CuratorFramework)fabricService.adapt(CuratorFramework.class);
            Set containers = ContainerBuilder.create((ServiceProxy)fabricProxy, (int)2).withName("cnt").withProfiles("default").assertProvisioningResult().build();
            try {
                LinkedList containerList = new LinkedList(containers);
                Container broker = (Container)containerList.removeLast();
                ZooKeeperUtils.setData((CuratorFramework)curator, (String)ZkPath.CONTAINER_PROVISION_RESULT.getPath(new String[]{broker.getId()}), (String)"changing");
                System.err.println(ExampleMQProfileTest.executeCommand((String)("fabric:container-change-profile " + broker.getId() + " mq-default")));
                Provision.provisioningSuccess(Arrays.asList(broker), (Long)PROVISION_TIMEOUT);
                System.err.println(ExampleMQProfileTest.executeCommand((String)"fabric:cluster-list"));
                for (Container c : containerList) {
                    ZooKeeperUtils.setData((CuratorFramework)curator, (String)ZkPath.CONTAINER_PROVISION_RESULT.getPath(new String[]{c.getId()}), (String)"changing");
                    System.err.println(ExampleMQProfileTest.executeCommand((String)("fabric:container-change-profile " + c.getId() + " example-mq")));
                }
                Provision.provisioningSuccess(containerList, (Long)PROVISION_TIMEOUT);
                System.err.println(ExampleMQProfileTest.executeCommand((String)"fabric:cluster-list"));
                Assert.assertTrue((boolean)Provision.waitForCondition(Arrays.asList(broker), (ContainerCondition)new ContainerCondition(){

                    public Boolean checkConditionOnContainer(Container c) {
                        System.err.println(FuseTestSupport.executeCommand((String)("fabric:container-connect -u admin -p admin " + c.getId() + " activemq:bstat")));
                        String output = FuseTestSupport.executeCommand((String)("fabric:container-connect -u admin -p admin " + c.getId() + " activemq:query -QQueue=FABRIC.DEMO"));
                        return output.contains("DequeueCount = ") && !output.contains("DequeueCount = 0");
                    }
                }, (Long)10000L));
            }
            finally {
                ContainerBuilder.destroy((Set)containers);
            }
        }
        finally {
            fabricProxy.close();
        }
    }

    @Configuration
    public Option[] config() {
        return this.fabricDistributionConfiguration();
    }
}

