/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.itests.basic.git;

import io.fabric8.api.FabricService;
import io.fabric8.api.ServiceProxy;
import io.fabric8.itests.basic.git.FabricGitTestSupport;
import io.fabric8.itests.basic.git.GitUtils;
import java.io.File;
import javax.inject.Inject;
import org.apache.curator.framework.CuratorFramework;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.ops4j.pax.exam.CoreOptions;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.junit.Configuration;
import org.ops4j.pax.exam.junit.ExamReactorStrategy;
import org.ops4j.pax.exam.junit.JUnit4TestRunner;
import org.ops4j.pax.exam.options.DefaultCompositeOption;
import org.ops4j.pax.exam.options.UrlReference;
import org.ops4j.pax.exam.spi.reactors.AllConfinedStagedReactorFactory;
import org.osgi.framework.BundleContext;

@RunWith(value=JUnit4TestRunner.class)
@ExamReactorStrategy(value={AllConfinedStagedReactorFactory.class})
public class ExternalGitTest
extends FabricGitTestSupport {
    File testrepo = new File("testRepo");
    @Inject
    BundleContext bundleContext;

    @Before
    public void setUp() throws InterruptedException {
        this.testrepo.mkdirs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateProfilesMixedWithVersion() throws Exception {
        String testZkProfilebase = "zkprofile";
        String testGitProfilebase = "gitprofile";
        System.err.println(ExternalGitTest.executeCommand((String)"fabric:create -n"));
        ServiceProxy fabricProxy = ServiceProxy.createServiceProxy((BundleContext)this.bundleContext, FabricService.class);
        try {
            FabricService fabricService = (FabricService)fabricProxy.getService();
            CuratorFramework curator = (CuratorFramework)fabricService.adapt(CuratorFramework.class);
            String gitRepoUrl = GitUtils.getMasterUrl(this.bundleContext, curator);
            Assert.assertNotNull((Object)gitRepoUrl);
            GitUtils.waitForBranchUpdate(curator, "1.0");
            ((CloneCommand)Git.cloneRepository().setURI(gitRepoUrl).setCloneAllBranches(true).setDirectory(this.testrepo).setCredentialsProvider(this.getCredentialsProvider())).call();
            Git git = Git.open((File)this.testrepo);
            GitUtils.configureBranch(git, "origin", gitRepoUrl, "1.0");
            git.fetch().setCredentialsProvider(this.getCredentialsProvider());
            GitUtils.checkoutBranch(git, "origin", "1.0");
            Assert.assertTrue((boolean)new File(this.testrepo, "fabric/profiles/default.profile").exists());
            for (int v = 0; v < 2; ++v) {
                for (int i = 1; i < 2; ++i) {
                    String gitProfile = testGitProfilebase + v + "p" + i;
                    String zkProfile = testZkProfilebase + v + "p" + i;
                    this.createAndTestProfileInGit(fabricService, curator, git, "1." + v, gitProfile);
                    this.createAndTestProfileInDataStore(fabricService, curator, git, "1." + v, zkProfile);
                }
            }
        }
        finally {
            fabricProxy.close();
        }
    }

    @Configuration
    public Option[] config() {
        return new Option[]{new DefaultCompositeOption(this.fabricDistributionConfiguration()), CoreOptions.wrappedBundle((UrlReference)ExternalGitTest.mavenBundle((String)"io.fabric8", (String)"fabric-utils"))};
    }
}

