/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.itests.basic.git;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import io.fabric8.api.FabricService;
import io.fabric8.api.Version;
import io.fabric8.itests.basic.git.GitUtils;
import io.fabric8.itests.paxexam.support.FabricTestSupport;
import io.fabric8.utils.Files;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import org.apache.curator.framework.CuratorFramework;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.PullResult;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.junit.Assert;

public class FabricGitTestSupport
extends FabricTestSupport {
    private final CredentialsProvider credentialsProvider = new UsernamePasswordCredentialsProvider("admin", "admin");

    protected CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    protected void createAndTestProfileInGit(FabricService fabricService, CuratorFramework curator, Git git, String version, String profile) throws Exception {
        System.err.println("Create test profile:" + profile + " in git.");
        GitUtils.checkoutBranch(git, "origin", version);
        String relativeProfileDir = "fabric/profiles/" + profile + ".profile";
        File testProfileDir = new File(git.getRepository().getWorkTree(), relativeProfileDir);
        testProfileDir.mkdirs();
        File testProfileConfig = new File(testProfileDir, "io.fabric8.agent.properties");
        testProfileConfig.createNewFile();
        Files.writeToFile((File)testProfileConfig, (String)"", (Charset)Charset.defaultCharset());
        git.add().addFilepattern(relativeProfileDir).call();
        git.commit().setAll(true).setMessage("Create " + profile).call();
        PullResult pullResult = ((PullCommand)git.pull().setCredentialsProvider(this.getCredentialsProvider())).setRebase(true).call();
        ((PushCommand)git.push().setCredentialsProvider(this.getCredentialsProvider())).setPushAll().setRemote("origin").call();
        GitUtils.waitForBranchUpdate(curator, version);
        for (int i = 0; i < 5; ++i) {
            if (fabricService.getDataStore().hasProfile(version, profile)) {
                return;
            }
            Thread.sleep(1000L);
        }
        Assert.fail((String)("Expected to find profile " + profile + " in version " + version));
    }

    protected void createAndTestProfileInDataStore(FabricService fabricService, CuratorFramework curator, Git git, String version, String profile) throws Exception {
        System.err.println("Create test profile:" + profile + " in datastore.");
        List versions = Lists.transform(Arrays.asList(fabricService.getVersions()), (Function)new Function<Version, String>(){

            public String apply(Version version) {
                return version.getId();
            }
        });
        if (!versions.contains(version)) {
            fabricService.createVersion(version);
        }
        fabricService.getDataStore().createProfile(version, profile);
        GitUtils.waitForBranchUpdate(curator, version);
        GitUtils.checkoutBranch(git, "origin", version);
        PullResult pullResult = ((PullCommand)git.pull().setCredentialsProvider(this.getCredentialsProvider())).setRebase(true).call();
        Assert.assertTrue((boolean)pullResult.isSuccessful());
        String relativeProfileDir = "fabric/profiles/" + profile + ".profile";
        File testProfileDir = new File(git.getRepository().getWorkTree(), relativeProfileDir);
        Assert.assertTrue((boolean)testProfileDir.exists());
        File testProfileConfig = new File(testProfileDir, "io.fabric8.agent.properties");
        Assert.assertTrue((boolean)testProfileConfig.exists());
    }
}

