/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.itests.basic.git;

import com.google.common.base.Objects;
import io.fabric8.api.ContainerRegistration;
import io.fabric8.api.ServiceLocator;
import io.fabric8.git.GitNode;
import io.fabric8.groups.Group;
import io.fabric8.groups.GroupListener;
import io.fabric8.groups.internal.ZooKeeperGroup;
import io.fabric8.zookeeper.ZkPath;
import io.fabric8.zookeeper.utils.ZooKeeperUtils;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.osgi.framework.BundleContext;

public class GitUtils {
    public static final CredentialsProvider DEFAULT_CREDENTIALS_PROVIDER = new UsernamePasswordCredentialsProvider("admin", "admin");

    public static String getMasterUrl(BundleContext bundleContext, CuratorFramework curator) throws InterruptedException, URISyntaxException {
        ServiceLocator.awaitService((BundleContext)bundleContext, ContainerRegistration.class);
        ZooKeeperGroup group = new ZooKeeperGroup(curator, ZkPath.GIT.getPath(new String[0]), GitNode.class);
        final CountDownLatch latch = new CountDownLatch(1);
        group.add((GroupListener)new GroupListener<GitNode>(){

            public void groupEvent(Group<GitNode> group, GroupListener.GroupEvent event) {
                if (group.master() != null && ((GitNode)group.master()).getUrl() != null) {
                    latch.countDown();
                }
            }
        });
        group.start();
        latch.await(10L, TimeUnit.SECONDS);
        return ZooKeeperUtils.getSubstitutedData((CuratorFramework)curator, (String)((GitNode)group.master()).getUrl());
    }

    public static void waitForBranchUpdate(CuratorFramework curator, String branch) throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        Watcher watcher = new Watcher(){

            public void process(WatchedEvent watchedEvent) {
                latch.countDown();
            }
        };
        for (int i = 0; ((BackgroundPathable)curator.checkExists().usingWatcher(watcher)).forPath(ZkPath.CONFIG_VERSION.getPath(new String[]{branch})) == null && i < 3; ++i) {
            Thread.sleep(1000L);
        }
        latch.await(10L, TimeUnit.SECONDS);
    }

    public static void configureBranch(Git git, String remote, String remoteUrl, String branch) {
        Repository repository;
        if (git != null && remoteUrl != null && !remoteUrl.isEmpty() && (repository = git.getRepository()) != null) {
            StoredConfig config = repository.getConfig();
            config.setString("remote", remote, "url", remoteUrl);
            config.setString("remote", remote, "fetch", "+refs/heads/*:refs/remotes/" + branch + "/*");
            config.setString("branch", branch, "merge", "refs/heads/" + branch);
            config.setString("branch", branch, "remote", "origin");
            try {
                config.save();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    public static String currentBranch(Git git) {
        try {
            return git.getRepository().getBranch();
        }
        catch (IOException e) {
            return null;
        }
    }

    public static void checkoutBranch(Git git, String remote, String branch) throws GitAPIException {
        GitUtils.checkoutBranch(git, DEFAULT_CREDENTIALS_PROVIDER, remote, branch);
    }

    public static void checkoutBranch(Git git, CredentialsProvider credentialsProvider, String remote, String branch) throws GitAPIException {
        String current = GitUtils.currentBranch(git);
        if (Objects.equal((Object)current, (Object)branch)) {
            return;
        }
        boolean localExists = GitUtils.localBranchExists(git, branch);
        boolean remoteExists = GitUtils.remoteBranchExists(git, remote, branch);
        if (localExists) {
            git.checkout().setName(branch).call();
        } else if (remoteExists) {
            git.checkout().setName(branch).setCreateBranch(true).setForce(true).setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.TRACK).setStartPoint(remote + "/" + branch).call();
        } else {
            git.branchCreate().setName(branch).setForce(true).call();
            git.checkout().setName(branch).call();
            ((PushCommand)git.push().setCredentialsProvider(credentialsProvider)).setRemote(remote).setRefSpecs(new RefSpec[]{new RefSpec(branch)}).setForce(true).call();
        }
        GitUtils.configureBranch(git, remote, GitUtils.getRemote(git, remote), branch);
    }

    public static String getRemote(Git git, String remote) throws GitAPIException {
        StoredConfig config = git.getRepository().getConfig();
        return config.getString("remote", remote, "url");
    }

    public static boolean localBranchExists(Git git, String branch) throws GitAPIException {
        List list = git.branchList().call();
        String fullName = "refs/heads/" + branch;
        boolean exists = false;
        for (Ref ref : list) {
            String name = ref.getName();
            if (!Objects.equal((Object)name, (Object)fullName)) continue;
            exists = true;
        }
        return exists;
    }

    public static boolean remoteBranchExists(Git git, String remote, String branch) throws GitAPIException {
        List list = git.branchList().setListMode(ListBranchCommand.ListMode.REMOTE).call();
        String fullName = "refs/remotes/" + remote + "/" + branch;
        boolean exists = false;
        for (Ref ref : list) {
            String name = ref.getName();
            if (!Objects.equal((Object)name, (Object)fullName)) continue;
            exists = true;
        }
        return exists;
    }
}

