/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.itests.basic.mq;

import io.fabric8.api.Container;
import io.fabric8.api.FabricService;
import io.fabric8.api.Profile;
import io.fabric8.api.ServiceProxy;
import io.fabric8.itests.paxexam.support.ContainerBuilder;
import io.fabric8.itests.paxexam.support.FabricTestSupport;
import io.fabric8.itests.paxexam.support.Provision;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.management.ObjectName;
import org.apache.activemq.broker.jmx.BrokerViewMBean;
import org.apache.activemq.command.DiscoveryEvent;
import org.apache.activemq.transport.discovery.DiscoveryListener;
import org.apache.curator.framework.CuratorFramework;
import org.fusesource.mq.fabric.FabricDiscoveryAgent;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.ops4j.pax.exam.CoreOptions;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.junit.Configuration;
import org.ops4j.pax.exam.junit.ExamReactorStrategy;
import org.ops4j.pax.exam.junit.JUnit4TestRunner;
import org.ops4j.pax.exam.options.DefaultCompositeOption;
import org.ops4j.pax.exam.spi.reactors.AllConfinedStagedReactorFactory;
import org.osgi.framework.BundleContext;

@RunWith(value=JUnit4TestRunner.class)
@ExamReactorStrategy(value={AllConfinedStagedReactorFactory.class})
public class MQProfileTest
extends FabricTestSupport {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLocalChildCreation() throws Exception {
        System.err.println(MQProfileTest.executeCommand((String)"fabric:create -n"));
        ServiceProxy fabricProxy = ServiceProxy.createServiceProxy((BundleContext)this.bundleContext, FabricService.class);
        try {
            Set containers = ContainerBuilder.create((ServiceProxy)fabricProxy, (int)2).withName("child").withProfiles("default").assertProvisioningResult().build();
            try {
                LinkedList containerList = new LinkedList(containers);
                Container broker = (Container)containerList.removeLast();
                Profile brokerProfile = broker.getVersion().getProfile("mq-default");
                broker.setProfiles(new Profile[]{brokerProfile});
                Provision.provisioningSuccess(Arrays.asList(broker), (Long)PROVISION_TIMEOUT);
                this.waitForBroker("default");
                final BrokerViewMBean bean = (BrokerViewMBean)Provision.getMBean((Container)broker, (ObjectName)new ObjectName("org.apache.activemq:type=Broker,brokerName=" + broker.getId()), BrokerViewMBean.class, (long)120000L);
                Assert.assertEquals((String)"Producer not present", (long)0L, (long)bean.getTotalProducerCount());
                Assert.assertEquals((String)"Consumer not present", (long)0L, (long)bean.getTotalConsumerCount());
                for (Container c : containerList) {
                    Profile exampleProfile = broker.getVersion().getProfile("example-mq");
                    c.setProfiles(new Profile[]{exampleProfile});
                }
                Provision.provisioningSuccess((Collection)containers, (Long)PROVISION_TIMEOUT);
                Provision.waitForCondition((Callable)new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        while (bean.getTotalProducerCount() == 0L || bean.getTotalConsumerCount() == 0L) {
                            Thread.sleep(1000L);
                        }
                        return true;
                    }
                }, (Long)120000L);
                Assert.assertEquals((String)"Producer not present", (long)1L, (long)bean.getTotalProducerCount());
                Assert.assertEquals((String)"Consumer not present", (long)1L, (long)bean.getTotalConsumerCount());
            }
            finally {
                ContainerBuilder.destroy((Set)containers);
            }
        }
        finally {
            fabricProxy.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMQCreateBasic() throws Exception {
        System.err.println(MQProfileTest.executeCommand((String)"fabric:create -n"));
        System.err.println(MQProfileTest.executeCommand((String)"mq-create --jmx-user admin --jmx-password admin --minimumInstances 1 mq"));
        ServiceProxy fabricProxy = ServiceProxy.createServiceProxy((BundleContext)this.bundleContext, FabricService.class);
        try {
            Set containers = ContainerBuilder.create((ServiceProxy)fabricProxy, (int)2).withName("child").withProfiles("default").assertProvisioningResult().build();
            try {
                LinkedList containerList = new LinkedList(containers);
                Container broker = (Container)containerList.removeLast();
                Profile brokerProfile = broker.getVersion().getProfile("mq-broker-default.mq");
                broker.setProfiles(new Profile[]{brokerProfile});
                Provision.provisioningSuccess(Arrays.asList(broker), (Long)PROVISION_TIMEOUT);
                this.waitForBroker("default");
                final BrokerViewMBean bean = (BrokerViewMBean)Provision.getMBean((Container)broker, (ObjectName)new ObjectName("org.apache.activemq:type=Broker,brokerName=mq"), BrokerViewMBean.class, (long)120000L);
                System.err.println(MQProfileTest.executeCommand((String)"container-list"));
                for (Container c : containerList) {
                    Profile exampleProfile = broker.getVersion().getProfile("example-mq");
                    c.setProfiles(new Profile[]{exampleProfile});
                }
                Provision.provisioningSuccess((Collection)containers, (Long)PROVISION_TIMEOUT);
                Provision.waitForCondition((Callable)new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        while (bean.getTotalProducerCount() == 0L || bean.getTotalConsumerCount() == 0L) {
                            Thread.sleep(1000L);
                        }
                        return true;
                    }
                }, (Long)120000L);
                Assert.assertEquals((String)"Producer not present", (long)1L, (long)bean.getTotalProducerCount());
                Assert.assertEquals((String)"Consumer not present", (long)1L, (long)bean.getTotalConsumerCount());
            }
            finally {
                ContainerBuilder.destroy((Set)containers);
            }
        }
        finally {
            fabricProxy.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMQCreateNetwork() throws Exception {
        System.err.println(MQProfileTest.executeCommand((String)"fabric:create -n"));
        MQProfileTest.executeCommand((String)"mq-create --group us-east --networks us-west --jmx-user admin --jmx-password admin --networks-username admin --networks-password admin --minimumInstances 1 us-east");
        MQProfileTest.executeCommand((String)"mq-create --group us-west --networks us-east --jmx-user admin --jmx-password admin --networks-username admin --networks-password admin --minimumInstances 1 us-west");
        ServiceProxy fabricProxy = ServiceProxy.createServiceProxy((BundleContext)this.bundleContext, FabricService.class);
        try {
            Set containers = ContainerBuilder.create((ServiceProxy)fabricProxy, (int)4).withName("child").withProfiles("default").assertProvisioningResult().build();
            try {
                LinkedList containerList = new LinkedList(containers);
                Container eastBroker = (Container)containerList.removeLast();
                Container westBroker = (Container)containerList.removeLast();
                Profile eastBrokerProfile = eastBroker.getVersion().getProfile("mq-broker-us-east.us-east");
                eastBroker.setProfiles(new Profile[]{eastBrokerProfile});
                Profile westBrokerProfile = eastBroker.getVersion().getProfile("mq-broker-us-west.us-west");
                westBroker.setProfiles(new Profile[]{westBrokerProfile});
                Provision.provisioningSuccess(Arrays.asList(westBroker, eastBroker), (Long)PROVISION_TIMEOUT);
                this.waitForBroker("us-east");
                this.waitForBroker("us-west");
                final BrokerViewMBean brokerEast = (BrokerViewMBean)Provision.getMBean((Container)eastBroker, (ObjectName)new ObjectName("org.apache.activemq:type=Broker,brokerName=us-east"), BrokerViewMBean.class, (long)120000L);
                final BrokerViewMBean brokerWest = (BrokerViewMBean)Provision.getMBean((Container)westBroker, (ObjectName)new ObjectName("org.apache.activemq:type=Broker,brokerName=us-west"), BrokerViewMBean.class, (long)120000L);
                Container eastProducer = (Container)containerList.removeLast();
                MQProfileTest.executeCommand((String)("container-add-profile " + eastProducer.getId() + " example-mq-producer mq-client-us-east"));
                Container westConsumer = (Container)containerList.removeLast();
                MQProfileTest.executeCommand((String)("container-add-profile " + westConsumer.getId() + " example-mq-consumer mq-client-us-west"));
                Provision.provisioningSuccess(Arrays.asList(eastProducer, westConsumer), (Long)PROVISION_TIMEOUT);
                System.out.println(MQProfileTest.executeCommand((String)"fabric:container-list"));
                Provision.waitForCondition((Callable)new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        while (brokerEast.getTotalEnqueueCount() == 0L || brokerWest.getTotalDequeueCount() == 0L) {
                            Thread.sleep(1000L);
                        }
                        return true;
                    }
                }, (Long)120000L);
                System.out.println(MQProfileTest.executeCommand((String)("fabric:container-connect -u admin -p admin " + eastBroker.getId() + " bstat")));
                System.out.println(MQProfileTest.executeCommand((String)("fabric:container-connect -u admin -p admin " + westBroker.getId() + " bstat")));
                Assert.assertFalse((String)"Messages not sent", (brokerEast.getTotalEnqueueCount() == 0L ? 1 : 0) != 0);
                Assert.assertFalse((String)"Messages not received", (brokerWest.getTotalDequeueCount() == 0L ? 1 : 0) != 0);
            }
            finally {
                ContainerBuilder.destroy((Set)containers);
            }
        }
        finally {
            fabricProxy.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForBroker(String groupName) throws Exception {
        ServiceProxy curatorProxy = ServiceProxy.createServiceProxy((BundleContext)this.bundleContext, CuratorFramework.class);
        try {
            CuratorFramework curator = (CuratorFramework)curatorProxy.getService();
            final CountDownLatch serviceLatch = new CountDownLatch(1);
            final FabricDiscoveryAgent discoveryAgent = new FabricDiscoveryAgent();
            discoveryAgent.setCurator(curator);
            discoveryAgent.setGroupName(groupName);
            discoveryAgent.setDiscoveryListener(new DiscoveryListener(){

                public void onServiceAdd(DiscoveryEvent discoveryEvent) {
                    System.out.println("Service added:" + discoveryEvent.getServiceName());
                    serviceLatch.countDown();
                    try {
                        discoveryAgent.stop();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                public void onServiceRemove(DiscoveryEvent discoveryEvent) {
                    System.out.println("Service removed:" + discoveryEvent.getServiceName());
                }
            });
            discoveryAgent.start();
            Assert.assertTrue((boolean)serviceLatch.await(15L, TimeUnit.MINUTES));
        }
        finally {
            curatorProxy.close();
        }
    }

    @Configuration
    public Option[] config() {
        return new Option[]{new DefaultCompositeOption(this.fabricDistributionConfiguration()), (Option)CoreOptions.scanFeatures((String)"default", (String[])new String[]{"mq-fabric"}).start()};
    }
}

