/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.testkit.support;

import io.fabric8.common.util.Closeables;
import io.fabric8.common.util.Files;
import io.fabric8.common.util.IOHelpers;
import io.fabric8.common.util.Processes;
import io.fabric8.common.util.Strings;
import io.fabric8.testkit.FabricAssertions;
import io.fabric8.testkit.FabricController;
import io.fabric8.testkit.jolokia.JolokiaFabricController;
import io.fabric8.testkit.support.FabricControllerManagerSupport;
import io.fabric8.testkit.support.FileExistsFilter;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandLineFabricControllerManager
extends FabricControllerManagerSupport {
    private static final transient Logger LOG = LoggerFactory.getLogger(CommandLineFabricControllerManager.class);
    private File installDir;
    private String startFabricScriptName = "bin/fabric8-start";

    @Override
    public FabricController createFabric() throws Exception {
        if (this.workDirectory == null) {
            this.workDirectory = this.createTempDirectory();
        }
        String version = System.getProperty("fabric8-version", "1.2.0.redhat-6-2-0-SNAPSHOT");
        String home = System.getProperty("user.home", "~");
        String repo = home + "/.m2/repository";
        File distro = new File(repo, "io/fabric8/fabric8-karaf/" + version + "/fabric8-karaf-" + version + ".tar.gz");
        FabricAssertions.assertFileExists(distro);
        this.installDir = new File(this.workDirectory, "fabric8-karaf-" + version);
        this.killInstanceProcesses(this.getInstancesFile());
        if (this.workDirectory.exists()) {
            Files.recursiveDelete((File)this.workDirectory);
        }
        this.workDirectory.mkdirs();
        this.executeCommand(this.workDirectory, "tar", "zxf", distro.getAbsolutePath());
        FabricAssertions.assertDirectoryExists(this.installDir);
        Assert.assertTrue((String)("install dir does not exist: " + this.installDir.getAbsolutePath()), (boolean)this.installDir.exists());
        Assert.assertTrue((String)("install dir is not a directory: " + this.installDir.getAbsolutePath()), (boolean)this.installDir.isDirectory());
        System.out.println("About to boot up the fabric8 at: " + this.installDir.getAbsolutePath());
        File shellScript = new File(this.installDir, this.startFabricScriptName);
        FabricAssertions.assertFileExists(shellScript);
        this.executeCommand(this.installDir, "./" + this.startFabricScriptName);
        FabricController restApi = this.createFabricController();
        return restApi;
    }

    @Override
    public void destroy() throws Exception {
        if (this.installDir == null) {
            return;
        }
        boolean killProcesses = FabricAssertions.shouldKillProcessesAfterTestRun();
        if (!killProcesses) {
            String message = this.installDir == null ? "" : " at: " + this.installDir.getAbsolutePath();
            System.out.println("Not destroying the fabric" + message + " due to system property " + "fabric8.testkit.killContainers" + " being " + System.getProperty("fabric8.testkit.killContainers"));
            return;
        }
        System.out.println("Destroying the fabric at: " + this.installDir.getAbsolutePath());
        File instancesFile = this.waitForInstancesFile(20000L);
        this.killInstanceProcesses(instancesFile);
    }

    protected FabricController createFabricController() {
        return new JolokiaFabricController();
    }

    protected File createTempDirectory() throws IOException {
        File tempFile = File.createTempFile("fabric8-testkit", ".dir");
        tempFile.delete();
        tempFile.mkdirs();
        return tempFile;
    }

    protected void killInstanceProcesses(File instancesFile) throws IOException {
        if (instancesFile != null && instancesFile.exists() && instancesFile.isFile()) {
            Properties properties = new Properties();
            properties.load(new FileInputStream(instancesFile));
            Set<Map.Entry<Object, Object>> entries = properties.entrySet();
            for (Map.Entry<Object, Object> entry : entries) {
                String pidText;
                Long pid;
                Object value;
                String text;
                Object key = entry.getKey();
                if (key == null || !(text = key.toString()).startsWith("item.") || !text.endsWith(".pid") || !((value = entry.getValue()) instanceof String) || (pid = Long.valueOf(Long.parseLong(pidText = value.toString()))) == null) continue;
                System.out.println("Killing process " + pid);
                int status = Processes.killProcess((Long)pid, (String)"-9");
                if (status == 0) continue;
                System.err.println("Failed to kill process " + pid + ". Got " + status);
            }
        }
    }

    protected File waitForInstancesFile(long timeout) throws Exception {
        if (this.installDir != null) {
            return FabricAssertions.waitForValidValue(timeout, new Callable<File>(){

                @Override
                public File call() throws Exception {
                    return CommandLineFabricControllerManager.this.getInstancesFile();
                }
            }, new FileExistsFilter());
        }
        return null;
    }

    protected File getInstancesFile() {
        return new File(this.installDir, "instances/instance.properties");
    }

    protected String executeCommand(File workDir, String ... commands) throws IOException {
        String errors = null;
        String answer = null;
        String message = Strings.join(Arrays.asList(commands), (String)" ");
        try {
            System.out.println("Executing " + message);
            ProcessBuilder builder = new ProcessBuilder(new String[0]).command(commands).directory(workDir);
            Map<String, String> env = builder.environment();
            Map<String, String> envVars = this.createChildEnvironmentVariables();
            env.putAll(envVars);
            this.logEnvironmentVariables(env);
            Process process = builder.start();
            answer = this.readProcessOutput(process.getInputStream(), message);
            errors = this.processErrors(process.getErrorStream(), message);
            int status = process.waitFor();
            Assert.assertEquals((String)("Command " + message + "; " + answer + " Status"), (long)0L, (long)status);
        }
        catch (Exception e) {
            Assert.fail((String)("Failed to execute command " + message + ": " + e));
        }
        errors = errors.trim();
        if (errors.length() > 0) {
            Assert.fail((String)("Command: " + message + " got errors: " + errors));
        }
        return answer;
    }

    protected void logEnvironmentVariables(Map<String, String> env) {
        if (LOG.isDebugEnabled()) {
            TreeMap<String, String> sorted = new TreeMap<String, String>(env);
            Set<Map.Entry<String, String>> entries = sorted.entrySet();
            for (Map.Entry<String, String> entry : entries) {
                LOG.debug("Setting " + entry.getKey() + "=" + entry.getValue());
            }
        }
    }

    protected String readProcessOutput(InputStream inputStream, String message) throws Exception {
        return IOHelpers.readFully((InputStream)inputStream);
    }

    protected String processErrors(InputStream inputStream, String message) throws Exception {
        StringBuilder builder = new StringBuilder();
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (builder.length() > 0) {
                    builder.append("\n");
                }
                builder.append(line);
                LOG.info(line);
            }
            line = builder.toString();
            return line;
        }
        catch (Exception e) {
            LOG.error("Failed to process stderr for " + message + ": " + e, (Throwable)e);
            throw e;
        }
        finally {
            Closeables.closeQuietly((Closeable)reader);
        }
    }
}

