/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.testkit.support;

import io.fabric8.common.util.Strings;
import io.fabric8.testkit.FabricControllerManager;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class FabricControllerManagerSupport
implements FabricControllerManager {
    public static final String JAVA_OPTS = "JAVA_OPTS";
    public static final String DEFAULT_JAVA_OPTS = "-XX:MaxPermSize=350m";
    protected File workDirectory;
    private Set<String> profiles = new HashSet<String>();
    private String[] allowInheritedEnvironmentVariables = new String[]{"JAVA_HOME", "DYLD_LIBRARY_PATH", "LD_LIBRARY_PATH", "MAVEN_HOME", "PATH", "USER"};
    private Map<String, String> environmentVariables = new HashMap<String, String>();

    protected FabricControllerManagerSupport() {
        this.profiles.add("autoscale");
    }

    public String[] getAllowInheritedEnvironmentVariables() {
        return this.allowInheritedEnvironmentVariables;
    }

    public void setAllowInheritedEnvironmentVariables(String ... allowInheritedEnvironmentVariables) {
        this.allowInheritedEnvironmentVariables = allowInheritedEnvironmentVariables;
    }

    public Set<String> getProfiles() {
        return this.profiles;
    }

    public void setProfiles(Collection<String> profiles) {
        HashSet<String> set = new HashSet<String>();
        set.addAll(profiles);
        this.profiles = set;
    }

    public Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public void setEnvironmentVariables(Map<String, String> environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    protected Map<String, String> createChildEnvironmentVariables() {
        HashMap<String, String> answer = new HashMap<String, String>();
        Map<String, String> current = System.getenv();
        for (String variable : this.allowInheritedEnvironmentVariables) {
            String value = current.get(variable);
            if (!Strings.isNotBlank((String)value)) continue;
            answer.put(variable, value);
        }
        if (this.environmentVariables != null) {
            answer.putAll(this.environmentVariables);
        }
        answer.put("FABRIC8_PROFILES", Strings.join(this.getProfiles(), (String)","));
        if (answer.get(JAVA_OPTS) == null) {
            answer.put(JAVA_OPTS, DEFAULT_JAVA_OPTS);
        }
        return answer;
    }

    public void setEnvironmentVariable(String name, String value) {
        if (this.environmentVariables == null) {
            this.environmentVariables = new HashMap<String, String>();
        }
        if (value == null) {
            this.environmentVariables.remove(name);
        } else {
            this.environmentVariables.put(name, value);
        }
    }

    @Override
    public File getWorkDirectory() {
        return this.workDirectory;
    }

    @Override
    public void setWorkDirectory(File workDirectory) {
        this.workDirectory = workDirectory;
    }
}

