/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.testkit.jolokia;

import io.fabric8.api.FabricRequirements;
import io.fabric8.api.jmx.ContainerDTO;
import io.fabric8.api.jmx.FabricManagerMBean;
import io.fabric8.internal.RequirementsJson;
import io.fabric8.testkit.FabricController;
import io.fabric8.testkit.jolokia.JolokiaClients;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jolokia.client.J4pClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JolokiaFabricController
implements FabricController {
    private static final transient Logger LOG = LoggerFactory.getLogger(JolokiaFabricController.class);
    private final String jolokiaUrl;
    private final String user;
    private final String password;
    private final J4pClient jolokia;
    private final FabricManagerMBean fabricManager;
    private String fabricMBean = "io.fabric8:type=Fabric";

    public JolokiaFabricController() {
        this("http://localhost:8181/jolokia");
    }

    public JolokiaFabricController(String jolokiaUrl) {
        this(jolokiaUrl, "admin", "admin", 30000, 30000);
    }

    public JolokiaFabricController(String jolokiaUrl, String user, String password, int connectionTimeout, int socketTimeout) {
        this.jolokiaUrl = jolokiaUrl;
        this.user = user;
        this.password = password;
        this.jolokia = J4pClient.url((String)jolokiaUrl).user(user).password(password).connectionTimeout(connectionTimeout).socketTimeout(socketTimeout).build();
        this.fabricManager = JolokiaClients.createFabricManager(this.jolokia);
    }

    @Override
    public FabricRequirements getRequirements() {
        return this.fabricManager.requirements();
    }

    @Override
    public void setRequirements(FabricRequirements requirements) throws Exception {
        String json = RequirementsJson.toJSON((FabricRequirements)requirements);
        this.fabricManager.requirementsJson(json);
    }

    @Override
    public List<Map<String, Object>> containerProperties(String ... properties) {
        List<String> list = Arrays.asList(properties);
        return this.fabricManager.containers(list);
    }

    @Override
    public List<String> containerIdsForProfile(String versionId, String profileId) {
        return this.fabricManager.containerIdsForProfile(versionId, profileId);
    }

    @Override
    public List<ContainerDTO> containers() throws Exception {
        List<String> ids = this.containerIds();
        return this.containers(ids);
    }

    @Override
    public List<ContainerDTO> containers(List<String> ids) {
        ArrayList<ContainerDTO> answer = new ArrayList<ContainerDTO>();
        for (String id : ids) {
            ContainerDTO container = this.getContainer(id);
            if (container == null) continue;
            answer.add(container);
        }
        return answer;
    }

    @Override
    public List<ContainerDTO> containersForProfile(String version, String profileId) {
        List<String> ids = this.containerIdsForProfile(version, profileId);
        return this.containers(ids);
    }

    @Override
    public String getDefaultVersion() {
        return this.fabricManager.getDefaultVersion();
    }

    @Override
    public List<String> containerIds() throws Exception {
        String[] array = this.fabricManager.containerIds();
        if (array != null) {
            return Arrays.asList(array);
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public ContainerDTO getContainer(String containerId) {
        Map map = this.fabricManager.getContainer(containerId);
        if (map != null) {
            return this.mapJolokiaReturnValueToDTO(map, ContainerDTO.class);
        }
        return null;
    }

    protected <T> T mapJolokiaReturnValueToDTO(Map<String, Object> map, Class<T> clazz) {
        Map<String, PropertyDescriptor> propertyDescriptors;
        T answer;
        try {
            answer = clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to instantiate " + clazz.getCanonicalName() + ". " + e, e);
        }
        try {
            propertyDescriptors = JolokiaFabricController.getPropertyDescriptors(clazz);
        }
        catch (IntrospectionException e) {
            throw new RuntimeException("Failed to introspect " + clazz.getCanonicalName() + ". " + e, e);
        }
        Set<Map.Entry<String, Object>> entries = map.entrySet();
        for (Map.Entry<String, Object> entry : entries) {
            String name = entry.getKey();
            Object value = entry.getValue();
            PropertyDescriptor descriptor = propertyDescriptors.get(name);
            if (descriptor == null) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Ignoring unknown property " + name + " on class " + clazz.getCanonicalName() + " with value: " + value);
                continue;
            }
            Method writeMethod = descriptor.getWriteMethod();
            if (writeMethod == null) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Ignoring read only property " + name + " on class " + clazz.getCanonicalName() + " with value: " + value);
                continue;
            }
            Class<?> propertyType = descriptor.getPropertyType();
            try {
                value = JolokiaClients.convertJolokiaToJavaType(propertyType, value);
            }
            catch (IOException e) {
                LOG.warn("Failed to convert property value for " + name + " on class " + clazz.getCanonicalName() + " type: " + propertyType.getCanonicalName() + " with value: " + value + (value != null ? " type " + value.getClass().getCanonicalName() : null) + ". " + e, (Throwable)e);
                continue;
            }
            Object[] args = new Object[]{value};
            Class[] parameterTypes = new Class[]{propertyType};
            try {
                writeMethod.invoke(answer, args);
            }
            catch (Exception e) {
                LOG.warn("Failed to set property " + name + " on class " + clazz.getCanonicalName() + " type: " + propertyType.getCanonicalName() + " with value: " + value + (value != null ? " type " + value.getClass().getCanonicalName() : null) + ". " + e, (Throwable)e);
            }
        }
        return answer;
    }

    public static Map<String, PropertyDescriptor> getPropertyDescriptors(Class<?> aClass) throws IntrospectionException {
        HashMap<String, PropertyDescriptor> answer = new HashMap<String, PropertyDescriptor>();
        if (aClass != null) {
            PropertyDescriptor[] propertyDescriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(aClass);
            for (PropertyDescriptor propertyDescriptor : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                String name = propertyDescriptor.getName();
                if (name.equals("class")) continue;
                answer.put(name, propertyDescriptor);
            }
        }
        return answer;
    }

    public J4pClient getJolokia() {
        return this.jolokia;
    }
}

