/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.testkit.jolokia;

import io.fabric8.testkit.jolokia.JolokiaClients;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.List;
import javax.management.ObjectName;
import org.jolokia.client.J4pClient;
import org.jolokia.client.exception.J4pException;
import org.jolokia.client.request.J4pExecRequest;
import org.jolokia.client.request.J4pReadRequest;
import org.jolokia.client.request.J4pRequest;
import org.jolokia.client.request.J4pResponse;
import org.jolokia.client.request.J4pWriteRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JolokiaInvocationHandler
implements InvocationHandler {
    private static final transient Logger LOG = LoggerFactory.getLogger(JolokiaInvocationHandler.class);
    private final J4pClient jolokia;
    private final ObjectName objectName;
    private final Class<?> interfaceClass;

    public static <T> T newProxyInstance(J4pClient jolokia, ObjectName objectName, Class<T> interfaceClass) {
        return (T)Proxy.newProxyInstance(interfaceClass.getClassLoader(), new Class[]{interfaceClass}, (InvocationHandler)new JolokiaInvocationHandler(jolokia, objectName, interfaceClass));
    }

    public JolokiaInvocationHandler(J4pClient jolokia, ObjectName objectName, Class<?> interfaceClass) {
        this.jolokia = jolokia;
        this.objectName = objectName;
        this.interfaceClass = interfaceClass;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        J4pReadRequest request;
        String name = method.getName();
        String attribute = this.getterAttributeName(method);
        if (attribute != null) {
            request = new J4pReadRequest(this.objectName, new String[]{attribute});
        } else {
            attribute = this.setterAttributeName(method);
            if (attribute != null) {
                request = new J4pWriteRequest(this.objectName, attribute, args[0], new String[0]);
            } else {
                name = this.executeMethodName(method);
                request = args == null | method.getParameterTypes().length == 0 ? new J4pExecRequest(this.objectName, name, new Object[0]) : new J4pExecRequest(this.objectName, name, args);
            }
        }
        try {
            request.setPreferredHttpMethod("POST");
            J4pResponse response = this.jolokia.execute((J4pRequest)request);
            Object value = response.getValue();
            return JolokiaClients.convertJolokiaToJavaType(method.getReturnType(), value);
        }
        catch (J4pException e) {
            List<Object> argsList = args == null ? null : Arrays.asList(args);
            LOG.warn("Failed to invoke " + this.objectName + " method: " + name + " with arguments: " + argsList + ". " + (Object)((Object)e), (Throwable)e);
            throw e;
        }
    }

    protected String getterAttributeName(Method method) {
        String name = method.getName();
        int length = name.length();
        Class<?>[] parameterTypes = method.getParameterTypes();
        Class<?> returnType = method.getReturnType();
        if (parameterTypes.length == 0 && !Void.class.equals(returnType)) {
            boolean returnsBool;
            boolean bl = returnsBool = returnType.equals(Boolean.class) || returnType.equals(Boolean.TYPE);
            if (name.startsWith("get") && length > 3) {
                return name.substring(3);
            }
            if (returnsBool && name.startsWith("is") && length > 2) {
                return name.substring(2);
            }
        }
        return null;
    }

    protected String setterAttributeName(Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length == 1) {
            String name = method.getName();
            int nameLength = name.length();
            if (name.startsWith("set") && nameLength > 3) {
                return name.substring(3);
            }
        }
        return null;
    }

    protected String executeMethodName(Method method) {
        String name = method.getName();
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (JolokiaInvocationHandler.methodCount(this.interfaceClass, name) > 1) {
            StringBuilder buffer = new StringBuilder(name);
            buffer.append("(");
            boolean first = true;
            for (Class<?> parameterType : parameterTypes) {
                if (first) {
                    first = false;
                } else {
                    buffer.append(",");
                }
                buffer.append(parameterType.getCanonicalName());
            }
            buffer.append(")");
            return buffer.toString();
        }
        return name;
    }

    protected static int methodCount(Class<?> clazz, String name) {
        Class<?> superclass;
        Method[] declaredMethods;
        int answer = 0;
        for (Method method : declaredMethods = clazz.getDeclaredMethods()) {
            if (!name.equals(method.getName())) continue;
            ++answer;
        }
        if (!clazz.equals(Object.class) && (superclass = clazz.getSuperclass()) != null && !superclass.equals(Object.class)) {
            answer += JolokiaInvocationHandler.methodCount(superclass, name);
        }
        return answer;
    }
}

