/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.testkit;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.api.Containers;
import io.fabric8.api.FabricRequirements;
import io.fabric8.api.ProfileRequirements;
import io.fabric8.api.jmx.ContainerDTO;
import io.fabric8.common.util.Filter;
import io.fabric8.common.util.Filters;
import io.fabric8.common.util.IOHelpers;
import io.fabric8.common.util.Processes;
import io.fabric8.common.util.Strings;
import io.fabric8.core.jmx.BeanUtils;
import io.fabric8.internal.RequirementsJson;
import io.fabric8.testkit.FabricController;
import io.fabric8.testkit.FabricControllerManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.jolokia.client.exception.J4pRemoteException;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FabricAssertions {
    public static final String KILL_CONTAINERS_FLAG = "fabric8.testkit.killContainers";
    public static final long DEFAULT_REQUIREMENT_PROVISION_TIMEOUT = 600000L;
    private static final transient Logger LOG = LoggerFactory.getLogger(FabricAssertions.class);
    private static long defaultTimeout = 360000L;
    private static long defaultWaitSleepPeriod = 1000L;
    private static ObjectMapper mapper = new ObjectMapper();

    public static FabricController assertFabricCreate(FabricControllerManager factory, FabricRequirements requirements) throws Exception {
        Assert.assertNotNull((String)"FabricRequirements", (Object)requirements);
        FabricController controller = FabricAssertions.assertFabricCreate(factory);
        FabricAssertions.assertRequirementsSatisfied(controller, requirements);
        return controller;
    }

    public static void assertRequirementsSatisfied(FabricController controller, FabricRequirements requirements) throws Exception {
        FabricAssertions.assertRequirementsSatisfied(controller, requirements, 600000L);
    }

    public static void assertRequirementsSatisfied(final FabricController controller, final FabricRequirements requirements, long timeout) throws Exception {
        Assert.assertNotNull((String)"FabricController", (Object)controller);
        Assert.assertNotNull((String)"FabricRequirements", (Object)requirements);
        Assert.assertNotNull((String)"Should have some FabricRequirements", (Object)requirements);
        FabricAssertions.waitForValidValue(timeout, new Callable<Boolean>(){
            boolean hasUpdatedRequirements = false;
            Set<String> previousValidProfileIds = new HashSet<String>();

            @Override
            public Boolean call() throws Exception {
                controller.setRequirements(requirements);
                FabricRequirements actual = controller.getRequirements();
                String actualVersion = actual.getVersion();
                actual.setVersion(requirements.getVersion());
                requirements.sortProfilesRequirements();
                actual.sortProfilesRequirements();
                boolean valid = RequirementsJson.equal((FabricRequirements)requirements, (FabricRequirements)actual);
                if (!valid) {
                    System.out.println("Expected: " + RequirementsJson.toJSON((FabricRequirements)requirements));
                    System.out.println("Actual:   " + RequirementsJson.toJSON((FabricRequirements)actual));
                    System.out.println();
                    return false;
                }
                if (!this.hasUpdatedRequirements) {
                    this.hasUpdatedRequirements = true;
                    System.out.println("Updated the requirements to: " + RequirementsJson.toJSON((FabricRequirements)requirements));
                }
                HashSet<String> validProfileIds = new HashSet<String>();
                List profileRequirements = requirements.getProfileRequirements();
                Assert.assertNotNull((String)"Should have some profileRequirements", (Object)profileRequirements);
                String version = FabricAssertions.requirementOrDefaultVersion(controller, requirements);
                for (ProfileRequirements profileRequirement : profileRequirements) {
                    Integer minimumInstances = profileRequirement.getMinimumInstances();
                    Integer maximumInstances = profileRequirement.getMaximumInstances();
                    String profile = profileRequirement.getProfile();
                    boolean wasValid = this.previousValidProfileIds.contains(profile);
                    boolean bl = valid = valid && FabricAssertions.isProfileInstancesValid(controller, version, profile, minimumInstances, maximumInstances, wasValid);
                    if (!valid) break;
                    validProfileIds.add(profile);
                }
                this.previousValidProfileIds = validProfileIds;
                if (valid) {
                    System.out.println("Fabric requirements are all satisfied for profiles: " + validProfileIds);
                }
                return valid;
            }
        });
    }

    public static void assertProfileInstancesValid(FabricController controller, String version, String profile, Integer minimumInstances, Integer maximumInstances) throws Exception {
        FabricAssertions.assertProfileInstancesValid(controller, version, profile, minimumInstances, maximumInstances, 600000L);
    }

    public static void assertProfileInstancesValid(final FabricController controller, final String version, final String profile, final Integer minimumInstances, final Integer maximumInstances, long timeout) throws Exception {
        Assert.assertNotNull((String)"FabricController", (Object)controller);
        FabricAssertions.waitForValidValue(timeout, new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                boolean valid = FabricAssertions.isProfileInstancesValid(controller, version, profile, minimumInstances, maximumInstances, false);
                if (valid) {
                    System.out.println("version: " + version + " profile: " + profile + " has the correct number of instances");
                }
                return valid;
            }
        });
    }

    public static boolean isProfileInstancesValid(FabricController controller, String version, String profile, Integer minimumInstances, Integer maximumInstances, boolean wasValid) {
        boolean valid = true;
        if (minimumInstances != null) {
            List<String> containerIds = controller.containerIdsForProfile(version, profile);
            int current = containerIds.size();
            if (current < minimumInstances) {
                System.out.println("Still waiting for " + minimumInstances + " instance(s) of profile " + profile + " currently has: " + containerIds);
                valid = false;
            } else if (FabricAssertions.checkMinimumInstancesSuccessful(controller, profile, minimumInstances, containerIds, wasValid)) {
                if (minimumInstances > 0 && !wasValid) {
                    System.out.println("Valid profile " + profile + " requires " + minimumInstances + " instance(s) and has: " + containerIds);
                }
            } else {
                valid = false;
            }
        }
        if (maximumInstances != null) {
            List<ContainerDTO> containers = controller.containersForProfile(version, profile);
            List aliveContainers = Containers.aliveAndSuccessfulContainers(containers);
            int current = aliveContainers.size();
            if (current > maximumInstances) {
                System.out.println("Still waiting for a maximum of " + maximumInstances + " instance(s) of profile " + profile + " currently has: " + current + " containers alive which need stopping");
                valid = false;
            } else if (!wasValid) {
                System.out.println("Profile scaled down: now running a maximum of " + maximumInstances + " instance(s) of profile " + profile + " currently has: " + current + " container(s)");
            }
        }
        return valid;
    }

    protected static boolean checkMinimumInstancesSuccessful(FabricController restAPI, String profile, int minimumInstances, List<String> containerIds, boolean wasValid) {
        int successful = 0;
        for (String containerId : containerIds) {
            ContainerDTO container = restAPI.getContainer(containerId);
            if (container == null) {
                System.out.println("No ContainerDTO for " + containerId);
                continue;
            }
            if (!wasValid) {
                System.out.println("Container " + containerId + " alive: " + container.isAlive() + " result: " + container.getProvisionResult() + " status: " + container.getProvisionStatus() + " complete: " + container.isProvisioningComplete() + " pending: " + container.isProvisioningPending() + " " + container.getProvisionException());
            }
            if (!container.isAliveAndOK() || !container.isProvisioningComplete() || container.isProvisioningPending() || !"success".equals(container.getProvisionResult())) continue;
            ++successful;
            if (!LOG.isDebugEnabled()) continue;
            List fields = BeanUtils.getFields(ContainerDTO.class);
            for (String field : fields) {
                LOG.debug("container " + containerId + " " + field + " = " + BeanUtils.getValue((Object)container, (String)field));
            }
        }
        return successful >= minimumInstances;
    }

    public static String requirementOrDefaultVersion(FabricController restAPI, FabricRequirements requirements) {
        String version = requirements.getVersion();
        if (Strings.isNotBlank((String)version)) {
            return version;
        }
        return restAPI.getDefaultVersion();
    }

    public static <T> T getDTO(String urlText, Class<T> clazz) throws IOException {
        System.out.println("Querying DTO at " + urlText);
        URL url = new URL(urlText);
        InputStream in = url.openStream();
        Assert.assertNotNull((String)("Could not open URL: " + urlText), (Object)in);
        String json = IOHelpers.readFully((InputStream)in);
        if (json != null && (json = json.trim()).length() > 0) {
            LOG.info("parsing JSON: " + json + " to class " + clazz.getCanonicalName());
            Object answer = mapper.reader(clazz).readValue(json);
            LOG.info("Got: " + answer);
            Assert.assertNotNull((String)("Should have received a DTO of type " + clazz.getCanonicalName() + " from URI: " + urlText), (Object)answer);
            return (T)answer;
        }
        return null;
    }

    public static FabricController assertFabricCreate(FabricControllerManager factory) throws Exception {
        Assert.assertNotNull((String)"FabricFactory", (Object)factory);
        FabricController controller = factory.createFabric();
        Assert.assertNotNull((String)"Should have created a REST API", (Object)controller);
        Thread.sleep(30000L);
        List<String> containerIds = FabricAssertions.waitForNotEmptyContainerIds(controller);
        System.out.println("Found containers: " + containerIds);
        FabricAssertions.assertProfileInstancesValid(controller, "1.0", "fabric", 1, null);
        return controller;
    }

    public static void assertFileExists(File file) {
        Assert.assertTrue((String)("file does not exist: " + file.getAbsolutePath()), (boolean)file.exists());
        Assert.assertTrue((String)("Not a file: " + file.getAbsolutePath()), (boolean)file.isFile());
    }

    public static void assertDirectoryExists(File file) {
        Assert.assertTrue((String)("file does not exist: " + file.getAbsolutePath()), (boolean)file.exists());
        Assert.assertTrue((String)("Not a directory: " + file.getAbsolutePath()), (boolean)file.isDirectory());
    }

    public static void killJavaAndDockerProcesses() {
        boolean killProcesses = FabricAssertions.shouldKillProcessesAfterTestRun();
        if (!killProcesses) {
            System.out.println("Not destroying the fabric processes due to system property fabric8.testkit.killContainers being " + System.getProperty(KILL_CONTAINERS_FLAG));
            return;
        }
        Processes.killJavaProcesses();
        Processes.killDockerContainers();
    }

    public static <T> T waitForValidValue(long timeout, Callable<T> callable, Filter<T> isValid) throws Exception {
        return FabricAssertions.waitForValidValue(timeout, callable, isValid, defaultWaitSleepPeriod);
    }

    public static <T> T waitForValidValue(Callable<T> callable, Filter<T> isValid) throws Exception {
        return FabricAssertions.waitForValidValue(defaultTimeout, callable, isValid, defaultWaitSleepPeriod);
    }

    public static <T> T waitForValidValue(long timeout, Callable<T> callable) throws Exception {
        return FabricAssertions.waitForValidValue(timeout, callable, new Filter<T>(){

            public boolean matches(T t) {
                if (t instanceof Boolean) {
                    return (Boolean)t;
                }
                return true;
            }
        }, defaultWaitSleepPeriod);
    }

    public static <T> T waitForValidValue(Callable<T> callable) throws Exception {
        return FabricAssertions.waitForValidValue(defaultTimeout, callable, Filters.trueFilter());
    }

    /*
     * Exception decompiling
     */
    public static <T> T waitForValidValue(long timeout, Callable<T> callable, Filter<T> isValid, long sleepTime) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.getBindingFor(org.benf.cfr.reader.bytecode.analysis.types.JavaTypeInstance)" because "res" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.GenericInferer.getGtbNullFiltered(GenericInferer.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.GenericInferer.inferGenericObjectInfoFromCalls(GenericInferer.java:139)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:484)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static ObjectMapper getObjectMapper() {
        return mapper;
    }

    public static List<String> waitForNotEmptyContainerIds(final FabricController restApi) throws Exception {
        Filter<List<String>> isValid = new Filter<List<String>>(){

            public String toString() {
                return "HasNotEmptyContainerIds";
            }

            public boolean matches(List<String> containerIds) {
                return containerIds.size() > 0;
            }
        };
        return FabricAssertions.waitForValidValue(new Callable<List<String>>(){

            @Override
            public List<String> call() throws Exception {
                try {
                    return restApi.containerIds();
                }
                catch (Exception e) {
                    System.out.println("Ignoring Exception while finding containers: " + FabricAssertions.unwrapException(e));
                    LOG.debug("Failed to load containers: " + e, (Throwable)e);
                    return null;
                }
            }
        }, isValid);
    }

    public static String unwrapException(Exception e) {
        if (e instanceof J4pRemoteException) {
            J4pRemoteException remoteException = (J4pRemoteException)e;
            LOG.warn("Remote Exception " + remoteException.getMessage() + ". " + remoteException.getRemoteStackTrace());
        }
        Throwable cause = e;
        if (e.getClass().equals(RuntimeException.class) || e instanceof UndeclaredThrowableException) {
            cause = e.getCause();
        }
        return cause.toString();
    }

    public static boolean shouldKillProcessesAfterTestRun() {
        String flag = System.getProperty(KILL_CONTAINERS_FLAG, "true");
        return !flag.toLowerCase().equals("false");
    }
}

