/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.itests.paxexam.support;

import io.fabric8.api.Container;
import io.fabric8.api.FabricService;
import io.fabric8.api.Profile;
import io.fabric8.api.Version;
import io.fabric8.itests.paxexam.support.ContainerCondition;
import io.fabric8.itests.paxexam.support.FabricTestSupport;
import io.fabric8.itests.paxexam.support.Provision;
import io.fabric8.tooling.testing.pax.exam.karaf.FabricKarafTestSupport;
import io.fabric8.zookeeper.ZkPath;
import io.fabric8.zookeeper.utils.ZooKeeperUtils;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.curator.framework.CuratorFramework;
import org.junit.Assert;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.junit.Configuration;
import org.ops4j.pax.exam.options.DefaultCompositeOption;

public abstract class FabricFeaturesTest
extends FabricTestSupport {
    private final Map<String, String[]> featureArguments = new LinkedHashMap<String, String[]>();
    private final Set<Container> targetContainers = new HashSet<Container>();
    private int maxTry = 3;

    protected void assertProvisionedFeature(FabricService fabricService, CuratorFramework curator, Set<? extends Container> containers, String featureNames, String profileName, final String expectedSymbolicNames) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("[ ");
        for (Container container : containers) {
            sb.append(container.getId()).append(" ");
        }
        sb.append("]");
        System.out.println("Testing profile:" + profileName + " on container:" + sb.toString() + " by adding feature:" + featureNames);
        Version version = fabricService.getRequiredDefaultVersion();
        Profile profile = version.getRequiredProfile("default");
        Profile targetProfile = version.getRequiredProfile(profileName);
        for (Container container : containers) {
            container.setProfiles(new Profile[]{profile});
        }
        Provision.containerStatus(containers, PROVISION_TIMEOUT);
        for (String featureName : featureNames.split(" ")) {
            System.out.println(FabricFeaturesTest.executeCommand((String)("fabric:profile-edit --feature " + featureName + " " + targetProfile.getId())));
        }
        System.out.println(FabricFeaturesTest.executeCommand((String)("fabric:profile-display " + profileName)));
        for (Container container : containers) {
            ZooKeeperUtils.setData((CuratorFramework)curator, (String)ZkPath.CONTAINER_PROVISION_RESULT.getPath(new String[]{container.getId()}), (String)"switching profile");
            container.setProfiles(new Profile[]{targetProfile});
        }
        Provision.containerStatus(containers, PROVISION_TIMEOUT);
        System.out.println(FabricFeaturesTest.executeCommand((String)"fabric:container-list"));
        Assert.assertTrue((boolean)Provision.waitForCondition(containers, new ContainerCondition(){

            @Override
            public Boolean checkConditionOnContainer(Container c) {
                for (String symbolicName : expectedSymbolicNames.split(" ")) {
                    String bundles = FabricKarafTestSupport.executeCommand((String)("container-connect -u admin -p admin " + c.getId() + " osgi:list -s -t 0 | grep " + symbolicName));
                    if (bundles == null) continue;
                    return bundles.contains(symbolicName);
                }
                return false;
            }
        }, PROVISION_TIMEOUT));
        for (Container container : containers) {
            if (!profile.equals(targetProfile)) {
                ZooKeeperUtils.setData((CuratorFramework)curator, (String)ZkPath.CONTAINER_PROVISION_RESULT.getPath(new String[]{container.getId()}), (String)"switching profile");
            }
            container.setProfiles(new Profile[]{profile});
        }
        Provision.containerStatus(containers, PROVISION_TIMEOUT);
        for (String featureName : featureNames.split(" ")) {
            System.out.println(FabricFeaturesTest.executeCommand((String)("fabric:profile-edit --delete --feature " + featureName + " " + targetProfile.getId())));
        }
    }

    protected void assertFeatures(FabricService fabricService, CuratorFramework curator) throws Exception {
        String feature = System.getProperty("feature");
        if (feature != null && !feature.isEmpty() && this.featureArguments.containsKey(feature)) {
            String[] arguments = this.featureArguments.get(feature);
            Assert.assertEquals((String)("Feature " + feature + " should have been prepared with 4 arguments"), (long)3L, (long)arguments.length);
            this.assertProvisionedFeature(fabricService, curator, this.targetContainers, arguments[0], arguments[1], arguments[2]);
        } else {
            for (Map.Entry<String, String[]> entry : this.featureArguments.entrySet()) {
                feature = entry.getKey();
                String[] arguments = entry.getValue();
                Assert.assertEquals((String)("Feature " + feature + " should have been prepared with 4 arguments"), (long)3L, (long)arguments.length);
                this.assertProvisionedFeature(fabricService, curator, this.targetContainers, arguments[0], arguments[1], arguments[2]);
            }
        }
    }

    protected void prepareFeaturesForTesting(Set<? extends Container> containers, String featureName, String profileName, String expectedSymbolicName) {
        this.targetContainers.addAll(containers);
        this.featureArguments.put(featureName, new String[]{featureName, profileName, expectedSymbolicName});
    }

    @Configuration
    public Option[] config() {
        return new Option[]{new DefaultCompositeOption(this.fabricDistributionConfiguration()), FabricFeaturesTest.copySystemProperty((String)"feature")};
    }
}

