/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.itests.paxexam.support;

import io.fabric8.api.Container;
import io.fabric8.api.CreateChildContainerOptions;
import io.fabric8.api.CreateContainerMetadata;
import io.fabric8.api.CreateContainerOptions;
import io.fabric8.api.FabricService;
import io.fabric8.api.Profile;
import io.fabric8.api.ServiceProxy;
import io.fabric8.api.Version;
import io.fabric8.itests.paxexam.support.Provision;
import io.fabric8.tooling.testing.pax.exam.karaf.FabricKarafTestSupport;
import io.fabric8.tooling.testing.pax.exam.karaf.ServiceLocator;
import io.fabric8.zookeeper.ZkPath;
import io.fabric8.zookeeper.utils.ZooKeeperUtils;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import javax.management.JMX;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.curator.framework.CuratorFramework;
import org.apache.felix.service.command.Function;
import org.junit.Assert;
import org.ops4j.pax.exam.CoreOptions;
import org.ops4j.pax.exam.MavenUtils;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.karaf.options.DoNotModifyLogOption;
import org.ops4j.pax.exam.karaf.options.KarafDistributionOption;
import org.ops4j.pax.exam.options.DefaultCompositeOption;
import org.ops4j.pax.exam.options.MavenUrlReference;
import org.osgi.framework.BundleContext;

public class FabricTestSupport
extends FabricKarafTestSupport {
    public static final String FABRIC_ITEST_GROUP_ID = "FABRIC_ITEST_GROUP_ID";
    public static final String FABRIC_ITEST_ARTIFACT_ID = "FABRIC_ITEST_ARTIFACT_ID";
    public static final String GROUP_ID = System.getenv().containsKey("FABRIC_ITEST_GROUP_ID") ? System.getenv("FABRIC_ITEST_GROUP_ID") : "io.fabric8";
    public static final String ARTIFACT_ID = System.getenv().containsKey("FABRIC_ITEST_ARTIFACT_ID") ? System.getenv("FABRIC_ITEST_ARTIFACT_ID") : "fabric8-karaf";
    static final String KARAF_GROUP_ID = "org.apache.karaf";
    static final String KARAF_ARTIFACT_ID = "apache-karaf";
    static final String KARAF_VERSION = "2.4.0";

    private Container createChildContainer(FabricService fabricService, String name, String parent, String profileName, String jvmOpts) throws Exception {
        Thread.sleep(DEFAULT_WAIT);
        Container parentContainer = fabricService.getContainer(parent);
        Assert.assertNotNull((Object)parentContainer);
        CreateChildContainerOptions.Builder builder = ((CreateChildContainerOptions.Builder)((CreateChildContainerOptions.Builder)((CreateChildContainerOptions.Builder)CreateChildContainerOptions.builder().name(name)).parent(parent)).zookeeperPassword(fabricService.getZookeeperPassword())).jmxUser("admin").jmxPassword("admin");
        if (jvmOpts != null) {
            builder.jvmOpts(jvmOpts);
        } else {
            builder.jvmOpts("-Xms1024m -Xmx1536m -Djava.net.preferIPv4Stack=true -Dpatching.disabled=true");
        }
        CreateContainerMetadata[] metadata = fabricService.createContainers((CreateContainerOptions)builder.build());
        if (metadata.length > 0) {
            if (metadata[0].getFailure() != null) {
                throw new Exception("Error creating child container:" + name, metadata[0].getFailure());
            }
            Container container = metadata[0].getContainer();
            Version version = fabricService.getRequiredDefaultVersion();
            Profile profile = version.getRequiredProfile(profileName);
            Assert.assertNotNull((String)("Expected to find profile with name:" + profileName), (Object)profile);
            container.setProfiles(new Profile[]{profile});
            Provision.containersStatus(Arrays.asList(container), "success", PROVISION_TIMEOUT);
            return container;
        }
        throw new Exception("Could container not created");
    }

    private void destroyChildContainer(FabricService fabricService, CuratorFramework curator, String name) throws InterruptedException {
        try {
            Thread.sleep(DEFAULT_WAIT);
            if (ZooKeeperUtils.exists((CuratorFramework)curator, (String)ZkPath.CONTAINER.getPath(new String[]{name})) != null) {
                Container container = fabricService.getContainer(name);
                container.destroy();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected Container createAndAssertChildContainer(FabricService fabricService, String name, String parent, String profile) throws Exception {
        return this.createAndAssertChildContainer(fabricService, name, parent, profile, null);
    }

    private Container createAndAssertChildContainer(FabricService fabricService, String name, String parent, String profile, String jvmOpts) throws Exception {
        Container child1 = this.createChildContainer(fabricService, name, parent, profile, jvmOpts);
        Container result = fabricService.getContainer(name);
        Assert.assertEquals((String)"Containers should have the same id", (Object)child1.getId(), (Object)result.getId());
        return result;
    }

    private boolean containerSetProfile(FabricService fabricService, CuratorFramework curator, String containerName, String profileName) throws Exception {
        return this.containerSetProfile(fabricService, curator, containerName, profileName, true);
    }

    private boolean containerSetProfile(FabricService fabricService, CuratorFramework curator, String containerName, String profileName, Boolean waitForProvision) throws Exception {
        System.out.println("Switching profile: " + profileName + " on container:" + containerName);
        Container container = fabricService.getContainer(containerName);
        Version version = container.getVersion();
        Object[] profiles = new Profile[]{version.getRequiredProfile(profileName)};
        Object[] currentProfiles = container.getProfiles();
        Arrays.sort(profiles);
        Arrays.sort(currentProfiles);
        boolean same = true;
        if (profiles.length != currentProfiles.length) {
            same = false;
        } else {
            for (int i = 0; i < currentProfiles.length; ++i) {
                if (currentProfiles[i].equals(profiles[i])) continue;
                same = false;
            }
        }
        if (!same && waitForProvision.booleanValue()) {
            ZooKeeperUtils.setData((CuratorFramework)curator, (String)ZkPath.CONTAINER_PROVISION_RESULT.getPath(new String[]{containerName}), (String)"switching profile");
            container.setProfiles((Profile[])profiles);
            Provision.containersStatus(Arrays.asList(container), "success", PROVISION_TIMEOUT);
        }
        return same;
    }

    private void addStagingRepoToDefaultProfile() {
        FabricTestSupport.executeCommand((String)"fabric:profile-edit -p io.fabric8.agent/org.ops4j.pax.url.mvn.repositories=http://repo1.maven.org/maven2,https://repository.jboss.org/nexus/content/repositories/fs-releases/,https://repository.jboss.org/nexus/content/repositories/fs-snapshots//@snapshots@noreleases,http://repository.apache.org/content/groups/snapshots-group@snapshots@noreleases,http://svn.apache.org/repos/asf/servicemix/m2-repo,http://repository.springsource.com/maven/bundles/release,http://repository.springsource.com/maven/bundles/external,https://repository.jboss.org/nexus/content/groups/ea default");
    }

    protected void waitForFabricCommands() {
        ServiceLocator.awaitService((BundleContext)this.bundleContext, Function.class, (String)"(&(osgi.command.scope=fabric)(osgi.command.function=profile-edit))");
    }

    protected String getKarafVersion() {
        String answer = KARAF_VERSION;
        System.out.println("*** Using Karaf version: " + answer + " ***");
        return answer;
    }

    protected Option[] fabricDistributionConfiguration() {
        return new Option[]{KarafDistributionOption.karafDistributionConfiguration().frameworkUrl((MavenUrlReference)CoreOptions.maven().groupId(GROUP_ID).artifactId(ARTIFACT_ID).versionAsInProject().type("zip")).karafVersion(this.getKarafVersion()).useDeployFolder(false).name("Fabric Karaf Distro").unpackDirectory(new File("target/paxexam/unpack/")), KarafDistributionOption.useOwnExamBundlesStartLevel((int)50), this.envAsSystemProperty("FABRIC_ITEST_CONTAINER_TYPE", "child"), this.envAsSystemProperty("FABRIC_ITEST_CONTAINER_NUMBER", "1"), this.envAsSystemProperty("FABRIC_ITEST_SSH_HOSTS"), this.envAsSystemProperty("FABRIC_ITEST_SSH_USERS"), this.envAsSystemProperty("FABRIC_ITEST_SSH_PASSWORDS"), this.envAsSystemProperty("FABRIC_ITEST_SSH_RESOLVER"), KarafDistributionOption.editConfigurationFilePut((String)"etc/system.properties", (String)"patching.disabled", (String)"true"), KarafDistributionOption.editConfigurationFilePut((String)"fabric/import/fabric/profiles/default.profile/org.ops4j.pax.logging.properties", (String)"log4j.rootLogger", (String)"INFO, out, osgi:*"), KarafDistributionOption.editConfigurationFilePut((String)"fabric/import/fabric/profiles/default.profile/org.ops4j.pax.logging.properties", (String)"log4j.appender.out", (String)"org.apache.log4j.RollingFileAppender"), KarafDistributionOption.editConfigurationFilePut((String)"fabric/import/fabric/profiles/default.profile/org.ops4j.pax.logging.properties", (String)"log4j.appender.out.layout", (String)"org.apache.log4j.PatternLayout"), KarafDistributionOption.editConfigurationFilePut((String)"fabric/import/fabric/profiles/default.profile/org.ops4j.pax.logging.properties", (String)"log4j.appender.out.layout.ConversionPattern", (String)"%d{ISO8601} | %-5.5p | %-16.16t | %-32.32c{1} | %-32.32C %4L | %X{bundle.id} - %X{bundle.name} - %X{bundle.version} | %m%n"), KarafDistributionOption.editConfigurationFilePut((String)"fabric/import/fabric/profiles/default.profile/org.ops4j.pax.logging.properties", (String)"log4j.appender.out.maxFileSize", (String)"10MB"), KarafDistributionOption.editConfigurationFilePut((String)"fabric/import/fabric/profiles/default.profile/org.ops4j.pax.logging.properties", (String)"log4j.appender.out.append", (String)"true"), KarafDistributionOption.editConfigurationFilePut((String)"fabric/import/fabric/profiles/default.profile/org.ops4j.pax.logging.properties", (String)"log4j.appender.out.file", (String)"${runtime.home}/data/log/karaf-${runtime.id}.log"), KarafDistributionOption.editConfigurationFilePut((String)"etc/org.apache.felix.fileinstall-deploy.cfg", (String)"felix.fileinstall.active.level", (String)"45"), KarafDistributionOption.editConfigurationFilePut((String)"etc/org.apache.felix.fileinstall-deploy.cfg", (String)"felix.fileinstall.noInitialDelay", (String)"true"), KarafDistributionOption.editConfigurationFilePut((String)"etc/org.apache.felix.fileinstall-deploy.cfg", (String)"felix.fileinstall.poll", (String)"250"), KarafDistributionOption.editConfigurationFilePut((String)"etc/config.properties", (String)"karaf.startlevel.bundle", (String)"50"), KarafDistributionOption.editConfigurationFilePut((String)"etc/config.properties", (String)"karaf.startup.message", (String)"Loading Fabric from: ${runtime.home}"), KarafDistributionOption.editConfigurationFilePut((String)"etc/users.properties", (String)"admin", (String)"admin,admin"), CoreOptions.mavenBundle((String)"io.fabric8.itests.paxexam", (String)"fabric-itests-paxexam-common").versionAsInProject(), CoreOptions.mavenBundle((String)"io.fabric8.tooling.testing", (String)"pax-exam-karaf").versionAsInProject(), new DoNotModifyLogOption(), KarafDistributionOption.keepRuntimeFolder(), KarafDistributionOption.editConfigurationFilePut((String)"fabric/import/fabric/profiles/default.profile/io.fabric8.maven.properties", (String)"io.fabric8.maven.localRepository", (String)"${karaf.data}/repository")};
    }

    protected Option[] managedFabricDistributionConfiguration() {
        return new Option[]{new DefaultCompositeOption(this.fabricDistributionConfiguration()), KarafDistributionOption.editConfigurationFilePut((String)"fabric/import/fabric/profiles/default.profile/io.fabric8.agent.properties", (String)"ignore.probe", (String)"^PAXEXAM-PROBE"), KarafDistributionOption.editConfigurationFilePut((String)"fabric/import/fabric/profiles/default.profile/io.fabric8.agent.properties", (String)"repository.pax-exam", (String)"file:examfeatures.xml"), KarafDistributionOption.editConfigurationFilePut((String)"fabric/import/fabric/profiles/default.profile/io.fabric8.agent.properties", (String)"feature.pax-exam", (String)"exam"), KarafDistributionOption.editConfigurationFilePut((String)"fabric/import/fabric/profiles/default.profile/io.fabric8.agent.properties", (String)"bundle.probe", (String)"local"), KarafDistributionOption.editConfigurationFilePut((String)"fabric/import/fabric/profiles/default.profile/io.fabric8.agent.properties", (String)"bundle.tooling-testing", (String)("mvn:io.fabric8.tooling.testing/pax-exam-karaf/" + MavenUtils.getArtifactVersion((String)"io.fabric8.tooling.testing", (String)"pax-exam-karaf"))), KarafDistributionOption.editConfigurationFilePut((String)"fabric/import/fabric/profiles/default.profile/io.fabric8.agent.properties", (String)"bundle.itests-common", (String)("mvn:io.fabric8.itest.paxexam/fabric-itests-paxexam-common/" + MavenUtils.getArtifactVersion((String)"io.fabric8.itests.paxexam", (String)"fabric-itests-paxexam-common")))};
    }

    private Object getMBean(Container container, ObjectName mbeanName, Class clazz) throws Exception {
        JMXServiceURL url = new JMXServiceURL(container.getJmxUrl());
        HashMap<String, String[]> env = new HashMap<String, String[]>();
        String[] creds = new String[]{"admin", "admin"};
        env.put("jmx.remote.credentials", creds);
        JMXConnector jmxc = JMXConnectorFactory.connect(url, env);
        MBeanServerConnection mbsc = jmxc.getMBeanServerConnection();
        return JMX.newMBeanProxy(mbsc, mbeanName, clazz, true);
    }

    protected Option envAsSystemProperty(String name) {
        return this.envAsSystemProperty(name, "");
    }

    protected Option envAsSystemProperty(String name, String defaultValue) {
        String value = System.getenv(name);
        return KarafDistributionOption.editConfigurationFilePut((String)"etc/system.properties", (String)name, (String)(value != null && !value.isEmpty() ? value : defaultValue));
    }

    protected ServiceProxy<FabricService> fabricServiceProxy() {
        return ServiceProxy.createServiceProxy((BundleContext)this.bundleContext, FabricService.class);
    }
}

