/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.itests.paxexam.support;

import io.fabric8.api.Container;
import io.fabric8.api.CreateContainerBasicOptions;
import io.fabric8.api.CreateContainerMetadata;
import io.fabric8.api.CreateContainerOptions;
import io.fabric8.api.FabricException;
import io.fabric8.api.FabricService;
import io.fabric8.api.ServiceProxy;
import io.fabric8.itests.paxexam.support.ContainerProxy;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;

public class CreateContainerTask
implements Callable<Set<ContainerProxy>> {
    private final ServiceProxy<FabricService> fabricServiceProxy;
    private final CreateContainerBasicOptions options;

    public CreateContainerTask(ServiceProxy<FabricService> fabricServiceProxy, CreateContainerBasicOptions options) {
        this.fabricServiceProxy = fabricServiceProxy;
        this.options = options;
    }

    @Override
    public Set<ContainerProxy> call() throws Exception {
        HashSet<ContainerProxy> containers = new HashSet<ContainerProxy>();
        FabricService fabricService = (FabricService)this.fabricServiceProxy.getService();
        CreateContainerMetadata[] allMetadata = fabricService.createContainers((CreateContainerOptions)this.options);
        if (allMetadata != null && allMetadata.length > 0) {
            for (CreateContainerMetadata metadata : allMetadata) {
                Container container = metadata.getContainer();
                containers.add(ContainerProxy.wrap(container, this.fabricServiceProxy));
                if (metadata.isSuccess()) continue;
                throw new FabricException("Failed to create container.", metadata.getFailure());
            }
        }
        return containers;
    }
}

