/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.itests.paxexam.support;

import io.fabric8.api.Container;
import io.fabric8.api.EnsembleModificationFailed;
import io.fabric8.api.FabricService;
import io.fabric8.itests.paxexam.support.ContainerCallback;
import io.fabric8.itests.paxexam.support.FabricTestSupport;
import io.fabric8.itests.paxexam.support.Provision;
import io.fabric8.tooling.testing.pax.exam.karaf.CommandExecutionException;
import java.util.Arrays;

public class FabricEnsembleTest
extends FabricTestSupport {
    public void addToEnsemble(FabricService fabricService, Container ... containers) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("fabric:ensemble-add --force --migration-timeout 240000 ");
        for (Container c : containers) {
            sb.append(c.getId()).append(" ");
        }
        this.doWithEnsemble(fabricService, sb.toString());
    }

    public void removeFromEnsemble(FabricService fabricService, Container ... containers) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("fabric:ensemble-remove --force --migration-timeout 240000 ");
        for (Container c : containers) {
            sb.append(c.getId()).append(" ");
        }
        this.doWithEnsemble(fabricService, sb.toString());
    }

    private void doWithEnsemble(FabricService fabricService, String command) throws Exception {
        long start = System.currentTimeMillis();
        long now = System.currentTimeMillis();
        boolean keepRunning = true;
        while (!Thread.currentThread().isInterrupted() && keepRunning && now - start <= 30000L) {
            try {
                System.err.println(FabricEnsembleTest.executeCommand((String)command, (long)(240000L - (start - now)), (boolean)false));
                keepRunning = false;
            }
            catch (CommandExecutionException e) {
                if (FabricEnsembleTest.isRetryable(e)) {
                    System.err.println("Not ready for ensemble modification! Retrying...");
                    Provision.provisioningSuccess(Arrays.asList(fabricService.getContainers()), PROVISION_TIMEOUT, ContainerCallback.DISPLAY_ALL);
                    now = System.currentTimeMillis();
                    continue;
                }
                throw e;
            }
        }
    }

    private static boolean isRetryable(Throwable t) {
        if (t instanceof CommandExecutionException) {
            return FabricEnsembleTest.isRetryable(t.getCause());
        }
        if (t instanceof EnsembleModificationFailed) {
            return ((EnsembleModificationFailed)t).getReason() == EnsembleModificationFailed.Reason.CONTAINERS_NOT_ALIVE;
        }
        return false;
    }
}

