/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.itests.paxexam.support;

import io.fabric8.api.Container;
import io.fabric8.api.FabricService;
import io.fabric8.tooling.testing.pax.exam.karaf.ServiceLocator;
import java.util.concurrent.Callable;
import org.osgi.framework.BundleContext;

public class WaitForContainerCreationTask
implements Callable<Boolean> {
    private final FabricService fabricService;
    private final Long provisionTimeOut;
    private final String container;

    public WaitForContainerCreationTask(BundleContext bundleContext, String container, Long provisionTimeOut) {
        this.fabricService = (FabricService)ServiceLocator.awaitService((BundleContext)bundleContext, FabricService.class);
        this.provisionTimeOut = provisionTimeOut;
        this.container = container;
    }

    @Override
    public Boolean call() throws Exception {
        for (long t = 0L; !this.containerExists() && t < this.provisionTimeOut; t += 2000L) {
            Thread.sleep(2000L);
            System.out.println("Container:" + this.container + " Exists:" + this.containerExists());
        }
        return this.containerExists();
    }

    private boolean containerExists() {
        try {
            Container c = this.fabricService.getContainer(this.container);
            return c != null;
        }
        catch (Exception ex) {
            return false;
        }
    }
}

