/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.itests.paxexam.support;

import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class WaitForServiceAddingTask<T>
implements Callable<T> {
    private final Class<T> type;
    private final String filter;
    private final ServiceTracker<T, T> tracker;
    private final CountDownLatch latch = new CountDownLatch(1);
    private final BundleContext bundleContext = FrameworkUtil.getBundle(WaitForServiceAddingTask.class).getBundleContext();

    public WaitForServiceAddingTask(Class<T> type, String filter) throws Exception {
        this.type = type;
        this.filter = filter;
        this.tracker = this.createTracker(type, filter, this.latch);
        this.tracker.open(true);
    }

    private ServiceTracker<T, T> createTracker(Class<T> type, String filter, final CountDownLatch latch) throws InvalidSyntaxException {
        ServiceTracker tracker = new ServiceTracker<T, T>(this.bundleContext, WaitForServiceAddingTask.createFilter(type, filter), null){

            public Object addingService(ServiceReference reference) {
                latch.countDown();
                return super.addingService(reference);
            }
        };
        return tracker;
    }

    private static <T> Filter createFilter(Class<T> type, String filter) throws InvalidSyntaxException {
        String flt = filter != null ? (filter.startsWith("(") ? "(&(objectClass=" + type.getName() + ")" + filter + ")" : "(&(objectClass=" + type.getName() + ")(" + filter + "))") : "(objectClass=" + type.getName() + ")";
        return FrameworkUtil.createFilter((String)flt);
    }

    @Override
    public T call() throws Exception {
        this.latch.await();
        return (T)this.tracker.getService();
    }
}

