package io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GRPCRouteBuilder extends GRPCRouteFluent<GRPCRouteBuilder> implements VisitableBuilder<GRPCRoute,GRPCRouteBuilder>{
  public GRPCRouteBuilder() {
    this(false);
  }
  public GRPCRouteBuilder(Boolean validationEnabled) {
    this(new GRPCRoute(), validationEnabled);
  }
  public GRPCRouteBuilder(GRPCRouteFluent<?> fluent) {
    this(fluent, false);
  }
  public GRPCRouteBuilder(GRPCRouteFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new GRPCRoute(), validationEnabled);
  }
  public GRPCRouteBuilder(GRPCRouteFluent<?> fluent,GRPCRoute instance) {
    this(fluent, instance, false);
  }
  public GRPCRouteBuilder(GRPCRouteFluent<?> fluent,GRPCRoute instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new GRPCRoute());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public GRPCRouteBuilder(GRPCRoute instance) {
    this(instance,false);
  }
  public GRPCRouteBuilder(GRPCRoute instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new GRPCRoute());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  GRPCRouteFluent<?> fluent;
  Boolean validationEnabled;
  public GRPCRoute build() {
    GRPCRoute buildable = new GRPCRoute(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}